/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.OptimisationData;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.linear.LinearStructure;
import org.ojalgo.optimisation.linear.Primitive1D;
import org.ojalgo.optimisation.linear.Primitive2D;
import org.ojalgo.optimisation.linear.SimplexTableau;
import org.ojalgo.optimisation.linear.SimplexTableauSolver;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.context.NumberContext;
import org.ojalgo.type.keyvalue.EntryPair;

final class PrimalSimplex
extends SimplexTableauSolver {
    private static SimplexTableau buildAlt(OptimisationData<Double> convex, Optimisation.Options options, boolean checkFeasibility) {
        int nbVars = convex.countVariables();
        int nbEqus = convex.countEqualityConstraints();
        int nbInes = convex.countInequalityConstraints();
        SimplexTableau retVal = SimplexTableau.make(nbEqus + nbInes, nbVars, 0, nbInes, 0, true, options);
        LinearStructure meta = retVal.meta;
        Primitive2D constraintsBody = retVal.constraintsBody();
        Primitive1D constraintsRHS = retVal.constraintsRHS();
        Primitive1D objective = retVal.objective();
        MatrixStore<Double> convexC = checkFeasibility ? Primitive64Store.FACTORY.makeZero(convex.countVariables(), 1L) : convex.getObjective().getLinearFactors(true);
        for (int v = 0; v < nbVars; ++v) {
            double valC = convexC.doubleValue(v);
            objective.set(v, -valC);
        }
        MatrixStore<Double> convexAE = convex.getAE();
        MatrixStore<Double> convexBE = convex.getBE();
        for (int i = 0; i < nbEqus; ++i) {
            double d = convexBE.doubleValue(i);
            meta.negatedDual[i] = NumberContext.compare(d, PrimitiveMath.ZERO) < 0;
            boolean neg = meta.negatedDual[i];
            for (int j = 0; j < nbVars; ++j) {
                double valA = convexAE.doubleValue(i, j);
                constraintsBody.set(i, j, neg ? -valA : valA);
            }
            constraintsRHS.set(i, neg ? -d : d);
        }
        for (Access2D.RowView rowView : convex.getRowsAI()) {
            int r = Math.toIntExact(rowView.row());
            double rhs = convex.getBI(r);
            boolean bl = NumberContext.compare(rhs, PrimitiveMath.ZERO) < 0;
            meta.negatedDual[nbEqus + r] = bl;
            boolean neg = bl;
            rowView.nonzeros().forEach(nz -> constraintsBody.set((long)(nbEqus + r), nz.index(), neg ? -nz.doubleValue() : nz.doubleValue()));
            constraintsBody.set(nbEqus + r, nbVars + nbVars + r, neg ? PrimitiveMath.NEG : PrimitiveMath.ONE);
            constraintsRHS.set(nbEqus + r, neg ? -rhs : rhs);
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    private static SimplexTableau buildOldVersion(ExpressionsBasedModel model) {
        void var29_50;
        int tmpNegInd;
        int tmpPosInd;
        int tmpNegInd2;
        int tmpPosInd2;
        int tmpNegInd3;
        List<Variable> posVariables = model.getPositiveVariables();
        List<Variable> negVariables = model.getNegativeVariables();
        Set<Structure1D.IntIndex> fixedVariables = model.getFixedVariables();
        Expression objFunc = model.objective().compensate(fixedVariables);
        List tmpExprsEq = model.constraints().filter(c -> c.isEqualityConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        List tmpExprsLo = model.constraints().filter(c -> c.isLowerConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        List tmpExprsUp = model.constraints().filter(c -> c.isUpperConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        List tmpVarsPosLo = model.bounds().filter(v -> v.isPositive() && v.isLowerConstraint() && v.getLowerLimit().signum() > 0).collect(Collectors.toList());
        List tmpVarsPosUp = model.bounds().filter(v -> v.isPositive() && v.isUpperConstraint() && v.getUpperLimit().signum() > 0).collect(Collectors.toList());
        List tmpVarsNegLo = model.bounds().filter(v -> v.isNegative() && v.isLowerConstraint() && v.getLowerLimit().signum() < 0).collect(Collectors.toList());
        List tmpVarsNegUp = model.bounds().filter(v -> v.isNegative() && v.isUpperConstraint() && v.getUpperLimit().signum() < 0).collect(Collectors.toList());
        int nbConstraints = tmpExprsEq.size() + tmpExprsLo.size() + tmpExprsUp.size() + tmpVarsPosLo.size() + tmpVarsPosUp.size() + tmpVarsNegLo.size() + tmpVarsNegUp.size();
        int nbProbVars = posVariables.size() + negVariables.size();
        int nbSlackVars = tmpExprsLo.size() + tmpExprsUp.size() + tmpVarsPosLo.size() + tmpVarsPosUp.size() + tmpVarsNegLo.size() + tmpVarsNegUp.size();
        boolean nbIdentitySlackVars = false;
        boolean needDuals = false;
        SimplexTableau retVal = SimplexTableau.make(nbConstraints, nbProbVars, 0, nbSlackVars, 0, false, model.options);
        int tmpPosVarsBaseIndex = 0;
        int tmpNegVarsBaseIndex = tmpPosVarsBaseIndex + posVariables.size();
        int tmpSlaVarsBaseIndex = tmpNegVarsBaseIndex + negVariables.size();
        for (Structure1D.IntIndex tmpKey : objFunc.getLinearKeySet()) {
            int tmpNegInd4;
            double tmpFactor = model.getOptimisationSense() == Optimisation.Sense.MAX ? -objFunc.getAdjustedLinearFactor(tmpKey) : objFunc.getAdjustedLinearFactor(tmpKey);
            int tmpPosInd3 = model.indexOfPositiveVariable(tmpKey.index);
            if (tmpPosInd3 >= 0) {
                retVal.objective().set(tmpPosInd3, tmpFactor);
            }
            if ((tmpNegInd4 = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
            retVal.objective().set(tmpNegVarsBaseIndex + tmpNegInd4, -tmpFactor);
        }
        int tmpConstrBaseIndex = 0;
        int tmpCurrentSlackVarIndex = tmpSlaVarsBaseIndex;
        int tmpExprsEqLength = tmpExprsEq.size();
        for (int c2 = 0; c2 < tmpExprsEqLength; ++c2) {
            double tmpFactor;
            Expression tmpExpr = ((Expression)tmpExprsEq.get(c2)).compensate(fixedVariables);
            double tmpRHS = tmpExpr.getAdjustedLowerLimit();
            if (tmpRHS < PrimitiveMath.ZERO) {
                retVal.constraintsRHS().set(tmpConstrBaseIndex + c2, -tmpRHS);
                for (Structure1D.IntIndex intIndex : tmpExpr.getLinearKeySet()) {
                    tmpFactor = tmpExpr.getAdjustedLinearFactor(intIndex);
                    int tmpPosInd3 = model.indexOfPositiveVariable(intIndex.index);
                    if (tmpPosInd3 >= 0) {
                        retVal.constraintsBody().set(tmpConstrBaseIndex + c2, tmpPosVarsBaseIndex + tmpPosInd3, -tmpFactor);
                    }
                    if ((tmpNegInd3 = model.indexOfNegativeVariable(intIndex.index)) < 0) continue;
                    retVal.constraintsBody().set(tmpConstrBaseIndex + c2, tmpNegVarsBaseIndex + tmpNegInd3, tmpFactor);
                }
                continue;
            }
            retVal.constraintsRHS().set(tmpConstrBaseIndex + c2, tmpRHS);
            for (Structure1D.IntIndex intIndex : tmpExpr.getLinearKeySet()) {
                int tmpNegInd32;
                tmpFactor = tmpExpr.getAdjustedLinearFactor(intIndex);
                int tmpPosInd4 = model.indexOfPositiveVariable(intIndex.index);
                if (tmpPosInd4 >= 0) {
                    retVal.constraintsBody().set(tmpConstrBaseIndex + c2, tmpPosVarsBaseIndex + tmpPosInd4, tmpFactor);
                }
                if ((tmpNegInd32 = model.indexOfNegativeVariable(intIndex.index)) < 0) continue;
                retVal.constraintsBody().set(tmpConstrBaseIndex + c2, tmpNegVarsBaseIndex + tmpNegInd32, -tmpFactor);
            }
        }
        tmpConstrBaseIndex += tmpExprsEqLength;
        int tmpExprsLoLength = tmpExprsLo.size();
        for (int c3 = 0; c3 < tmpExprsLoLength; ++c3) {
            double tmpFactor;
            Expression tmpExpr = ((Expression)tmpExprsLo.get(c3)).compensate(fixedVariables);
            double tmpRHS = tmpExpr.getAdjustedLowerLimit();
            if (tmpRHS < PrimitiveMath.ZERO) {
                retVal.constraintsRHS().set(tmpConstrBaseIndex + c3, -tmpRHS);
                for (Structure1D.IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                    tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                    tmpPosInd2 = model.indexOfPositiveVariable(tmpKey.index);
                    if (tmpPosInd2 >= 0) {
                        retVal.constraintsBody().set(tmpConstrBaseIndex + c3, tmpPosVarsBaseIndex + tmpPosInd2, -tmpFactor);
                    }
                    if ((tmpNegInd2 = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                    retVal.constraintsBody().set(tmpConstrBaseIndex + c3, tmpNegVarsBaseIndex + tmpNegInd2, tmpFactor);
                }
                retVal.constraintsBody().set(tmpConstrBaseIndex + c3, tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
                continue;
            }
            retVal.constraintsRHS().set(tmpConstrBaseIndex + c3, tmpRHS);
            for (Structure1D.IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                int tmpNegInd22;
                tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                int tmpPosInd22 = model.indexOfPositiveVariable(tmpKey.index);
                if (tmpPosInd22 >= 0) {
                    retVal.constraintsBody().set(tmpConstrBaseIndex + c3, tmpPosVarsBaseIndex + tmpPosInd22, tmpFactor);
                }
                if ((tmpNegInd22 = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                retVal.constraintsBody().set(tmpConstrBaseIndex + c3, tmpNegVarsBaseIndex + tmpNegInd22, -tmpFactor);
            }
            retVal.constraintsBody().set(tmpConstrBaseIndex + c3, tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
        }
        tmpConstrBaseIndex += tmpExprsLoLength;
        int tmpExprsUpLength = tmpExprsUp.size();
        for (int c4 = 0; c4 < tmpExprsUpLength; ++c4) {
            double tmpFactor;
            Expression tmpExpr = ((Expression)tmpExprsUp.get(c4)).compensate(fixedVariables);
            double tmpRHS = tmpExpr.getAdjustedUpperLimit();
            if (tmpRHS < PrimitiveMath.ZERO) {
                retVal.constraintsRHS().set(tmpConstrBaseIndex + c4, -tmpRHS);
                for (Structure1D.IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                    tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                    tmpPosInd = model.indexOfPositiveVariable(tmpKey.index);
                    if (tmpPosInd >= 0) {
                        retVal.constraintsBody().set(tmpConstrBaseIndex + c4, tmpPosVarsBaseIndex + tmpPosInd, -tmpFactor);
                    }
                    if ((tmpNegInd = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                    retVal.constraintsBody().set(tmpConstrBaseIndex + c4, tmpNegVarsBaseIndex + tmpNegInd, tmpFactor);
                }
                retVal.constraintsBody().set(tmpConstrBaseIndex + c4, tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
                continue;
            }
            retVal.constraintsRHS().set(tmpConstrBaseIndex + c4, tmpRHS);
            for (Structure1D.IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                tmpPosInd = model.indexOfPositiveVariable(tmpKey.index);
                if (tmpPosInd >= 0) {
                    retVal.constraintsBody().set(tmpConstrBaseIndex + c4, tmpPosVarsBaseIndex + tmpPosInd, tmpFactor);
                }
                if ((tmpNegInd = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                retVal.constraintsBody().set(tmpConstrBaseIndex + c4, tmpNegVarsBaseIndex + tmpNegInd, -tmpFactor);
            }
            retVal.constraintsBody().set(tmpConstrBaseIndex + c4, tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
        }
        tmpConstrBaseIndex += tmpExprsUpLength;
        int tmpVarsPosLoLength = tmpVarsPosLo.size();
        for (int c5 = 0; c5 < tmpVarsPosLoLength; ++c5) {
            Variable tmpVar = (Variable)tmpVarsPosLo.get(c5);
            retVal.constraintsRHS().set(tmpConstrBaseIndex + c5, tmpVar.getAdjustedLowerLimit());
            int n = model.indexOf(tmpVar);
            double tmpFactor = tmpVar.getAdjustmentFactor();
            int tmpPosInd5 = model.indexOfPositiveVariable(n);
            if (tmpPosInd5 >= 0) {
                retVal.constraintsBody().set(tmpConstrBaseIndex + c5, tmpPosVarsBaseIndex + tmpPosInd5, tmpFactor);
            }
            if ((tmpNegInd3 = model.indexOfNegativeVariable(n)) >= 0) {
                retVal.constraintsBody().set(tmpConstrBaseIndex + c5, tmpNegVarsBaseIndex + tmpNegInd3, -tmpFactor);
            }
            retVal.constraintsBody().set(tmpConstrBaseIndex + c5, tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
        }
        tmpConstrBaseIndex += tmpVarsPosLoLength;
        int tmpVarsPosUpLength = tmpVarsPosUp.size();
        for (int c6 = 0; c6 < tmpVarsPosUpLength; ++c6) {
            Variable variable = (Variable)tmpVarsPosUp.get(c6);
            retVal.constraintsRHS().set(tmpConstrBaseIndex + c6, variable.getAdjustedUpperLimit());
            int tmpKey = model.indexOf(variable);
            double tmpFactor = variable.getAdjustmentFactor();
            tmpPosInd2 = model.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd2 >= 0) {
                retVal.constraintsBody().set(tmpConstrBaseIndex + c6, tmpPosVarsBaseIndex + tmpPosInd2, tmpFactor);
            }
            if ((tmpNegInd2 = model.indexOfNegativeVariable(tmpKey)) >= 0) {
                retVal.constraintsBody().set(tmpConstrBaseIndex + c6, tmpNegVarsBaseIndex + tmpNegInd2, -tmpFactor);
            }
            retVal.constraintsBody().set(tmpConstrBaseIndex + c6, tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
        }
        tmpConstrBaseIndex += tmpVarsPosUpLength;
        int tmpVarsNegLoLength = tmpVarsNegLo.size();
        boolean bl = false;
        while (var29_50 < tmpVarsNegLoLength) {
            Variable tmpVar = (Variable)tmpVarsNegLo.get((int)var29_50);
            retVal.constraintsRHS().set(tmpConstrBaseIndex + var29_50, -tmpVar.getAdjustedLowerLimit());
            int tmpKey = model.indexOf(tmpVar);
            double tmpFactor = tmpVar.getAdjustmentFactor();
            tmpPosInd = model.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd >= 0) {
                retVal.constraintsBody().set(tmpConstrBaseIndex + var29_50, tmpPosVarsBaseIndex + tmpPosInd, -tmpFactor);
            }
            if ((tmpNegInd = model.indexOfNegativeVariable(tmpKey)) >= 0) {
                retVal.constraintsBody().set(tmpConstrBaseIndex + var29_50, tmpNegVarsBaseIndex + tmpNegInd, tmpFactor);
            }
            retVal.constraintsBody().set(tmpConstrBaseIndex + var29_50, tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
            ++var29_50;
        }
        tmpConstrBaseIndex += tmpVarsNegLoLength;
        int n = tmpVarsNegUp.size();
        for (int c8 = 0; c8 < n; ++c8) {
            int tmpNegInd5;
            Variable tmpVar = (Variable)tmpVarsNegUp.get(c8);
            retVal.constraintsRHS().set(tmpConstrBaseIndex + c8, -tmpVar.getAdjustedUpperLimit());
            int tmpKey = model.indexOf(tmpVar);
            double tmpFactor = tmpVar.getAdjustmentFactor();
            int tmpPosInd6 = model.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd6 >= 0) {
                retVal.constraintsBody().set(tmpConstrBaseIndex + c8, tmpPosVarsBaseIndex + tmpPosInd6, -tmpFactor);
            }
            if ((tmpNegInd5 = model.indexOfNegativeVariable(tmpKey)) >= 0) {
                retVal.constraintsBody().set(tmpConstrBaseIndex + c8, tmpNegVarsBaseIndex + tmpNegInd5, tmpFactor);
            }
            retVal.constraintsBody().set(tmpConstrBaseIndex + c8, tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
        }
        tmpConstrBaseIndex += n;
        return retVal;
    }

    private static void set(ExpressionsBasedModel model, Primitive2D constraintsBdy, int indCnstr, int basePosVars, int baseNegVars, Structure1D.IntIndex key, double factor) {
        int tmpNegInd;
        int tmpPosInd = model.indexOfPositiveVariable(key);
        if (tmpPosInd >= 0) {
            constraintsBdy.set(indCnstr, basePosVars + tmpPosInd, factor);
        }
        if ((tmpNegInd = model.indexOfNegativeVariable(key)) >= 0) {
            constraintsBdy.set(indCnstr, baseNegVars + tmpNegInd, -factor);
        }
    }

    private static void set(ExpressionsBasedModel model, Primitive2D constraintsBdy, int indCnstr, int basePosVars, int baseNegVars, Variable variable, double factor) {
        int tmpNegInd;
        int tmpPosInd = model.indexOfPositiveVariable(variable);
        if (tmpPosInd >= 0) {
            constraintsBdy.set(indCnstr, basePosVars + tmpPosInd, factor);
        }
        if ((tmpNegInd = model.indexOfNegativeVariable(variable)) >= 0) {
            constraintsBdy.set(indCnstr, baseNegVars + tmpNegInd, -factor);
        }
    }

    private static int sizeAlt(OptimisationData convex) {
        int numbVars = convex.countVariables();
        int numbEqus = convex.countEqualityConstraints();
        int numbInes = convex.countInequalityConstraints();
        return SimplexTableau.size(numbEqus + numbInes, numbVars, numbInes, 0, true);
    }

    private static Optimisation.Result toConvexStateAlt(final Optimisation.Result result, OptimisationData convex) {
        final int nbVars = convex.countVariables();
        Optimisation.Result retVal = new Optimisation.Result(result.getState(), result.getValue(), new Primitive1D(){

            @Override
            public int size() {
                return nbVars;
            }

            @Override
            double doubleValue(int index) {
                return result.doubleValue(index);
            }

            @Override
            void set(int index, double value) {
                throw new IllegalArgumentException();
            }
        });
        retVal.multipliers(result.getMultipliers().get());
        return retVal;
    }

    static SimplexTableau build(OptimisationData<Double> convex, Optimisation.Options options, boolean checkFeasibility) {
        int nbVars = convex.countVariables();
        int nbEqus = convex.countEqualityConstraints();
        int nbInes = convex.countInequalityConstraints();
        SimplexTableau retVal = SimplexTableau.make(nbEqus + nbInes, nbVars + nbVars, 0, nbInes, 0, true, options);
        LinearStructure meta = retVal.meta;
        Primitive2D constraintsBody = retVal.constraintsBody();
        Primitive1D constraintsRHS = retVal.constraintsRHS();
        Primitive1D objective = retVal.objective();
        MatrixStore<Double> convexC = checkFeasibility ? Primitive64Store.FACTORY.makeZero(convex.countVariables(), 1L) : convex.getObjective().getLinearFactors(true);
        for (int v = 0; v < nbVars; ++v) {
            double valC = convexC.doubleValue(v);
            objective.set(v, -valC);
            objective.set(nbVars + v, valC);
        }
        MatrixStore<Double> convexAE = convex.getAE();
        MatrixStore<Double> convexBE = convex.getBE();
        for (int i = 0; i < nbEqus; ++i) {
            double d = convexBE.doubleValue(i);
            meta.negatedDual[i] = NumberContext.compare(d, PrimitiveMath.ZERO) < 0;
            boolean neg = meta.negatedDual[i];
            for (int j = 0; j < nbVars; ++j) {
                double valA = convexAE.doubleValue(i, j);
                constraintsBody.set(i, j, neg ? -valA : valA);
                constraintsBody.set(i, nbVars + j, neg ? valA : -valA);
            }
            constraintsRHS.set(i, neg ? -d : d);
        }
        for (Access2D.RowView rowView : convex.getRowsAI()) {
            int r = Math.toIntExact(rowView.row());
            double rhs = convex.getBI(r);
            boolean bl = NumberContext.compare(rhs, PrimitiveMath.ZERO) < 0;
            meta.negatedDual[nbEqus + r] = bl;
            boolean neg = bl;
            rowView.nonzeros().forEach(nz -> constraintsBody.set((long)(nbEqus + r), nz.index(), neg ? -nz.doubleValue() : nz.doubleValue()));
            rowView.nonzeros().forEach(nz -> constraintsBody.set((long)(nbEqus + r), (long)nbVars + nz.index(), neg ? nz.doubleValue() : -nz.doubleValue()));
            constraintsBody.set(nbEqus + r, nbVars + nbVars + r, neg ? PrimitiveMath.NEG : PrimitiveMath.ONE);
            constraintsRHS.set(nbEqus + r, neg ? -rhs : rhs);
        }
        return retVal;
    }

    static SimplexTableau build(ExpressionsBasedModel model) {
        double rhs;
        double factor;
        int i;
        List<Variable> posVariables = model.getPositiveVariables();
        List<Variable> negVariables = model.getNegativeVariables();
        Set<Structure1D.IntIndex> fixedVariables = model.getFixedVariables();
        for (Variable pos : posVariables) {
            if (!pos.isEqualityConstraint()) continue;
            BasicLogger.debug(pos);
        }
        for (Variable neg : negVariables) {
            if (!neg.isEqualityConstraint()) continue;
            BasicLogger.debug(neg);
        }
        List bounds = model.bounds().collect(Collectors.toList());
        ArrayList<Variable> varsPosUp = new ArrayList<Variable>();
        ArrayList<Variable> varsPosLo = new ArrayList<Variable>();
        ArrayList<Variable> varsNegUp = new ArrayList<Variable>();
        ArrayList<Variable> varsNegLo = new ArrayList<Variable>();
        for (Variable variable : bounds) {
            if (variable.isPositive()) {
                if (variable.isUpperConstraint() && variable.getUpperLimit().signum() > 0) {
                    varsPosUp.add(variable);
                }
                if (variable.isLowerConstraint() && variable.getLowerLimit().signum() > 0) {
                    varsPosLo.add(variable);
                }
            }
            if (!variable.isNegative()) continue;
            if (variable.isUpperConstraint() && variable.getUpperLimit().signum() < 0) {
                varsNegUp.add(variable);
            }
            if (!variable.isLowerConstraint() || variable.getLowerLimit().signum() >= 0) continue;
            varsNegLo.add(variable);
        }
        List constraints = model.constraints().map(c -> c.compensate(fixedVariables)).collect(Collectors.toList());
        ArrayList<Expression> exprUpPos = new ArrayList<Expression>();
        ArrayList<Expression> exprUpNeg = new ArrayList<Expression>();
        ArrayList<Expression> exprLoPos = new ArrayList<Expression>();
        ArrayList<Expression> exprLoNeg = new ArrayList<Expression>();
        ArrayList<Expression> exprEqPos = new ArrayList<Expression>();
        ArrayList<Expression> exprEqNeg = new ArrayList<Expression>();
        for (Expression expression : constraints) {
            if (expression.isEqualityConstraint()) {
                if (expression.getUpperLimit().signum() < 0) {
                    exprEqNeg.add(expression);
                    continue;
                }
                exprEqPos.add(expression);
                continue;
            }
            if (expression.isLowerConstraint()) {
                if (expression.getLowerLimit().signum() < 0) {
                    exprLoNeg.add(expression);
                } else {
                    exprLoPos.add(expression);
                }
            }
            if (!expression.isUpperConstraint()) continue;
            if (expression.getUpperLimit().signum() < 0) {
                exprUpNeg.add(expression);
                continue;
            }
            exprUpPos.add(expression);
        }
        Expression objective = model.objective().compensate(fixedVariables);
        int nbPosProbVars = posVariables.size();
        int nbNegProbVars = negVariables.size();
        int nbIdentitySlackVars = exprUpPos.size() + exprLoNeg.size() + varsPosUp.size() + varsNegLo.size();
        int nbOtherSlackVars = exprUpNeg.size() + exprLoPos.size() + varsNegUp.size() + varsPosLo.size();
        int nbConstraints = nbIdentitySlackVars + nbOtherSlackVars + exprEqPos.size() + exprEqNeg.size();
        boolean needDuals = false;
        SimplexTableau retVal = SimplexTableau.make(nbConstraints, nbPosProbVars, nbNegProbVars, nbOtherSlackVars, nbIdentitySlackVars, needDuals, model.options);
        LinearStructure meta = retVal.meta;
        Primitive2D retConstraintsBdy = retVal.constraintsBody();
        Primitive1D retConstraintsRHS = retVal.constraintsRHS();
        Primitive1D retObjective = retVal.objective();
        int basePosVars = 0;
        int baseNegVars = nbPosProbVars;
        int baseSlackVars = baseNegVars + nbNegProbVars;
        int baseIdSlackVars = baseSlackVars + nbOtherSlackVars;
        int baseArtificialVars = baseIdSlackVars + nbIdentitySlackVars;
        for (i = 0; i < posVariables.size(); ++i) {
            meta.positivePartVariables[i] = model.indexOf(posVariables.get(i));
        }
        for (i = 0; i < negVariables.size(); ++i) {
            meta.negativePartVariables[i] = model.indexOf(negVariables.get(i));
        }
        for (Structure1D.IntIndex tmpKey : objective.getLinearKeySet()) {
            int tmpNegInd;
            double tmpFactor = model.getOptimisationSense() == Optimisation.Sense.MAX ? -objective.getAdjustedLinearFactor(tmpKey) : objective.getAdjustedLinearFactor(tmpKey);
            int tmpPosInd = model.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd >= 0) {
                retObjective.set(basePosVars + tmpPosInd, tmpFactor);
            }
            if ((tmpNegInd = model.indexOfNegativeVariable(tmpKey)) < 0) continue;
            retObjective.set(baseNegVars + tmpNegInd, -tmpFactor);
        }
        int indCnstr = 0;
        int indSlack = baseIdSlackVars;
        for (Expression expression : exprUpPos) {
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                factor = expression.getAdjustedLinearFactor(key);
                PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, key, factor);
            }
            retConstraintsBdy.set(indCnstr, indSlack, PrimitiveMath.ONE);
            double rhs2 = expression.getAdjustedUpperLimit();
            retConstraintsRHS.set(indCnstr, rhs2);
            meta.slack[indSlack - baseSlackVars] = EntryPair.of(expression, Optimisation.ConstraintType.UPPER);
            ++indCnstr;
            ++indSlack;
        }
        for (Expression expression : exprLoNeg) {
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                factor = -expression.getAdjustedLinearFactor(key);
                PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, key, factor);
            }
            retConstraintsBdy.set(indCnstr, indSlack, PrimitiveMath.ONE);
            double rhs3 = -expression.getAdjustedLowerLimit();
            retConstraintsRHS.set(indCnstr, rhs3);
            meta.slack[indSlack - baseSlackVars] = EntryPair.of(expression, Optimisation.ConstraintType.LOWER);
            ++indCnstr;
            ++indSlack;
        }
        for (Variable variable : varsPosUp) {
            double factor2 = variable.getAdjustmentFactor();
            PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, variable, factor2);
            retConstraintsBdy.set(indCnstr, indSlack, PrimitiveMath.ONE);
            rhs = variable.getAdjustedUpperLimit();
            retConstraintsRHS.set(indCnstr, rhs);
            meta.slack[indSlack - baseSlackVars] = EntryPair.of(variable, Optimisation.ConstraintType.UPPER);
            ++indCnstr;
            ++indSlack;
        }
        for (Variable variable : varsNegLo) {
            double factor3 = -variable.getAdjustmentFactor();
            PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, variable, factor3);
            retConstraintsBdy.set(indCnstr, indSlack, PrimitiveMath.ONE);
            rhs = -variable.getAdjustedLowerLimit();
            retConstraintsRHS.set(indCnstr, rhs);
            meta.slack[indSlack - baseSlackVars] = EntryPair.of(variable, Optimisation.ConstraintType.LOWER);
            ++indCnstr;
            ++indSlack;
        }
        indSlack = baseSlackVars;
        for (Expression expression : exprLoPos) {
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                factor = expression.getAdjustedLinearFactor(key);
                PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, key, factor);
            }
            retConstraintsBdy.set(indCnstr, indSlack, PrimitiveMath.NEG);
            double rhs4 = expression.getAdjustedLowerLimit();
            retConstraintsRHS.set(indCnstr, rhs4);
            meta.slack[indSlack - baseSlackVars] = EntryPair.of(expression, Optimisation.ConstraintType.LOWER);
            ++indCnstr;
            ++indSlack;
        }
        for (Expression expression : exprUpNeg) {
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                factor = -expression.getAdjustedLinearFactor(key);
                PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, key, factor);
            }
            retConstraintsBdy.set(indCnstr, indSlack, PrimitiveMath.NEG);
            double rhs5 = -expression.getAdjustedUpperLimit();
            retConstraintsRHS.set(indCnstr, rhs5);
            meta.slack[indSlack - baseSlackVars] = EntryPair.of(expression, Optimisation.ConstraintType.UPPER);
            ++indCnstr;
            ++indSlack;
        }
        for (Variable variable : varsPosLo) {
            double factor4 = variable.getAdjustmentFactor();
            PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, variable, factor4);
            retConstraintsBdy.set(indCnstr, indSlack, PrimitiveMath.NEG);
            rhs = variable.getAdjustedLowerLimit();
            retConstraintsRHS.set(indCnstr, rhs);
            meta.slack[indSlack - baseSlackVars] = EntryPair.of(variable, Optimisation.ConstraintType.LOWER);
            ++indCnstr;
            ++indSlack;
        }
        for (Variable variable : varsNegUp) {
            double factor5 = -variable.getAdjustmentFactor();
            PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, variable, factor5);
            retConstraintsBdy.set(indCnstr, indSlack, PrimitiveMath.NEG);
            rhs = -variable.getAdjustedUpperLimit();
            retConstraintsRHS.set(indCnstr, rhs);
            meta.slack[indSlack - baseSlackVars] = EntryPair.of(variable, Optimisation.ConstraintType.UPPER);
            ++indCnstr;
            ++indSlack;
        }
        indSlack = Integer.MAX_VALUE;
        for (Expression expression : exprEqPos) {
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                factor = expression.getAdjustedLinearFactor(key);
                PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, key, factor);
            }
            double rhs6 = expression.getAdjustedUpperLimit();
            retConstraintsRHS.set(indCnstr, rhs6);
            ++indCnstr;
        }
        for (Expression expression : exprEqNeg) {
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                factor = -expression.getAdjustedLinearFactor(key);
                PrimalSimplex.set(model, retConstraintsBdy, indCnstr, basePosVars, baseNegVars, key, factor);
            }
            double rhs7 = -expression.getAdjustedLowerLimit();
            retConstraintsRHS.set(indCnstr, rhs7);
            ++indCnstr;
        }
        return retVal;
    }

    static Optimisation.Result doSolve(OptimisationData convex, Optimisation.Options options, boolean zeroC) {
        SimplexTableau tableau = PrimalSimplex.build(convex, options, zeroC);
        PrimalSimplex solver = new PrimalSimplex(tableau, options);
        Optimisation.Result result = solver.solve();
        return PrimalSimplex.toConvexState(result, convex);
    }

    static int size(OptimisationData convex) {
        int numbVars = convex.countVariables();
        int numbEqus = convex.countEqualityConstraints();
        int numbInes = convex.countInequalityConstraints();
        return SimplexTableau.size(numbEqus + numbInes, numbVars + numbVars, numbInes, 0, true);
    }

    static Optimisation.Result toConvexState(final Optimisation.Result result, OptimisationData convex) {
        final int nbVars = convex.countVariables();
        Optimisation.Result retVal = new Optimisation.Result(result.getState(), result.getValue(), new Primitive1D(){

            @Override
            public int size() {
                return nbVars;
            }

            @Override
            double doubleValue(int index) {
                return result.doubleValue(index) - result.doubleValue(nbVars + index);
            }

            @Override
            void set(int index, double value) {
                throw new IllegalArgumentException();
            }
        });
        retVal.multipliers(result.getMultipliers().get());
        return retVal;
    }

    PrimalSimplex(SimplexTableau tableau, Optimisation.Options solverOptions) {
        super(tableau, solverOptions);
    }
}

