/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.CorePrimitiveOperation;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.optimisation.linear.LinearStructure;
import org.ojalgo.optimisation.linear.Primitive1D;
import org.ojalgo.optimisation.linear.Primitive2D;
import org.ojalgo.optimisation.linear.SimplexSolver;
import org.ojalgo.optimisation.linear.SimplexStore;
import org.ojalgo.optimisation.linear.TableauCutGenerator;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

final class TableauStore
extends SimplexStore
implements Access2D<Double> {
    private final int myColDim;
    private transient Primitive2D myConstraintsBody = null;
    private transient Primitive1D myConstraintsRHS = null;
    private double[] myCopiedObjectiveRow = null;
    private transient Primitive1D myObjective = null;
    private final double[][] myTableau = new double[this.m + 1][this.n + 1];

    private static void pivotRow(double[] dataRow, int col, double[] pivotRow, int length) {
        double dataElement = dataRow[col];
        if (dataElement != PrimitiveMath.ZERO) {
            AXPY.invoke(dataRow, 0, -dataElement, pivotRow, 0, 0, length);
        }
    }

    static TableauStore build(ExpressionsBasedModel model) {
        return SimplexStore.build(model, TableauStore::new);
    }

    static TableauStore build(LinearSolver.GeneralBuilder builder, int ... basis) {
        return SimplexStore.build(builder, TableauStore::new, basis);
    }

    TableauStore(int mm, int nn) {
        this(new LinearStructure(mm, nn));
    }

    TableauStore(LinearStructure structure) {
        super(structure);
        this.myColDim = this.n + 1;
    }

    @Override
    public long countColumns() {
        return this.getColDim();
    }

    @Override
    public long countRows() {
        return this.getRowDim();
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.doubleValue(Math.toIntExact(row), Math.toIntExact(col));
    }

    @Override
    public Double get(long row, long col) {
        return this.doubleValue(row, col);
    }

    @Override
    public int getColDim() {
        return this.myColDim;
    }

    @Override
    public int getRowDim() {
        return this.myTableau.length;
    }

    private Primitive2D newConstraintsBody() {
        final double[][] store = this.myTableau;
        return new Primitive2D(){

            @Override
            public double doubleValue(int row, int col) {
                return store[row][col];
            }

            @Override
            public int getColDim() {
                return TableauStore.this.n;
            }

            @Override
            public int getRowDim() {
                return TableauStore.this.m;
            }

            @Override
            public void set(int row, int col, double value) {
                store[row][col] = value;
            }
        };
    }

    private Primitive1D newConstraintsRHS() {
        final double[][] store = this.myTableau;
        return new Primitive1D(){

            @Override
            public double doubleValue(int index) {
                return store[index][TableauStore.this.n];
            }

            @Override
            public void set(int index, double value) {
                store[index][TableauStore.this.n] = value;
            }

            @Override
            public int size() {
                return TableauStore.this.m;
            }
        };
    }

    private Primitive1D newObjective() {
        final double[][] store = this.myTableau;
        return new Primitive1D(){

            @Override
            public double doubleValue(int index) {
                return store[TableauStore.this.m][index];
            }

            @Override
            public void set(int index, double value) {
                store[TableauStore.this.m][index] = value;
            }

            @Override
            public int size() {
                return TableauStore.this.structure().countModelVariables();
            }
        };
    }

    private void pivot(int row, int col) {
        double[] pivotRow = this.myTableau[row];
        double pivotElement = pivotRow[col];
        if (pivotElement != PrimitiveMath.ONE) {
            CorePrimitiveOperation.divide(pivotRow, 0, this.myColDim, 1, pivotRow, pivotElement);
        }
        int limit = this.myTableau.length;
        for (int i = 0; i < limit; ++i) {
            if (i == row) continue;
            TableauStore.pivotRow(this.myTableau[i], col, pivotRow, this.myColDim);
        }
        if (this.myCopiedObjectiveRow != null) {
            TableauStore.pivotRow(this.myCopiedObjectiveRow, col, pivotRow, this.myColDim);
        }
    }

    @Override
    protected void pivot(SimplexSolver.IterDescr iteration) {
        int row = iteration.exit.index;
        int col = iteration.enter.column();
        this.pivot(row, col);
        super.pivot(iteration);
    }

    @Override
    protected void shiftColumn(int col, double shift) {
        super.shiftColumn(col, shift);
        for (int i = 0; i < this.m; ++i) {
            double[] dArray = this.myTableau[i];
            int n = this.n;
            dArray[n] = dArray[n] - shift * this.myTableau[i][col];
        }
    }

    @Override
    void calculateDualDirection(SimplexSolver.ExitInfo exit) {
    }

    @Override
    void calculateIteration() {
    }

    @Override
    void calculateIteration(SimplexSolver.IterDescr iteration) {
    }

    @Override
    void calculatePrimalDirection(SimplexSolver.EnterInfo enter) {
    }

    @Override
    Primitive2D constraintsBody() {
        if (this.myConstraintsBody == null) {
            this.myConstraintsBody = this.newConstraintsBody();
        }
        return this.myConstraintsBody;
    }

    @Override
    Primitive1D constraintsRHS() {
        if (this.myConstraintsRHS == null) {
            this.myConstraintsRHS = this.newConstraintsRHS();
        }
        return this.myConstraintsRHS;
    }

    @Override
    void copyBasicSolution(double[] solution) {
        for (int i = 0; i < this.included.length; ++i) {
            solution[this.included[i]] = this.myTableau[i][this.n];
        }
    }

    @Override
    void copyObjective() {
        this.myCopiedObjectiveRow = Arrays.copyOf(this.myTableau[this.m], this.myColDim);
    }

    double doubleValue(int row, int col) {
        return this.myTableau[row][col];
    }

    @Override
    double extractValue() {
        double retVal = -this.myTableau[this.m][this.n];
        int[] lower = this.getExcludedLower();
        for (int i = 0; i < lower.length; ++i) {
            double bound = this.getLowerBound(lower[i]);
            if (bound == PrimitiveMath.ZERO) continue;
            retVal += bound * this.myTableau[this.m][lower[i]];
        }
        int[] upper = this.getExcludedUpper();
        for (int i = 0; i < upper.length; ++i) {
            double bound = this.getUpperBound(upper[i]);
            if (bound == PrimitiveMath.ZERO) continue;
            retVal += bound * this.myTableau[this.m][upper[i]];
        }
        return retVal;
    }

    @Override
    double getCost(int j) {
        return this.myTableau[this.m][j];
    }

    @Override
    double getInfeasibility(int i) {
        int ii = this.included[i];
        double xi = this.myTableau[i][this.n];
        double lb = this.getLowerBound(ii);
        double ub = this.getUpperBound(ii);
        if (xi < lb) {
            return xi - lb;
        }
        if (xi > ub) {
            return xi - ub;
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    double getReducedCost(int je) {
        return this.myTableau[this.m][this.excluded[je]];
    }

    @Override
    double getTableauElement(SimplexSolver.ExitInfo exit, int je) {
        return this.myTableau[exit.index][this.excluded[je]];
    }

    @Override
    double getTableauElement(int i, SimplexSolver.EnterInfo enter) {
        return this.myTableau[i][enter.column()];
    }

    @Override
    double getTableauRHS(int i) {
        return this.myTableau[i][this.n];
    }

    @Override
    Primitive1D objective() {
        if (this.myObjective == null) {
            this.myObjective = this.newObjective();
        }
        return this.myObjective;
    }

    @Override
    void resetBasis(int[] newBasis) {
        super.resetBasis(newBasis);
        for (int i = 0; i < newBasis.length; ++i) {
            this.pivot(i, newBasis[i]);
        }
    }

    @Override
    void restoreObjective() {
        this.myTableau[this.m] = this.myCopiedObjectiveRow;
        this.myCopiedObjectiveRow = null;
    }

    void set(int row, int col, double value) {
        this.myTableau[row][col] = value;
    }

    @Override
    Collection<Equation> generateCutCandidates(boolean[] integer, NumberContext accuracy, double fractionality) {
        int nbConstraints = this.countConstraints();
        int nbProblemVariables = this.meta.countModelVariables();
        Primitive1D constraintsRHS = this.constraintsRHS();
        ArrayList<Equation> retVal = new ArrayList<Equation>();
        for (int i = 0; i < nbConstraints; ++i) {
            Equation maybe;
            int variableIndex = this.getBasisColumnIndex(i);
            double rhs = constraintsRHS.doubleValue(i);
            if (variableIndex < 0 || variableIndex >= nbProblemVariables || !integer[variableIndex] || accuracy.isInteger(rhs) || (maybe = TableauCutGenerator.doGomoryMixedInteger(this.sliceBodyRow(i), variableIndex, rhs, integer, fractionality)) == null) continue;
            retVal.add(maybe);
        }
        return retVal;
    }

    int getBasisColumnIndex(int basisRowIndex) {
        return this.included[basisRowIndex];
    }

    Primitive1D sliceBodyRow(final int row) {
        return new Primitive1D(){

            @Override
            public double doubleValue(int index) {
                return TableauStore.this.doubleValue(row, index);
            }

            @Override
            public void set(int index, double value) {
                TableauStore.this.set(row, index, value);
            }

            @Override
            public int size() {
                return TableauStore.this.countVariables();
            }
        };
    }
}

