/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.scalar.SelfDeclaringScalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Transformation2D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public final class Quaternion
implements SelfDeclaringScalar<Quaternion>,
Access2D<Double>,
Transformation2D<Double>,
Access2D.Collectable<Double, Mutate2D> {
    public static final Scalar.Factory<Quaternion> FACTORY = new Scalar.Factory<Quaternion>(){

        @Override
        public Quaternion cast(Comparable<?> number) {
            return Quaternion.valueOf(number);
        }

        @Override
        public Quaternion cast(double value) {
            return Quaternion.valueOf(value);
        }

        public Quaternion convert(Comparable<?> number) {
            return Quaternion.valueOf(number);
        }

        public Quaternion convert(double value) {
            return Quaternion.valueOf(value);
        }

        public Quaternion one() {
            return ONE;
        }

        public Quaternion zero() {
            return ZERO;
        }
    };
    public static final Quaternion I = new Quaternion(PrimitiveMath.ONE, PrimitiveMath.ZERO, PrimitiveMath.ZERO);
    public static final Quaternion IJK = new Quaternion(PrimitiveMath.ONE, PrimitiveMath.ONE, PrimitiveMath.ONE).versor();
    public static final Quaternion INFINITY = Quaternion.makePolar(Double.POSITIVE_INFINITY, IJK.vector().toRawCopy1D(), PrimitiveMath.ZERO);
    public static final Quaternion J = new Quaternion(PrimitiveMath.ZERO, PrimitiveMath.ONE, PrimitiveMath.ZERO);
    public static final Quaternion K = new Quaternion(PrimitiveMath.ZERO, PrimitiveMath.ZERO, PrimitiveMath.ONE);
    public static final Quaternion NaN = new Quaternion(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    public static final Quaternion NEG = new Quaternion(PrimitiveMath.NEG);
    public static final Quaternion ONE = new Quaternion(PrimitiveMath.ONE);
    public static final Quaternion TWO = new Quaternion(PrimitiveMath.TWO);
    public static final Quaternion ZERO = new Quaternion();
    private static final double ARGUMENT_TOLERANCE = PrimitiveMath.PI * PrimitiveScalar.CONTEXT.epsilon();
    public final double i;
    public final double j;
    public final double k;
    private final boolean myPureForSure;
    private final boolean myRealForSure;
    private final double myScalar;

    public static boolean isAbsolute(Quaternion value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(Quaternion value) {
        return Double.isInfinite(value.doubleValue()) || Double.isInfinite(value.i) || Double.isInfinite(value.j) || Double.isInfinite(value.k) || Double.isInfinite(value.norm());
    }

    public static boolean isNaN(Quaternion value) {
        return Double.isNaN(value.doubleValue()) || Double.isNaN(value.i) || Double.isNaN(value.j) || Double.isNaN(value.k);
    }

    public static boolean isReal(Quaternion value) {
        return value.isReal();
    }

    public static boolean isSmall(double comparedTo, Quaternion value) {
        return value.isSmall(comparedTo);
    }

    public static Quaternion makePolar(double norm, double[] unit, double angle) {
        double tmpSin;
        double tmpCos;
        double tmpAngle = angle % PrimitiveMath.TWO_PI;
        if (tmpAngle < PrimitiveMath.ZERO) {
            tmpAngle += PrimitiveMath.TWO_PI;
        }
        if (tmpAngle <= ARGUMENT_TOLERANCE) {
            return new Quaternion(norm);
        }
        if (PrimitiveMath.ABS.invoke(tmpAngle - PrimitiveMath.PI) <= ARGUMENT_TOLERANCE) {
            return new Quaternion(-norm);
        }
        double tmpScalar = PrimitiveMath.ZERO;
        if (norm != PrimitiveMath.ZERO && (tmpCos = PrimitiveMath.COS.invoke(tmpAngle)) != PrimitiveMath.ZERO) {
            tmpScalar = norm * tmpCos;
        }
        double tmpI = PrimitiveMath.ZERO;
        double tmpJ = PrimitiveMath.ZERO;
        double tmpK = PrimitiveMath.ZERO;
        if (norm != PrimitiveMath.ZERO && (tmpSin = PrimitiveMath.SIN.invoke(tmpAngle)) != PrimitiveMath.ZERO) {
            tmpI = unit[0] * norm * tmpSin;
            tmpJ = unit[1] * norm * tmpSin;
            tmpK = unit[2] * norm * tmpSin;
        }
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public static Quaternion makeRotation(RotationAxis axis, double angle) {
        double tmpScalar = PrimitiveMath.COS.invoke(angle);
        double tmpI = PrimitiveMath.ZERO;
        double tmpJ = PrimitiveMath.ZERO;
        double tmpK = PrimitiveMath.ZERO;
        switch (axis) {
            case X: {
                tmpI = PrimitiveMath.SIN.invoke(angle);
                break;
            }
            case Y: {
                tmpJ = PrimitiveMath.SIN.invoke(angle);
                break;
            }
            case Z: {
                tmpK = PrimitiveMath.SIN.invoke(angle);
                break;
            }
            default: {
                throw new ProgrammingError("How could this happen?");
            }
        }
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public static Quaternion of(double i, double j, double k) {
        return new Quaternion(0.0, i, j, k);
    }

    public static Quaternion of(double scalar, double i, double j, double k) {
        return new Quaternion(scalar, i, j, k);
    }

    public static Quaternion valueOf(Comparable<?> number) {
        if (number == null) {
            return ZERO;
        }
        if (number instanceof Quaternion) {
            return (Quaternion)number;
        }
        if (number instanceof ComplexNumber) {
            ComplexNumber tmpComplex = (ComplexNumber)number;
            return new Quaternion(tmpComplex.doubleValue(), tmpComplex.i, PrimitiveMath.ZERO, PrimitiveMath.ZERO);
        }
        return new Quaternion(NumberDefinition.doubleValue(number));
    }

    public static Quaternion valueOf(double value) {
        return new Quaternion(value);
    }

    public Quaternion() {
        this.myScalar = PrimitiveMath.ZERO;
        this.myRealForSure = true;
        this.myPureForSure = true;
        this.i = PrimitiveMath.ZERO;
        this.j = PrimitiveMath.ZERO;
        this.k = PrimitiveMath.ZERO;
    }

    private Quaternion(double scalar, double[] vector) {
        this.myScalar = scalar;
        this.myRealForSure = false;
        this.myPureForSure = false;
        this.i = vector[0];
        this.j = vector[1];
        this.k = vector[2];
    }

    private Quaternion(double[] vector) {
        this.myScalar = PrimitiveMath.ZERO;
        this.myRealForSure = false;
        this.myPureForSure = true;
        this.i = vector[0];
        this.j = vector[1];
        this.k = vector[2];
    }

    Quaternion(double scalar) {
        this.myScalar = scalar;
        this.myRealForSure = true;
        this.myPureForSure = false;
        this.i = PrimitiveMath.ZERO;
        this.j = PrimitiveMath.ZERO;
        this.k = PrimitiveMath.ZERO;
    }

    Quaternion(double i, double j, double k) {
        this.myScalar = PrimitiveMath.ZERO;
        this.myRealForSure = false;
        this.myPureForSure = true;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    Quaternion(double scalar, double i, double j, double k) {
        this.myScalar = scalar;
        this.myRealForSure = false;
        this.myPureForSure = false;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    @Override
    public Quaternion add(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar + arg);
        }
        return new Quaternion(this.myScalar + arg, this.i, this.j, this.k);
    }

    @Override
    public Quaternion add(Quaternion arg) {
        if (this.isReal()) {
            return arg.add(this.myScalar);
        }
        double tmpScalar = this.myScalar + arg.scalar();
        double tmpI = this.i + arg.i;
        double tmpJ = this.j + arg.j;
        double tmpK = this.k + arg.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public double angle() {
        return PrimitiveMath.ACOS.invoke(this.myScalar / this.norm());
    }

    @Override
    public int compareTo(Quaternion other) {
        int retVal = Double.compare(this.myScalar, other.doubleValue());
        if (retVal != 0) {
            return retVal;
        }
        retVal = Double.compare(this.i, other.i);
        if (retVal != 0) {
            return retVal;
        }
        retVal = Double.compare(this.j, other.j);
        if (retVal != 0) {
            return retVal;
        }
        return Double.compare(this.k, other.k);
    }

    @Override
    public Quaternion conjugate() {
        double tmpScalar = this.myScalar;
        double tmpI = -this.i;
        double tmpJ = -this.j;
        double tmpK = -this.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public long count() {
        return 16L;
    }

    @Override
    public long countColumns() {
        return 4L;
    }

    @Override
    public long countRows() {
        return 4L;
    }

    @Override
    public Quaternion divide(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar / arg);
        }
        if (this.isPure()) {
            double tmpI = this.i / arg;
            double tmpJ = this.j / arg;
            double tmpK = this.k / arg;
            return new Quaternion(tmpI, tmpJ, tmpK);
        }
        double tmpScalar = this.myScalar / arg;
        double tmpI = this.i / arg;
        double tmpJ = this.j / arg;
        double tmpK = this.k / arg;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public Quaternion divide(Quaternion arg) {
        Quaternion tmpReciprocal = arg.invert();
        return this.multiply(tmpReciprocal);
    }

    @Override
    public double doubleValue() {
        return this.myScalar;
    }

    @Override
    public double doubleValue(long index) {
        switch ((int)index) {
            case 0: {
                return this.myScalar;
            }
            case 1: {
                return this.i;
            }
            case 2: {
                return this.j;
            }
            case 3: {
                return this.k;
            }
            case 4: {
                return -this.i;
            }
            case 5: {
                return this.myScalar;
            }
            case 6: {
                return this.k;
            }
            case 7: {
                return -this.j;
            }
            case 8: {
                return -this.j;
            }
            case 9: {
                return -this.k;
            }
            case 10: {
                return this.myScalar;
            }
            case 11: {
                return this.i;
            }
            case 12: {
                return -this.k;
            }
            case 13: {
                return this.j;
            }
            case 14: {
                return -this.i;
            }
            case 15: {
                return this.myScalar;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row == col) {
            return this.myScalar;
        }
        return this.doubleValue(row + col * 4L);
    }

    @Override
    public Quaternion enforce(NumberContext context) {
        double tmpScalar = context.enforce(this.myScalar);
        double tmpI = context.enforce(this.i);
        double tmpJ = context.enforce(this.j);
        double tmpK = context.enforce(this.k);
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Quaternion)) {
            return false;
        }
        Quaternion other = (Quaternion)obj;
        return Double.doubleToLongBits(this.myScalar) == Double.doubleToLongBits(other.myScalar) && Double.doubleToLongBits(this.i) == Double.doubleToLongBits(other.i) && Double.doubleToLongBits(this.j) == Double.doubleToLongBits(other.j) && Double.doubleToLongBits(this.k) == Double.doubleToLongBits(other.k);
    }

    @Override
    public float floatValue() {
        return (float)this.myScalar;
    }

    @Override
    public Quaternion get() {
        return this;
    }

    @Override
    public Double get(long index) {
        return this.doubleValue(index);
    }

    @Override
    public Double get(long row, long col) {
        return this.doubleValue(row, col);
    }

    public double getDeterminant() {
        double tmpSumOfSquares = this.calculateSumOfSquaresAll();
        return tmpSumOfSquares * tmpSumOfSquares;
    }

    public Quaternion getPureVersor() {
        double tmpLength = this.getVectorLength();
        if (tmpLength > 0.0) {
            return new Quaternion(this.i / tmpLength, this.j / tmpLength, this.k / tmpLength);
        }
        return IJK;
    }

    public double getVectorLength() {
        return PrimitiveMath.SQRT.invoke(this.calculateSumOfSquaresVector());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.i);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.j);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.k);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.myScalar);
        return 31 * result + (int)(temp ^ temp >>> 32);
    }

    @Override
    public int intValue() {
        return (int)this.myScalar;
    }

    @Override
    public Quaternion invert() {
        Quaternion tmpConjugate = this.conjugate();
        double tmpSumOfSquares = this.calculateSumOfSquaresAll();
        return tmpConjugate.divide(tmpSumOfSquares);
    }

    @Override
    public boolean isAbsolute() {
        if (this.myRealForSure) {
            return this.myScalar >= PrimitiveMath.ZERO;
        }
        return !PrimitiveScalar.CONTEXT.isDifferent(this.myScalar, this.norm());
    }

    public boolean isPure() {
        return this.myPureForSure || PrimitiveScalar.CONTEXT.isSmall(this.norm(), this.myScalar);
    }

    public boolean isReal() {
        NumberContext cntxt = PrimitiveScalar.CONTEXT;
        return this.myRealForSure || cntxt.isSmall(this.myScalar, this.i) && cntxt.isSmall(this.myScalar, this.j) && cntxt.isSmall(this.myScalar, this.k);
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return PrimitiveScalar.CONTEXT.isSmall(comparedTo, this.norm());
    }

    @Override
    public long longValue() {
        return (long)this.myScalar;
    }

    @Override
    public Quaternion multiply(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar * arg);
        }
        if (this.isPure()) {
            double tmpI = this.i * arg;
            double tmpJ = this.j * arg;
            double tmpK = this.k * arg;
            return new Quaternion(tmpI, tmpJ, tmpK);
        }
        double tmpScalar = this.myScalar * arg;
        double tmpI = this.i * arg;
        double tmpJ = this.j * arg;
        double tmpK = this.k * arg;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public Quaternion multiply(Quaternion arg) {
        if (this.isReal()) {
            return arg.multiply(this.myScalar);
        }
        double tmpScalar = this.myScalar * arg.scalar() - this.i * arg.i - this.j * arg.j - this.k * arg.k;
        double tmpI = this.myScalar * arg.i + this.i * arg.scalar() + this.j * arg.k - this.k * arg.j;
        double tmpJ = this.myScalar * arg.j - this.i * arg.k + this.j * arg.scalar() + this.k * arg.i;
        double tmpK = this.myScalar * arg.k + this.i * arg.j - this.j * arg.i + this.k * arg.scalar();
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public Quaternion negate() {
        double tmpScalar = -this.myScalar;
        double tmpI = -this.i;
        double tmpJ = -this.j;
        double tmpK = -this.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public double norm() {
        return PrimitiveMath.SQRT.invoke(this.calculateSumOfSquaresAll());
    }

    @Override
    public Quaternion power(int power) {
        Quaternion retVal = ONE;
        for (int p = 0; p < power; ++p) {
            retVal = retVal.multiply(this);
        }
        return retVal;
    }

    public double scalar() {
        return this.myScalar;
    }

    @Override
    public Quaternion signum() {
        return this.versor();
    }

    @Override
    public Quaternion subtract(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar - arg);
        }
        return new Quaternion(this.myScalar - arg, this.i, this.j, this.k);
    }

    @Override
    public Quaternion subtract(Quaternion arg) {
        double tmpScalar = this.myScalar - arg.scalar();
        double tmpI = this.i - arg.i;
        double tmpJ = this.j - arg.j;
        double tmpK = this.k - arg.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public void supplyTo(Mutate2D receiver) {
        receiver.set(0L, this.myScalar);
        receiver.set(1L, this.i);
        receiver.set(2L, this.j);
        receiver.set(3L, this.k);
        receiver.set(4L, -this.i);
        receiver.set(5L, this.myScalar);
        receiver.set(6L, this.k);
        receiver.set(7L, -this.j);
        receiver.set(8L, -this.j);
        receiver.set(9L, -this.k);
        receiver.set(10L, this.myScalar);
        receiver.set(11L, this.i);
        receiver.set(12L, -this.k);
        receiver.set(13L, this.j);
        receiver.set(14L, -this.i);
        receiver.set(15L, this.myScalar);
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.myScalar, PrimitiveScalar.CONTEXT.getMathContext());
    }

    public MatrixStore<ComplexNumber> toComplexMatrix() {
        GenericStore retVal = (GenericStore)GenericStore.C128.make(2L, 2L);
        retVal.set(0L, ComplexNumber.of(this.myScalar, this.i));
        retVal.set(1L, ComplexNumber.of(-this.j, this.k));
        retVal.set(2L, ComplexNumber.of(this.j, this.k));
        retVal.set(3L, ComplexNumber.of(this.myScalar, -this.i));
        return retVal;
    }

    public MatrixStore<Double> toMultiplicationMatrix() {
        Primitive64Store retVal = (Primitive64Store)Primitive64Store.FACTORY.make(this);
        this.supplyTo(retVal);
        return retVal;
    }

    public MatrixStore<Double> toMultiplicationVector() {
        Primitive64Store retVal = (Primitive64Store)Primitive64Store.FACTORY.make(4L, 1L);
        retVal.set(0L, this.myScalar);
        retVal.set(1L, this.i);
        retVal.set(2L, this.j);
        retVal.set(3L, this.k);
        return retVal;
    }

    public MatrixStore<Double> toRotationMatrix() {
        Primitive64Store retVal = (Primitive64Store)Primitive64Store.FACTORY.make(3L, 3L);
        double s = this.myScalar;
        double ss = s * s;
        double ii = this.i * this.i;
        double jj = this.j * this.j;
        double kk = this.k * this.k;
        double invs = 1.0 / (ii + jj + kk + ss);
        double r00 = (ii + ss - (jj + kk)) * invs;
        double r11 = (jj + ss - (ii + kk)) * invs;
        double r22 = (kk + ss - (ii + jj)) * invs;
        double tmp1 = this.i * this.j;
        double tmp2 = this.k * s;
        double r10 = 2.0 * (tmp1 + tmp2) * invs;
        double r01 = 2.0 * (tmp1 - tmp2) * invs;
        tmp1 = this.i * this.k;
        tmp2 = this.j * s;
        double r20 = 2.0 * (tmp1 - tmp2) * invs;
        double r02 = 2.0 * (tmp1 + tmp2) * invs;
        tmp1 = this.j * this.k;
        tmp2 = this.i * s;
        double r21 = 2.0 * (tmp1 + tmp2) * invs;
        double r12 = 2.0 * (tmp1 - tmp2) * invs;
        retVal.set(0L, r00);
        retVal.set(1L, r10);
        retVal.set(2L, r20);
        retVal.set(3L, r01);
        retVal.set(4L, r11);
        retVal.set(5L, r21);
        retVal.set(6L, r02);
        retVal.set(7L, r12);
        retVal.set(8L, r22);
        return retVal;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder("(");
        retVal.append(Double.toString(this.myScalar));
        if (this.i < PrimitiveMath.ZERO) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(Double.toString(PrimitiveMath.ABS.invoke(this.i)));
        retVal.append("i");
        if (this.j < PrimitiveMath.ZERO) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(Double.toString(PrimitiveMath.ABS.invoke(this.j)));
        retVal.append("j");
        if (this.k < PrimitiveMath.ZERO) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(Double.toString(PrimitiveMath.ABS.invoke(this.k)));
        retVal.append("k)");
        return retVal.toString();
    }

    @Override
    public String toString(NumberContext context) {
        StringBuilder retVal = new StringBuilder("(");
        BigDecimal tmpScalar = context.enforce(new BigDecimal(this.myScalar, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpI = context.enforce(new BigDecimal(this.i, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpJ = context.enforce(new BigDecimal(this.j, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpK = context.enforce(new BigDecimal(this.k, PrimitiveScalar.CONTEXT.getMathContext()));
        retVal.append(tmpScalar.toString());
        if (tmpI.signum() < 0) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(tmpI.abs().toString());
        retVal.append("i");
        if (tmpJ.signum() < 0) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(tmpJ.abs().toString());
        retVal.append("j");
        if (tmpK.signum() < 0) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(tmpK.abs().toString());
        retVal.append("k)");
        return retVal.toString();
    }

    @Override
    public <T extends Mutate2D.ModifiableReceiver<Double>> void transform(T transformable) {
        double s = this.myScalar;
        double ss = s * s;
        double ii = this.i * this.i;
        double jj = this.j * this.j;
        double kk = this.k * this.k;
        double invs = 1.0 / (ii + jj + kk + ss);
        double r00 = (ii + ss - (jj + kk)) * invs;
        double r11 = (jj + ss - (ii + kk)) * invs;
        double r22 = (kk + ss - (ii + jj)) * invs;
        double tmp1 = this.i * this.j;
        double tmp2 = this.k * s;
        double r10 = 2.0 * (tmp1 + tmp2) * invs;
        double r01 = 2.0 * (tmp1 - tmp2) * invs;
        tmp1 = this.i * this.k;
        tmp2 = this.j * s;
        double r20 = 2.0 * (tmp1 - tmp2) * invs;
        double r02 = 2.0 * (tmp1 + tmp2) * invs;
        tmp1 = this.j * this.k;
        tmp2 = this.i * s;
        double r21 = 2.0 * (tmp1 + tmp2) * invs;
        double r12 = 2.0 * (tmp1 - tmp2) * invs;
        if (transformable.count() == 3L) {
            double x = transformable.doubleValue(0L);
            double y = transformable.doubleValue(1L);
            double z = transformable.doubleValue(2L);
            transformable.set(0L, r00 * x + r01 * y + r02 * z);
            transformable.set(1L, r10 * x + r11 * y + r12 * z);
            transformable.set(2L, r20 * x + r21 * y + r22 * z);
        } else if (transformable.countRows() == 3L) {
            long limit = transformable.countColumns();
            for (long c = 0L; c < limit; ++c) {
                double x = transformable.doubleValue(0L, c);
                double y = transformable.doubleValue(1L, c);
                double z = transformable.doubleValue(2L, c);
                transformable.set(0L, c, r00 * x + r01 * y + r02 * z);
                transformable.set(1L, c, r10 * x + r11 * y + r12 * z);
                transformable.set(2L, c, r20 * x + r21 * y + r22 * z);
            }
        } else if (transformable.countColumns() == 3L) {
            long limit = transformable.countRows();
            for (long r = 0L; r < limit; ++r) {
                double x = transformable.doubleValue(r, 0L);
                double y = transformable.doubleValue(r, 1L);
                double z = transformable.doubleValue(r, 2L);
                transformable.set(r, 0L, r00 * x + r01 * y + r02 * z);
                transformable.set(r, 1L, r10 * x + r11 * y + r12 * z);
                transformable.set(r, 2L, r20 * x + r21 * y + r22 * z);
            }
        } else {
            throw new ProgrammingError("Only works for 3D stuff!");
        }
    }

    public double[] unit() {
        double tmpLength = this.getVectorLength();
        if (tmpLength > 0.0) {
            return new double[]{this.i / tmpLength, this.j / tmpLength, this.k / tmpLength};
        }
        return new double[]{Quaternion.IJK.i, Quaternion.IJK.j, Quaternion.IJK.k};
    }

    public PhysicalStore<Double> vector() {
        Primitive64Store retVal = (Primitive64Store)Primitive64Store.FACTORY.make(3L, 1L);
        retVal.set(0L, this.i);
        retVal.set(1L, this.j);
        retVal.set(2L, this.k);
        return retVal;
    }

    public Quaternion versor() {
        double norm = this.norm();
        if (this.isReal()) {
            return new Quaternion(this.myScalar / norm);
        }
        if (this.isPure()) {
            return new Quaternion(this.i / norm, this.j / norm, this.k / norm);
        }
        return new Quaternion(this.myScalar / norm, this.i / norm, this.j / norm, this.k / norm);
    }

    private double calculateSumOfSquaresAll() {
        return this.myScalar * this.myScalar + this.calculateSumOfSquaresVector();
    }

    private double calculateSumOfSquaresVector() {
        return this.i * this.i + this.j * this.j + this.k * this.k;
    }

    MatrixStore<Double> toRotationMatrixVersor() {
        Primitive64Store retVal = (Primitive64Store)Primitive64Store.FACTORY.make(3L, 3L);
        double s = this.doubleValue();
        double ss = s * s;
        double ii = this.i * this.i;
        double jj = this.j * this.j;
        double kk = this.k * this.k;
        double r00 = ii + ss - (jj + kk);
        double r11 = jj + ss - (ii + kk);
        double r22 = kk + ss - (ii + jj);
        double tmp1 = this.i * this.j;
        double tmp2 = this.k * s;
        double r10 = 2.0 * (tmp1 + tmp2);
        double r01 = 2.0 * (tmp1 - tmp2);
        tmp1 = this.i * this.k;
        tmp2 = this.j * s;
        double r20 = 2.0 * (tmp1 - tmp2);
        double r02 = 2.0 * (tmp1 + tmp2);
        tmp1 = this.j * this.k;
        tmp2 = this.i * s;
        double r21 = 2.0 * (tmp1 + tmp2);
        double r12 = 2.0 * (tmp1 - tmp2);
        retVal.set(0L, r00);
        retVal.set(1L, r10);
        retVal.set(2L, r20);
        retVal.set(3L, r01);
        retVal.set(4L, r11);
        retVal.set(5L, r21);
        retVal.set(6L, r02);
        retVal.set(7L, r12);
        retVal.set(8L, r22);
        return retVal;
    }

    <T extends Mutate2D.ModifiableReceiver<Double>> void transformVersor(T transformable) {
        double s = this.doubleValue();
        double ss = s * s;
        double ii = this.i * this.i;
        double jj = this.j * this.j;
        double kk = this.k * this.k;
        double r00 = ii + ss - (jj + kk);
        double r11 = jj + ss - (ii + kk);
        double r22 = kk + ss - (ii + jj);
        double tmp1 = this.i * this.j;
        double tmp2 = this.k * s;
        double r10 = 2.0 * (tmp1 + tmp2);
        double r01 = 2.0 * (tmp1 - tmp2);
        tmp1 = this.i * this.k;
        tmp2 = this.j * s;
        double r20 = 2.0 * (tmp1 - tmp2);
        double r02 = 2.0 * (tmp1 + tmp2);
        tmp1 = this.j * this.k;
        tmp2 = this.i * s;
        double r21 = 2.0 * (tmp1 + tmp2);
        double r12 = 2.0 * (tmp1 - tmp2);
        if (transformable.count() == 3L) {
            double x = transformable.doubleValue(0L);
            double y = transformable.doubleValue(1L);
            double z = transformable.doubleValue(2L);
            transformable.set(0L, r00 * x + r01 * y + r02 * z);
            transformable.set(1L, r10 * x + r11 * y + r12 * z);
            transformable.set(2L, r20 * x + r21 * y + r22 * z);
        } else if (transformable.countRows() == 3L) {
            long limit = transformable.countColumns();
            for (long c = 0L; c < limit; ++c) {
                double x = transformable.doubleValue(0L, c);
                double y = transformable.doubleValue(1L, c);
                double z = transformable.doubleValue(2L, c);
                transformable.set(0L, c, r00 * x + r01 * y + r02 * z);
                transformable.set(1L, c, r10 * x + r11 * y + r12 * z);
                transformable.set(2L, c, r20 * x + r21 * y + r22 * z);
            }
        } else if (transformable.countColumns() == 3L) {
            long limit = transformable.countRows();
            for (long r = 0L; r < limit; ++r) {
                double x = transformable.doubleValue(r, 0L);
                double y = transformable.doubleValue(r, 1L);
                double z = transformable.doubleValue(r, 2L);
                transformable.set(r, 0L, r00 * x + r01 * y + r02 * z);
                transformable.set(r, 1L, r10 * x + r11 * y + r12 * z);
                transformable.set(r, 2L, r20 * x + r21 * y + r22 * z);
            }
        } else {
            throw new ProgrammingError("Only works for 3D stuff!");
        }
    }

    public static enum RotationAxis {
        X(0, new double[]{1.0, 0.0, 0.0}),
        Y(1, new double[]{0.0, 1.0, 0.0}),
        Z(2, new double[]{0.0, 0.0, 1.0});

        private final int myIndex;
        private final double[] myVector;

        private RotationAxis(int index, double[] axis) {
            this.myIndex = index;
            this.myVector = axis;
        }

        int index() {
            return this.myIndex;
        }

        double[] vector() {
            return this.myVector;
        }
    }
}

