/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.ElementViewAnyD;
import org.ojalgo.structure.FactoryAnyD;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.MutateAnyD;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.structure.StructureAnyD;
import org.ojalgo.type.context.NumberContext;

public interface AccessAnyD<N extends Comparable<N>>
extends StructureAnyD,
Access1D<N> {
    public static AccessAnyD<Double> asPrimitiveAnyD(final AccessAnyD<?> access) {
        return new AccessAnyD<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long count(int dimension) {
                return access.count(dimension);
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long ... ref) {
                return access.doubleValue(ref);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long ... ref) {
                return access.doubleValue(ref);
            }

            @Override
            public long[] shape() {
                return access.shape();
            }
        };
    }

    public static boolean equals(AccessAnyD<?> accessA, AccessAnyD<?> accessB, NumberContext accuracy) {
        long tmpCount;
        boolean retVal = true;
        int d = 0;
        while ((retVal &= (tmpCount = accessA.count(d)) == accessB.count(d)) && (++d <= 3 || tmpCount > 1L)) {
        }
        return retVal && Access1D.equals(accessA, accessB, accuracy);
    }

    public static String toString(AccessAnyD<?> array) {
        return Arrays.toString(array.shape()) + " " + Access1D.toString(array);
    }

    default public <NN extends Comparable<NN>, R extends MutateAnyD.Receiver<NN>> Collectable<NN, R> asCollectableAnyD() {
        return new Collectable<NN, R>(){

            @Override
            public long count(int dimension) {
                return AccessAnyD.this.count(dimension);
            }

            @Override
            public long[] shape() {
                return AccessAnyD.this.shape();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.accept(AccessAnyD.this);
            }
        };
    }

    @Override
    default public byte byteValue(long index) {
        return this.byteValue(StructureAnyD.reference(index, this.shape()));
    }

    default public byte byteValue(long ... ref) {
        return (byte)this.shortValue(ref);
    }

    @Override
    default public double doubleValue(long index) {
        return this.doubleValue(StructureAnyD.reference(index, this.shape()));
    }

    public double doubleValue(long ... var1);

    @Override
    default public ElementViewAnyD<N, ?> elements() {
        return new ElementView(Access1D.super.elements(), this.shape());
    }

    @Override
    default public float floatValue(long index) {
        return this.floatValue(StructureAnyD.reference(index, this.shape()));
    }

    default public float floatValue(long ... ref) {
        return (float)this.doubleValue(ref);
    }

    @Override
    default public N get(long index) {
        return this.get(StructureAnyD.reference(index, this.shape()));
    }

    public N get(long ... var1);

    @Override
    default public int intValue(long index) {
        return this.intValue(StructureAnyD.reference(index, this.shape()));
    }

    default public int intValue(long ... ref) {
        return (int)this.longValue(ref);
    }

    @Override
    default public long longValue(long index) {
        return this.longValue(StructureAnyD.reference(index, this.shape()));
    }

    default public long longValue(long ... ref) {
        return Math.round(this.doubleValue(ref));
    }

    default public MatrixView<N> matrices() {
        return new MatrixView(this);
    }

    default public AccessAnyD<N> select(long[] ... selections) {
        return new SelectionView(this, selections);
    }

    @Override
    default public short shortValue(long index) {
        return this.shortValue(StructureAnyD.reference(index, this.shape()));
    }

    default public short shortValue(long ... ref) {
        return (short)this.intValue(ref);
    }

    default public VectorView<N> vectors() {
        return new VectorView(this);
    }

    public static interface Visitable<N extends Comparable<N>>
    extends StructureAnyD,
    Access1D.Visitable<N> {
        public void visitOne(long[] var1, VoidFunction<N> var2);

        public void visitSet(int var1, long var2, VoidFunction<N> var4);

        public void visitSet(long[] var1, int var2, VoidFunction<N> var3);
    }

    public static final class VectorView<N extends Comparable<N>>
    implements Access1D<N>,
    Iterable<VectorView<N>>,
    Iterator<VectorView<N>>,
    Comparable<VectorView<N>>,
    Access1D.Collectable<N, Mutate1D> {
        private final long myCount;
        private final AccessAnyD<N> myDelegateAnyD;
        private final long myLastOffset;
        private long myOffset;

        protected VectorView(AccessAnyD<N> access) {
            this(access, -1L);
        }

        VectorView(AccessAnyD<N> access, long index) {
            this.myDelegateAnyD = access;
            this.myCount = access.count(0);
            this.myOffset = index * this.myCount;
            this.myLastOffset = this.myDelegateAnyD.count() - this.myCount;
        }

        @Override
        public int compareTo(VectorView<N> other) {
            return Long.compare(this.myOffset, other.getOffset());
        }

        @Override
        public long count() {
            return this.myCount;
        }

        @Override
        public double doubleValue(long index) {
            return this.myDelegateAnyD.doubleValue(this.myOffset + Structure2D.index(this.myCount, index, 0L));
        }

        public long estimateSize() {
            return (this.myLastOffset - this.myOffset) / this.myCount;
        }

        @Override
        public N get(long index) {
            return this.myDelegateAnyD.get(this.myOffset + Structure2D.index(this.myCount, index, 0L));
        }

        public void goToVector(long index) {
            this.myOffset = index * this.myCount;
        }

        @Override
        public boolean hasNext() {
            return this.myOffset < this.myLastOffset;
        }

        public boolean hasPrevious() {
            return this.myOffset > 0L;
        }

        public long index() {
            return this.myOffset / this.myCount;
        }

        @Override
        public VectorView<N> iterator() {
            return new VectorView<N>(this.myDelegateAnyD);
        }

        @Override
        public VectorView<N> next() {
            this.myOffset += this.myCount;
            return this;
        }

        public VectorView<N> previous() {
            this.myOffset -= this.myCount;
            return this;
        }

        @Override
        public void remove() {
            ProgrammingError.throwForUnsupportedOptionalOperation();
        }

        @Override
        public void supplyTo(Mutate1D receiver) {
            long limit = Math.min(this.count(), receiver.count());
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, (Comparable<?>)this.get(i));
            }
        }

        public String toString() {
            return this.index() + " = " + Access1D.toString(this);
        }

        long getOffset() {
            return this.myOffset;
        }
    }

    public static interface Sliceable<N extends Comparable<N>>
    extends StructureAnyD,
    Access1D.Sliceable<N> {
        public Access1D<N> sliceSet(long[] var1, int var2);
    }

    public static final class SelectionView<N extends Comparable<N>>
    implements AccessAnyD<N>,
    Collectable<N, MutateAnyD> {
        private final AccessAnyD<N> myFullData;
        private final long[][] mySelections;
        private final long[] myShape;

        SelectionView(AccessAnyD<N> fullData, long[][] selections) {
            int d;
            this.myFullData = fullData;
            this.myShape = new long[fullData.rank()];
            this.mySelections = new long[fullData.rank()][];
            int limit = Math.min(this.mySelections.length, selections.length);
            for (d = 0; d < limit; ++d) {
                this.mySelections[d] = Structure1D.replaceNullOrEmptyWithFull(selections[d], fullData.size(d));
                this.myShape[d] = this.mySelections[d].length;
            }
            limit = this.mySelections.length;
            for (d = selections.length; d < limit; ++d) {
                this.mySelections[d] = Structure1D.replaceNullOrEmptyWithFull(null, fullData.size(d));
                this.myShape[d] = this.mySelections[d].length;
            }
        }

        @Override
        public long count(int dimension) {
            return this.myShape[dimension];
        }

        @Override
        public double doubleValue(long ... ref) {
            return this.myFullData.doubleValue(this.translate(ref));
        }

        @Override
        public N get(long ... ref) {
            return this.myFullData.get(this.translate(ref));
        }

        @Override
        public long[] shape() {
            return this.myShape;
        }

        @Override
        public void supplyTo(MutateAnyD receiver) {
            long[] filteredRef = new long[this.myShape.length];
            long[] fullRef = new long[this.myShape.length];
            long limit = this.count();
            for (long i = 0L; i < limit; ++i) {
                StructureAnyD.reference(i, this.myShape, filteredRef);
                this.translate(filteredRef, fullRef);
                receiver.set(i, (Comparable<?>)this.myFullData.get(fullRef));
            }
        }

        public String toString() {
            return AccessAnyD.toString(this);
        }

        private long[] translate(long[] filteredRef) {
            long[] fullRef = new long[this.myShape.length];
            this.translate(filteredRef, fullRef);
            return fullRef;
        }

        private void translate(long[] filteredRef, long[] fullRef) {
            int limit = Math.min(fullRef.length, filteredRef.length);
            for (int d = 0; d < limit; ++d) {
                fullRef[d] = this.mySelections[d][Math.toIntExact(filteredRef[d])];
            }
        }
    }

    public static final class MatrixView<N extends Comparable<N>>
    implements Access2D<N>,
    Iterable<MatrixView<N>>,
    Iterator<MatrixView<N>>,
    Comparable<MatrixView<N>>,
    Access2D.Collectable<N, Mutate2D> {
        private final long myColumnsCount;
        private final long myCount;
        private final AccessAnyD<N> myDelegateAnyD;
        private final long myLastOffset;
        private long myOffset;
        private final long myRowsCount;

        protected MatrixView(AccessAnyD<N> access) {
            this(access, -1L);
        }

        MatrixView(AccessAnyD<N> access, long index) {
            this.myDelegateAnyD = access;
            this.myRowsCount = access.count(0);
            this.myColumnsCount = access.count(1);
            this.myCount = this.myRowsCount * this.myColumnsCount;
            this.myOffset = index * this.myCount;
            this.myLastOffset = this.myDelegateAnyD.count() - this.myCount;
        }

        @Override
        public int compareTo(MatrixView<N> other) {
            return Long.compare(this.myOffset, other.getOffset());
        }

        @Override
        public long count() {
            return this.myCount;
        }

        @Override
        public long countColumns() {
            return this.myColumnsCount;
        }

        @Override
        public long countRows() {
            return this.myRowsCount;
        }

        @Override
        public double doubleValue(long row, long col) {
            return this.myDelegateAnyD.doubleValue(this.myOffset + Structure2D.index(this.myRowsCount, row, col));
        }

        public long estimateSize() {
            return (this.myLastOffset - this.myOffset) / this.myCount;
        }

        @Override
        public N get(long row, long col) {
            return this.myDelegateAnyD.get(this.myOffset + Structure2D.index(this.myRowsCount, row, col));
        }

        public void goToMatrix(long index) {
            this.myOffset = index * this.myCount;
        }

        @Override
        public boolean hasNext() {
            return this.myOffset < this.myLastOffset;
        }

        public boolean hasPrevious() {
            return this.myOffset > 0L;
        }

        public long index() {
            return this.myOffset / this.myCount;
        }

        @Override
        public MatrixView<N> iterator() {
            return new MatrixView<N>(this.myDelegateAnyD);
        }

        @Override
        public MatrixView<N> next() {
            this.myOffset += this.myCount;
            return this;
        }

        public MatrixView<N> previous() {
            this.myOffset -= this.myCount;
            return this;
        }

        @Override
        public void remove() {
            ProgrammingError.throwForUnsupportedOptionalOperation();
        }

        @Override
        public void supplyTo(Mutate2D receiver) {
            long nbColumns = this.countColumns();
            for (long j = 0L; j < nbColumns; ++j) {
                long nbRows = this.countRows();
                for (long i = 0L; i < nbRows; ++i) {
                    receiver.set(i, j, (Comparable<?>)this.get(i, j));
                }
            }
        }

        public String toString() {
            return Access2D.toString(this);
        }

        long getOffset() {
            return this.myOffset;
        }
    }

    public static final class ElementView<N extends Comparable<N>>
    implements ElementViewAnyD<N, ElementView<N>> {
        private final ElementView1D<N, ?> myDelegate1D;
        private final long[] myStructure;

        public ElementView(ElementView1D<N, ?> delegate, long[] structure) {
            this.myDelegate1D = delegate;
            this.myStructure = structure;
        }

        @Override
        public double doubleValue() {
            return this.myDelegate1D.doubleValue();
        }

        @Override
        public long estimateSize() {
            return this.myDelegate1D.estimateSize();
        }

        @Override
        public N get() {
            return (N)((Comparable)this.myDelegate1D.get());
        }

        @Override
        public boolean hasNext() {
            return this.myDelegate1D.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.myDelegate1D.hasPrevious();
        }

        @Override
        public long index() {
            return this.myDelegate1D.index();
        }

        @Override
        public ElementView<N> iterator() {
            return new ElementView<N>(this.myDelegate1D.iterator(), this.myStructure);
        }

        @Override
        public ElementView<N> next() {
            this.myDelegate1D.next();
            return this;
        }

        @Override
        public long nextIndex() {
            return this.myDelegate1D.nextIndex();
        }

        @Override
        public ElementView<N> previous() {
            this.myDelegate1D.previous();
            return this;
        }

        @Override
        public long previousIndex() {
            return this.myDelegate1D.previousIndex();
        }

        @Override
        public long[] reference() {
            return StructureAnyD.reference(this.myDelegate1D.index(), this.myStructure);
        }

        public String toString() {
            return this.myDelegate1D.toString();
        }

        @Override
        public ElementView<N> trySplit() {
            Spliterator delegateSpliterator = this.myDelegate1D.trySplit();
            if (delegateSpliterator != null) {
                return new ElementView<N>(delegateSpliterator, this.myStructure);
            }
            return null;
        }
    }

    public static interface Collectable<N extends Comparable<N>, R extends MutateAnyD>
    extends StructureAnyD {
        default public <I extends R> I collect(FactoryAnyD<I> factory) {
            MutateAnyD retVal = (MutateAnyD)factory.make(this.shape());
            this.supplyTo(retVal);
            return (I)retVal;
        }

        public void supplyTo(R var1);
    }

    public static interface Aggregatable<N extends Comparable<N>>
    extends StructureAnyD,
    Access1D.Aggregatable<N> {
        public N aggregateSet(int var1, long var2, Aggregator var4);

        public N aggregateSet(long[] var1, int var2, Aggregator var3);

        default public void reduce(int dimension, Aggregator aggregator, Mutate1D receiver) {
            long count1 = this.count(dimension);
            long count2 = receiver.count();
            long limit = Math.min(count1, count2);
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, (Comparable<?>)this.aggregateSet(dimension, i, aggregator));
            }
        }
    }
}

