/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateDuration;

public enum CalendarDateUnit implements TemporalUnit,
CalendarDate.Resolution
{
    NANOS(ChronoUnit.NANOS, TimeUnit.NANOSECONDS, "ns"),
    MICROS(ChronoUnit.MICROS, TimeUnit.MICROSECONDS, "\u00b5s"),
    MILLIS(ChronoUnit.MILLIS, TimeUnit.MILLISECONDS, "ms"),
    SECOND(ChronoUnit.SECONDS, TimeUnit.SECONDS, "s"),
    MINUTE(ChronoUnit.MINUTES, TimeUnit.MINUTES, "min"),
    HOUR(ChronoUnit.HOURS, TimeUnit.HOURS, "h"),
    DAY(ChronoUnit.DAYS, TimeUnit.DAYS, "days"),
    WEEK(ChronoUnit.WEEKS, 604800000L, "weeks"),
    MONTH(ChronoUnit.MONTHS, 2629746000L, "months"),
    QUARTER(null, 7889238000L, "quarters"),
    YEAR(ChronoUnit.YEARS, 31556952000L, "years"),
    DECADE(ChronoUnit.DECADES, 315569520000L, "decades"),
    CENTURY(ChronoUnit.CENTURIES, 3155695200000L, "centuries"),
    MILLENIUM(ChronoUnit.MILLENNIA, 31556952000000L, "millennia");

    private final ChronoUnit myChronoUnit;
    private final long myDurationInMillis;
    private final long myDurationInNanos;
    private final long myHalf;
    private final String myLabel;
    private final TimeUnit myTimeUnit;

    private CalendarDateUnit(ChronoUnit chronoUnit, long millis, String label) {
        this.myChronoUnit = chronoUnit;
        this.myTimeUnit = null;
        this.myDurationInMillis = millis;
        this.myHalf = this.myDurationInMillis / 2L;
        this.myDurationInNanos = millis * 1000000L;
        this.myLabel = label;
    }

    private CalendarDateUnit(ChronoUnit chronoUnit, TimeUnit timeUnit, String label) {
        this.myChronoUnit = chronoUnit;
        this.myTimeUnit = timeUnit;
        this.myDurationInMillis = timeUnit.toMillis(1L);
        this.myHalf = this.myDurationInMillis / 2L;
        this.myDurationInNanos = timeUnit.toNanos(1L);
        this.myLabel = label;
    }

    @Override
    public <R extends Temporal> R addTo(R temporal, long amount) {
        if (temporal instanceof CalendarDate) {
            return (R)new CalendarDate(((CalendarDate)temporal).millis + this.toDurationInMillis());
        }
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.addTo(temporal, amount);
        }
        return ChronoUnit.MONTHS.addTo(temporal, 3L * amount);
    }

    @Override
    public CalendarDate adjustInto(CalendarDate temporal) {
        return new CalendarDate(this.adjustInto(temporal.millis));
    }

    @Override
    public long adjustInto(long epochMilli) {
        return epochMilli / this.myDurationInMillis * this.myDurationInMillis + this.myHalf;
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (temporal instanceof CalendarDate) {
            return this.adjustInto((CalendarDate)temporal);
        }
        Temporal retVal = temporal;
        if (MILLIS.toDurationInMillis() < this.myDurationInMillis) {
            retVal = retVal.with(ChronoField.MILLI_OF_SECOND, 0L);
            if (SECOND.toDurationInMillis() < this.myDurationInMillis) {
                retVal = retVal.with(ChronoField.SECOND_OF_MINUTE, 0L);
                if (MINUTE.toDurationInMillis() < this.myDurationInMillis) {
                    retVal = retVal.with(ChronoField.MINUTE_OF_HOUR, 0L);
                    if (HOUR.toDurationInMillis() < this.myDurationInMillis) {
                        retVal = retVal.with(ChronoField.HOUR_OF_DAY, 12L);
                        if (DAY.toDurationInMillis() < this.myDurationInMillis) {
                            if (WEEK.toDurationInMillis() == this.myDurationInMillis) {
                                retVal = retVal.minus(2L, ChronoUnit.DAYS).with(TemporalAdjusters.nextOrSame(DayOfWeek.FRIDAY));
                            } else if (MONTH.toDurationInMillis() == this.myDurationInMillis) {
                                retVal = retVal.with(TemporalAdjusters.lastDayOfMonth());
                            } else if (QUARTER.toDurationInMillis() == this.myDurationInMillis) {
                                int nextMonth = 3 + 3 * (retVal.get(ChronoField.MONTH_OF_YEAR) / 3);
                                retVal = retVal.with(ChronoField.MONTH_OF_YEAR, nextMonth).with(ChronoField.DAY_OF_MONTH, 1L).minus(1L, ChronoUnit.DAYS);
                            } else if (YEAR.toDurationInMillis() == this.myDurationInMillis) {
                                retVal = retVal.with(TemporalAdjusters.lastDayOfYear());
                            } else if (DECADE.toDurationInMillis() == this.myDurationInMillis) {
                                int nextYear = 10 + 10 * (retVal.get(ChronoField.YEAR) / 10);
                                retVal = retVal.with(ChronoField.YEAR, nextYear).with(TemporalAdjusters.firstDayOfYear()).minus(1L, ChronoUnit.DAYS);
                            } else if (CENTURY.toDurationInMillis() == this.myDurationInMillis) {
                                int nextYear = 100 + 100 * (retVal.get(ChronoField.YEAR) / 100);
                                retVal = retVal.with(ChronoField.YEAR, nextYear).with(TemporalAdjusters.firstDayOfYear()).minus(1L, ChronoUnit.DAYS);
                            } else if (MILLENIUM.toDurationInMillis() == this.myDurationInMillis) {
                                int nextYear = 1000 + 1000 * (retVal.get(ChronoField.YEAR) / 1000);
                                retVal = retVal.with(ChronoField.YEAR, nextYear).with(TemporalAdjusters.firstDayOfYear()).minus(1L, ChronoUnit.DAYS);
                            }
                        }
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public long between(Temporal temporal1Inclusive, Temporal temporal2Exclusive) {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.between(temporal1Inclusive, temporal2Exclusive);
        }
        return ChronoUnit.MONTHS.between(temporal1Inclusive, temporal2Exclusive) / 3L;
    }

    public CalendarDateDuration convert(CalendarDateDuration sourceDuration) {
        return sourceDuration.convertTo(this);
    }

    public double convert(CalendarDateUnit aSourceDurationUnit) {
        return this.convert(PrimitiveMath.ONE, aSourceDurationUnit);
    }

    public double convert(double sourceDurationMeasure, CalendarDateUnit sourceDurationUnit) {
        double destinationDurationInNanos;
        double sourceDurationInNanos = sourceDurationUnit.toDurationInNanos();
        if (sourceDurationInNanos > (destinationDurationInNanos = (double)this.myDurationInNanos)) {
            double scaleUp = sourceDurationInNanos / destinationDurationInNanos;
            return sourceDurationMeasure * scaleUp;
        }
        if (sourceDurationInNanos < destinationDurationInNanos) {
            double scaleDown = destinationDurationInNanos / sourceDurationInNanos;
            return sourceDurationMeasure / scaleDown;
        }
        return sourceDurationMeasure;
    }

    public long convert(long sourceMeassure, CalendarDateUnit sourceUnit) {
        Optional<TimeUnit> tmpTimeUnit = sourceUnit.getTimeUnit();
        if (this.myTimeUnit != null && tmpTimeUnit.isPresent()) {
            return this.myTimeUnit.convert(sourceMeassure, tmpTimeUnit.get());
        }
        return Math.round(this.convert((double)sourceMeassure, sourceUnit));
    }

    public long count(long aFromValue, long aToValue) {
        return (this.myHalf + this.adjustInto(aToValue) - this.adjustInto(aFromValue)) / this.myDurationInMillis;
    }

    public long get(TemporalUnit unit) {
        if (unit == this) {
            return this.myDurationInMillis;
        }
        return 0L;
    }

    public Optional<ChronoUnit> getChronoUnit() {
        return Optional.ofNullable(this.myChronoUnit);
    }

    @Override
    public Duration getDuration() {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.getDuration();
        }
        return ChronoUnit.MONTHS.getDuration().multipliedBy(3L);
    }

    public String getLabel() {
        return this.myLabel;
    }

    public Optional<TimeUnit> getTimeUnit() {
        return Optional.ofNullable(this.myTimeUnit);
    }

    public List<TemporalUnit> getUnits() {
        return Collections.singletonList(this);
    }

    public boolean isCalendarUnit() {
        return DAY.toDurationInMillis() <= this.toDurationInMillis();
    }

    @Override
    public boolean isDateBased() {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.isDateBased();
        }
        return true;
    }

    @Override
    public boolean isDurationEstimated() {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.isDurationEstimated();
        }
        return true;
    }

    @Override
    public boolean isTimeBased() {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.isTimeBased();
        }
        return false;
    }

    public CalendarDateDuration newDuration(double meassure) {
        return new CalendarDateDuration(meassure, this);
    }

    @Override
    public long toDurationInMillis() {
        return this.myDurationInMillis;
    }

    @Override
    public long toDurationInNanos() {
        return this.myDurationInNanos;
    }
}

