/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.ojalgo.ProgrammingError;

public abstract class ObjectPool<T> {
    private final boolean myLimited;
    private final BlockingQueue<T> myObjects;

    public ObjectPool() {
        this.myObjects = new LinkedBlockingQueue<T>();
        this.myLimited = false;
    }

    public ObjectPool(int capacity) {
        this.myObjects = new LinkedBlockingQueue<T>(capacity);
        this.myLimited = true;
        for (int i = 0; i < capacity; ++i) {
            this.myObjects.add(this.newObject());
        }
    }

    public final T borrow() {
        Object retVal;
        if (this.myLimited) {
            try {
                retVal = this.myObjects.take();
            }
            catch (InterruptedException cause) {
                throw new RuntimeException(cause);
            }
        } else {
            retVal = this.myObjects.poll();
            if (retVal == null) {
                retVal = this.newObject();
            }
        }
        return retVal;
    }

    public final void giveBack(T object) {
        ProgrammingError.throwIfNull(object);
        this.reset(object);
        if (this.myLimited) {
            try {
                this.myObjects.put(object);
            }
            catch (InterruptedException cause) {
                throw new RuntimeException(cause);
            }
        } else {
            this.myObjects.offer(object);
        }
    }

    protected abstract T newObject();

    protected abstract void reset(T var1);
}

