/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.concurrent.BlockingQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ojalgo.type.function.AutoSupplier;

final class SequencedSupplier<S, T>
implements AutoSupplier<T> {
    private Supplier<T> myCurrent;
    private final Function<S, ? extends Supplier<T>> myFactory;
    private final BlockingQueue<S> mySources;

    SequencedSupplier(BlockingQueue<S> sources, Function<S, ? extends Supplier<T>> factory) {
        this.mySources = sources;
        this.myFactory = factory;
        this.nextSupplier();
    }

    @Override
    public void close() throws Exception {
        if (this.myCurrent != null && this.myCurrent instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.myCurrent)).close();
        }
    }

    @Override
    public T read() {
        if (this.myCurrent == null) {
            return null;
        }
        T retVal = this.myCurrent.get();
        if (retVal == null) {
            if (this.myCurrent instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)this.myCurrent)).close();
                }
                catch (Exception cause) {
                    throw new RuntimeException(cause);
                }
            }
            this.nextSupplier();
            if (this.myCurrent != null) {
                retVal = this.myCurrent.get();
            }
        }
        return retVal;
    }

    private void nextSupplier() {
        Object next = this.mySources.poll();
        this.myCurrent = next != null ? this.myFactory.apply(next) : null;
    }
}

