/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.ojalgo.function.special.PowerOf2;
import org.ojalgo.type.function.AutoConsumer;

abstract class ShardedConsumer<T>
implements AutoConsumer<T> {
    private final Consumer<T>[] myConsumers;

    static <T> ShardedConsumer<T> of(ToIntFunction<T> distributor, Consumer<T>[] consumers) {
        if (PowerOf2.isPowerOf2(consumers.length)) {
            return new PowerOf2ShardedConsumer<T>(distributor, consumers);
        }
        return new GeneralShardedConsumer<T>(distributor, consumers);
    }

    ShardedConsumer(Consumer<T>[] consumers) {
        this.myConsumers = consumers;
    }

    @Override
    public void close() throws Exception {
        for (Consumer<T> consumer : this.myConsumers) {
            if (!(consumer instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)consumer)).close();
        }
    }

    static final class PowerOf2ShardedConsumer<T>
    extends ShardedConsumer<T> {
        private final Consumer<T>[] myConsumers;
        private final ToIntFunction<T> myDistributor;
        private final int myIndexMask;

        PowerOf2ShardedConsumer(ToIntFunction<T> distributor, Consumer<T>[] consumers) {
            super(consumers);
            if (!PowerOf2.isPowerOf2(consumers.length)) {
                throw new IllegalArgumentException("The number of consumers must be a power of 2!");
            }
            this.myConsumers = consumers;
            this.myDistributor = distributor;
            this.myIndexMask = consumers.length - 1;
        }

        @Override
        public void write(T item) {
            this.myConsumers[this.myDistributor.applyAsInt(item) & this.myIndexMask].accept(item);
        }
    }

    static final class GeneralShardedConsumer<T>
    extends ShardedConsumer<T> {
        private final Consumer<T>[] myConsumers;
        private final ToIntFunction<T> myDistributor;
        private final int myNumberOfShards;

        GeneralShardedConsumer(ToIntFunction<T> distributor, Consumer<T>[] consumers) {
            super(consumers);
            this.myConsumers = consumers;
            this.myDistributor = distributor;
            this.myNumberOfShards = consumers.length;
        }

        @Override
        public void write(T item) {
            this.myConsumers[Math.abs(this.myDistributor.applyAsInt(item) % this.myNumberOfShards)].accept(item);
        }
    }
}

