/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterStatus;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BooleanFilter
extends Filter {
    private static final String[] BOOLEAN_FILTER_VALUES = new String[]{"Yes", "No"};
    private static final Integer BOOLEAN_CB = 0;
    private Boolean m_bValue = null;

    public BooleanFilter(String variableName, ConvertValueInterface convertValueInterface, int modelColumn) {
        super(variableName, convertValueInterface, modelColumn);
    }

    @Override
    public Filter cloneFilter4Search() {
        BooleanFilter clone = new BooleanFilter(this.m_variableName, this.m_convertValueInterface, this.m_modelColumn);
        clone.m_bValue = this.m_bValue;
        this.setValuesForClone(clone);
        return clone;
    }

    @Override
    public FilterStatus checkValues() {
        return null;
    }

    @Override
    public boolean registerValues() {
        boolean hasChanged = false;
        if (this.isDefined()) {
            Boolean lastValue = this.m_bValue;
            this.m_bValue = ((JComboBox)this.getComponent(BOOLEAN_CB)).getSelectedIndex() == 0;
            hasChanged = lastValue == null || lastValue ^ this.m_bValue;
        }
        this.registerDefinedAsUsed();
        return hasChanged;
    }

    @Override
    public void createComponents(JPanel p, GridBagConstraints c) {
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        JLabel nameLabel = new JLabel(this.getName());
        p.add((Component)nameLabel, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("="), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        JComboBox<String> cb = (JComboBox<String>)this.getComponent(BOOLEAN_CB);
        if (cb == null) {
            cb = new JComboBox<String>(BOOLEAN_FILTER_VALUES);
            if (this.m_bValue != null) {
                cb.setSelectedIndex(this.m_bValue != false ? 0 : 1);
            }
            this.registerComponent(BOOLEAN_CB, cb);
        }
        p.add((Component)cb, c);
        c.gridx += 3;
    }

    @Override
    public void reset() {
        this.m_bValue = null;
    }

    @Override
    public boolean filter(Object v1, Object v2) {
        Boolean value = (Boolean)v1;
        if (this.m_bValue != null && value != null) {
            return this.m_bValue.equals(value);
        }
        return true;
    }
}

