/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterComboboxRenderer;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FilterPanel
extends JPanel {
    private Filter[] m_filters;
    private JPanel m_filterSelectedPanel;
    private JComboBox m_filterComboBox;
    private JButton m_addFilterButton;
    private DefaultDialog m_dialog;
    private int m_nbFiltersSelected = 0;

    public FilterPanel(DefaultDialog d) {
        this.m_dialog = d;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(" Filter(s) "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_filterSelectedPanel = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.m_filterSelectedPanel, c);
        this.m_filterComboBox = new JComboBox();
        this.m_filterComboBox.setRenderer(new FilterComboboxRenderer());
        this.m_addFilterButton = new JButton(IconManager.getIcon(IconManager.IconType.PLUS));
        this.m_addFilterButton.setMargin(new Insets(2, 2, 2, 2));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)this.m_filterComboBox, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.m_addFilterButton, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)Box.createHorizontalBox(), c);
        this.m_addFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter f = (Filter)FilterPanel.this.m_filterComboBox.getSelectedItem();
                if (f == null) {
                    return;
                }
                f.setDefined(true);
                FilterPanel.this.m_filterComboBox.removeItem(f);
                f.setIndex(FilterPanel.this.m_nbFiltersSelected);
                FilterPanel.this.initPrefilterSelectedPanel();
                FilterPanel.this.m_dialog.repack();
            }
        });
    }

    public void setFilters(Filter[] filters) {
        this.m_filters = filters;
        this.initPrefilterSelectedPanel();
        this.m_dialog.repack();
    }

    public void initPrefilterSelectedPanel() {
        this.m_filterSelectedPanel.removeAll();
        this.m_filterComboBox.removeAllItems();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        final int nbParameters = this.m_filters.length;
        this.m_nbFiltersSelected = 0;
        for (int i = 0; i < nbParameters; ++i) {
            final Filter currentFilter = this.m_filters[i];
            c.gridy = currentFilter.getIndex();
            if (currentFilter.isDefined()) {
                ++this.m_nbFiltersSelected;
                c.gridx = 0;
                if (currentFilter.getIndex() != 0) {
                    this.m_filterSelectedPanel.add((Component)new JLabel("AND"), c);
                } else {
                    this.m_filterSelectedPanel.add((Component)new JLabel("   "), c);
                }
                currentFilter.createComponents(this.m_filterSelectedPanel, c);
                c.weightx = 0.0;
                c.gridwidth = 1;
                c.weighty = 0.0;
                c.fill = 2;
                ++c.gridx;
                JButton removeButton = new JButton(IconManager.getIcon(IconManager.IconType.CROSS_SMALL7));
                removeButton.setMargin(new Insets(2, 2, 2, 2));
                removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        currentFilter.setDefined(false);
                        for (int j = 0; j < nbParameters; ++j) {
                            if (FilterPanel.this.m_filters[j].getIndex() <= currentFilter.getIndex()) continue;
                            FilterPanel.this.m_filters[j].setIndex(FilterPanel.this.m_filters[j].getIndex() - 1);
                        }
                        currentFilter.setIndex(-1);
                        FilterPanel.this.initPrefilterSelectedPanel();
                        FilterPanel.this.m_dialog.repack();
                    }
                });
                this.m_filterSelectedPanel.add((Component)removeButton, c);
                continue;
            }
            this.m_filterComboBox.addItem(currentFilter);
        }
    }
}

