/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.AxisTicks;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.cursor.AbstractCursor;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;

public class YAxis
extends Axis {
    private AxisTicks m_ticks;
    private int m_lastHeight;
    private boolean m_isLeftAxis = true;
    private int m_lineXStart;
    private Color m_rightRefColor;

    public YAxis(BasePlotPanel p) {
        super(p);
    }

    public void setSecondAxis() {
        this.m_isLeftAxis = false;
    }

    public void setColorOnTitle(Color color) {
        this.m_rightRefColor = color;
    }

    private void calculLineXStart() {
        this.m_lineXStart = !this.m_isLeftAxis ? this.m_x + 5 : this.m_x + this.m_width - 5;
    }

    @Override
    public void setSize(int x, int y, int width, int height) {
        super.setSize(x, y, width, height);
        this.calculLineXStart();
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.m_valuesFont == null) {
            this.m_valuesFont = g.getFont().deriveFont(0, 10.0f);
            this.m_valuesFontMetrics = g.getFontMetrics(this.m_valuesFont);
        }
        if (this.m_selected) {
            g.setColor(Color.darkGray);
            g.fillRect(this.m_x, this.m_y - this.m_valuesFontMetrics.getHeight() / 2, this.m_width, this.m_height + this.m_valuesFontMetrics.getHeight());
        }
        int maxTicks = this.m_height / 20;
        this.m_ticks = new AxisTicks(this.m_minValue, this.m_maxValue, maxTicks, this.m_log, 1.0E-12, this.m_isInteger, this.m_isEnum);
        if (this.m_selected) {
            g.setColor(Color.white);
        } else {
            g.setColor(Color.black);
        }
        if (this.m_log) {
            this.paintLog(g, this.m_ticks);
        } else {
            this.paintLinear(g, this.m_ticks);
        }
        if (this.m_title != null && this.m_displayTitle) {
            this.drawTitle(g);
        }
    }

    private void drawTitle(Graphics2D g) {
        if (this.m_title != null) {
            if (this.m_titleFont == null) {
                AffineTransform affineTr = new AffineTransform();
                affineTr.rotate(-1.5707963267948966);
                this.m_titleFont = g.getFont().deriveFont(1, 11.0f);
                this.m_titleFontMetrics = g.getFontMetrics(this.m_titleFont);
                this.m_titleFont = this.m_titleFont.deriveFont(affineTr);
            }
            Font prevFont = g.getFont();
            g.setFont(this.m_titleFont);
            if (this.m_selected) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.black);
            }
            int titleWidth = this.m_titleFontMetrics.stringWidth(this.m_title);
            int width = 20;
            int ascent = this.m_titleFontMetrics.getAscent();
            int descent = this.m_titleFontMetrics.getDescent();
            int bottom = this.m_isLeftAxis ? this.m_x : this.m_lineXStart + 30;
            int top = bottom + width;
            int baseline = top + (bottom - top) / 2 - (ascent + descent) / 2 + ascent;
            int sideLength = width / 2;
            if (!this.m_isLeftAxis && this.m_rightRefColor != null) {
                Color txtColor = g.getColor();
                g.setColor(this.m_rightRefColor);
                int bx = bottom + width / 3;
                int by = this.m_y + (this.m_height - titleWidth - sideLength) / 2;
                g.fillRect(bx, by, sideLength, sideLength);
                g.setColor(txtColor);
            }
            g.drawString(this.m_title, baseline, this.m_y + (this.m_height + titleWidth + sideLength) / 2);
            g.setFont(prevFont);
        }
    }

    @Override
    public void paintCursor(Graphics2D g, AbstractCursor cursor, boolean selected) {
        int height;
        int stringWidth;
        String label;
        int fractionalDigits;
        g.setFont(this.m_valuesFont);
        int DELTA = 3;
        double y = cursor.getValue();
        int integerDigits = cursor.getIntegerDigits();
        if (integerDigits == -1) {
            integerDigits = this.m_ticks.getIntegerDigits();
        }
        if ((fractionalDigits = cursor.getFractionalDigits()) == -1) {
            fractionalDigits = this.m_ticks.getFractionalDigits() + 2;
        }
        double multForRounding = Math.pow(10.0, fractionalDigits);
        if (this.m_isEnum) {
            label = this.m_plotPanel.getEnumValueY((int)Math.round(y), false, this);
            stringWidth = this.m_valuesFontMetrics.stringWidth(label);
            height = (int)Math.round(StrictMath.ceil(this.m_valuesFontMetrics.getLineMetrics(label, g).getHeight()));
        } else {
            double yDisplay = y;
            if (fractionalDigits > 0) {
                yDisplay = (double)StrictMath.round(yDisplay * multForRounding) / multForRounding;
            }
            DecimalFormat df = this.selectDecimalFormat(fractionalDigits + 2, integerDigits);
            cursor.setFormat(integerDigits, fractionalDigits, df);
            label = df.format(yDisplay);
            stringWidth = this.m_valuesFontMetrics.stringWidth(label);
            height = (int)Math.round(StrictMath.ceil(this.m_valuesFontMetrics.getLineMetrics(label, g).getHeight()));
        }
        Stroke prevStroke = g.getStroke();
        g.setStroke(selected ? AbstractCursor.LINE2_STROKE : cursor.getStroke());
        g.setFont(this.m_valuesFont);
        int halfAscent = this.m_valuesFontMetrics.getAscent() / 2;
        int pY = this.valueToPixel(y);
        int x1 = this.m_x + this.m_width - stringWidth - 6 - 5 - 3;
        int x2 = this.m_x + this.m_width - 5;
        g.setColor(Color.white);
        g.fillRect(x1, pY - halfAscent - 3, x2 - x1, height + 6);
        g.setColor(cursor.getColor());
        g.drawRect(x1, pY - halfAscent - 3, x2 - x1, height + 6);
        g.drawString(label, this.m_lineXStart - stringWidth - 6, pY + halfAscent);
        g.drawLine(this.m_lineXStart, pY, this.m_lineXStart - 5, pY);
        g.setStroke(prevStroke);
    }

    private void paintLinear(Graphics2D g, AxisTicks ticks) {
        this.m_minTick = ticks.getTickMin();
        this.m_maxTick = ticks.getTickMax();
        this.m_tickSpacing = ticks.getTickSpacing();
        int fractionalDigits = ticks.getFractionalDigits();
        int integerDigits = ticks.getIntegerDigits();
        if (fractionalDigits != this.m_fractionalDigits || integerDigits != this.m_integerDigits || this.m_df == null) {
            this.m_df = this.selectDecimalFormat(fractionalDigits, integerDigits);
            this.m_dfPlot = this.selectDecimalFormat(fractionalDigits + 2, integerDigits);
            this.m_fractionalDigits = fractionalDigits;
            this.m_integerDigits = integerDigits;
        }
        if (this.m_selected) {
            g.setColor(Color.white);
        } else {
            g.setColor(CyclicColorPalette.GRAY_TEXT_DARK);
        }
        g.setFont(this.m_valuesFont);
        int halfAscent = this.m_valuesFontMetrics.getAscent() / 2;
        int pixelStart = this.valueToPixel(this.m_minValue);
        int pixelStop = this.valueToPixel(this.m_maxValue);
        g.drawLine(this.m_lineXStart, pixelStart, this.m_lineXStart, pixelStop);
        if (pixelStart <= pixelStop) {
            return;
        }
        double multForRounding = Math.pow(10.0, fractionalDigits);
        this.m_lastHeight = -1;
        double y = this.m_minTick;
        if (this.valueToPixel(y) > pixelStart) {
            y += this.m_tickSpacing;
        }
        int pY = this.valueToPixel(y);
        int previousEndY = Integer.MAX_VALUE;
        do {
            int tickStringX;
            int stringWidth;
            String label;
            if (this.m_isEnum) {
                label = this.m_plotPanel.getEnumValueY((int)Math.round(y), false, this);
                if (label == null) {
                    label = " ";
                }
                stringWidth = this.m_valuesFontMetrics.stringWidth(label);
                int height = (int)Math.round(StrictMath.ceil(this.m_valuesFontMetrics.getLineMetrics(label, g).getHeight()));
                if (height > this.m_lastHeight) {
                    this.m_lastHeight = height;
                }
            } else {
                double yDisplay = y;
                if (fractionalDigits > 0) {
                    yDisplay = (double)StrictMath.round(yDisplay * multForRounding) / multForRounding;
                }
                label = this.m_df.format(yDisplay);
                stringWidth = this.m_valuesFontMetrics.stringWidth(label);
                int height = (int)Math.round(StrictMath.ceil(this.m_valuesFontMetrics.getLineMetrics(label, g).getHeight()));
                if (height > this.m_lastHeight) {
                    this.m_lastHeight = height;
                }
            }
            int tickX = this.m_isLeftAxis ? this.m_lineXStart : this.m_lineXStart + 4;
            int n = tickStringX = this.m_isLeftAxis ? this.m_lineXStart - stringWidth - 6 : this.m_lineXStart + 6;
            if (pY >= previousEndY - this.m_lastHeight - 2) continue;
            g.drawString(label, tickStringX, pY + halfAscent);
            g.drawLine(tickX, pY, tickX - 4, pY);
            previousEndY = pY;
        } while ((pY = this.valueToPixel(y += this.m_tickSpacing)) >= pixelStop);
    }

    private void paintLog(Graphics2D g, AxisTicks ticks) {
        this.m_minTick = ticks.getTickMin();
        this.m_maxTick = ticks.getTickMax();
        this.m_tickSpacing = ticks.getTickSpacing();
        if (this.m_df == null) {
            this.m_df = this.selectLogDecimalFormat();
            this.m_dfPlot = this.selectLogDecimalFormat();
        }
        if (this.m_selected) {
            g.setColor(Color.white);
        } else {
            g.setColor(CyclicColorPalette.GRAY_TEXT_DARK);
        }
        g.setFont(this.m_valuesFont);
        int halfAscent = this.m_valuesFontMetrics.getAscent() / 2;
        int pixelStart = this.valueToPixel(this.m_minValue);
        int pixelStop = this.valueToPixel(this.m_maxValue);
        g.drawLine(this.m_lineXStart, pixelStart, this.m_lineXStart, pixelStop);
        if (pixelStart <= pixelStop) {
            return;
        }
        this.m_lastHeight = -1;
        int previousEndY = Integer.MAX_VALUE;
        double y = this.m_minTick;
        int pY = pixelStart;
        do {
            double yDisplay = y;
            String s = this.m_df.format(yDisplay);
            int stringWidth = this.m_valuesFontMetrics.stringWidth(s);
            if (this.m_selected) {
                g.setColor(Color.white);
            } else {
                g.setColor(CyclicColorPalette.GRAY_TEXT_DARK);
            }
            int height = (int)Math.round(StrictMath.ceil(this.m_valuesFontMetrics.getLineMetrics(s, g).getHeight()));
            if (height > this.m_lastHeight) {
                this.m_lastHeight = height;
            }
            int tickX = this.m_isLeftAxis ? this.m_lineXStart : this.m_lineXStart + 4;
            int tickStringX = this.m_isLeftAxis ? this.m_lineXStart - stringWidth - 6 : this.m_lineXStart + 6;
            int delta = pY - this.valueToPixel(Math.pow(10.0, y));
            if (pY < previousEndY - this.m_lastHeight - 2 && delta == 0) {
                g.drawString(s, tickStringX, pY + halfAscent);
                g.drawLine(tickX, pY, tickX - 4, pY);
                previousEndY = pY;
            }
            pY = this.valueToPixel(Math.pow(10.0, y += this.m_tickSpacing));
            if (this.m_selected) {
                g.setColor(Color.white);
            } else {
                g.setColor(CyclicColorPalette.GRAY_TEXT_LIGHT);
            }
            tickX = this.m_isLeftAxis ? this.m_lineXStart : this.m_lineXStart + 3;
            for (int i = 2; i <= 9; ++i) {
                double yMinTick = Math.pow(10.0, y) * ((double)i * 0.1);
                int pMinTick = this.valueToPixel(yMinTick);
                if (pMinTick < pixelStop || pMinTick > pixelStart) continue;
                g.drawLine(tickX, pMinTick, tickX - 3, pMinTick);
            }
        } while (pY >= pixelStop);
    }

    public void paintGrid(Graphics2D g, int x, int width, int y, int height) {
        if (this.m_log) {
            this.paintGridLog(g, x, width);
        } else {
            this.paintGridLinear(g, x, width, y, height);
        }
    }

    public void paintGridLinear(Graphics2D g, int xPixel, int width, int yPixel, int height) {
        int pixelStop;
        int pixelStart = this.valueToPixel(this.m_minTick);
        if (pixelStart <= (pixelStop = this.valueToPixel(this.m_maxTick))) {
            return;
        }
        g.setColor(CyclicColorPalette.GRAY_GRID);
        Stroke s = g.getStroke();
        g.setStroke(DASHED);
        double y = this.m_minTick;
        int pY = pixelStart;
        int previousEndY = Integer.MAX_VALUE;
        do {
            if (pY >= previousEndY - this.m_lastHeight - 2) continue;
            if (pY >= yPixel && pY <= yPixel + height) {
                g.drawLine(xPixel + 1, pY, xPixel + width, pY);
            }
            previousEndY = pY;
        } while ((pY = this.valueToPixel(y += this.m_tickSpacing)) >= pixelStop);
        g.setStroke(s);
    }

    public void paintGridLog(Graphics2D g, int x, int width) {
        int pixelStop;
        int pixelStart = this.valueToPixel(Math.pow(10.0, this.m_minTick));
        if (pixelStart <= (pixelStop = this.valueToPixel(Math.pow(10.0, this.m_maxTick)))) {
            return;
        }
        Stroke s = g.getStroke();
        g.setStroke(DASHED);
        double y = this.m_minTick;
        int pY = pixelStart;
        block0: while (true) {
            g.setColor(CyclicColorPalette.GRAY_GRID);
            g.drawLine(x + 1, pY, x + width, pY);
            pY = this.valueToPixel(Math.pow(10.0, y += this.m_tickSpacing));
            if (pY < pixelStop) break;
            g.setColor(CyclicColorPalette.GRAY_GRID_LOG);
            int i = 2;
            while (true) {
                if (i > 9) continue block0;
                double yMinTick = Math.pow(10.0, y) * ((double)i * 0.1);
                int pMinTick = this.valueToPixel(yMinTick);
                g.drawLine(x + 1, pMinTick, x + width, pMinTick);
                ++i;
            }
            break;
        }
        g.setStroke(s);
    }

    @Override
    public int valueToPixel(double v) {
        if (this.m_isPixel) {
            return (int)Math.round(this.m_maxValue - v);
        }
        if (this.m_log) {
            double logV = v <= 1.0E-12 || Double.isNaN(v) ? Math.log10(1.0E-12) : Math.log10(v);
            double min = Math.log10(this.m_minValue <= 1.0E-12 ? 1.0E-12 : this.m_minValue);
            double max = Math.log10(this.m_maxValue <= 1.0E-12 ? 1.0E-11 : this.m_maxValue);
            return this.m_y + this.m_height - (int)Math.round((logV - min) / (max - min) * (double)this.m_height);
        }
        return this.m_y + this.m_height - (int)Math.round((v - this.m_minValue) / (this.m_maxValue - this.m_minValue) * (double)this.m_height);
    }

    @Override
    public double pixelToValue(int pixel) {
        if (this.m_log) {
            double min = Math.log10(this.m_minValue <= 1.0E-12 ? 1.0E-12 : this.m_minValue);
            double max = Math.log10(this.m_maxValue <= 1.0E-12 ? 1.0E-11 : this.m_maxValue);
            double v = min + (double)(this.m_y + this.m_height - pixel) / (double)this.m_height * (max - min);
            v = Math.pow(10.0, v);
            return v;
        }
        double v = this.m_minValue + (double)(this.m_y + this.m_height - pixel) / (double)this.m_height * (this.m_maxValue - this.m_minValue);
        return v;
    }

    @Override
    public double deltaPixelToDeltaValue(int deltaPixel) {
        double value1 = this.pixelToValue(this.m_height / 2);
        double value2 = this.pixelToValue(this.m_height / 2 + deltaPixel);
        return value2 - value1;
    }

    @Override
    public double deltaPixelToLogMultValue(int deltaPixel) {
        double min = Math.log10(this.m_minValue <= 1.0E-12 ? 1.0E-12 : this.m_minValue);
        double max = Math.log10(this.m_maxValue <= 1.0E-12 ? 1.0E-11 : this.m_maxValue);
        double mult = Math.pow(10.0, (max - min) * ((double)deltaPixel / (double)this.m_height));
        if (Math.pow(10.0, min) / mult < 1.0E-12) {
            mult = Math.pow(10.0, min) / 1.0E-12;
        }
        return mult;
    }
}

