/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.core;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.ExtendableButtonPanel;
import fr.proline.studio.graphics.ExtendableButtonPanelGroup;
import fr.proline.studio.graphics.core.PlotToolbarListenerInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public abstract class GraphicsToolbarPanel
extends HourglassPanel
implements PlotToolbarListenerInterface {
    private JLayeredPane m_layeredPane;
    protected BasePlotPanel m_plotPanel;
    private JToolBar m_toolbar = null;
    protected JToggleButton m_normalModeButton = null;
    protected JToggleButton m_selectionModeButton = null;
    protected JButton m_zoomButton = null;
    protected JToggleButton m_viewAllMapButton = null;
    protected JToggleButton m_gridButton = null;
    protected JButton m_importSelectionButton = null;
    protected JButton m_exportSelectionButton = null;
    protected boolean m_dataLocked = false;
    protected boolean m_isDoubleYAxis;

    public GraphicsToolbarPanel(boolean dataLocked, boolean isDoubleYAxis) {
        this.setLayout(new BorderLayout());
        this.m_dataLocked = dataLocked;
        this.m_isDoubleYAxis = isDoubleYAxis;
        this.m_layeredPane = new JLayeredPane();
        this.add((Component)this.m_layeredPane, "Center");
        final JPanel mainPanel = this.createMainPanel();
        this.m_layeredPane.add((Component)mainPanel, JLayeredPane.DEFAULT_LAYER);
        this.m_layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                mainPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                GraphicsToolbarPanel.this.m_layeredPane.revalidate();
                GraphicsToolbarPanel.this.m_layeredPane.repaint();
            }
        });
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel internalPanel = this.initInternalPanel();
        mainPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        mainPanel.add((Component)toolbar, "West");
        return mainPanel;
    }

    public void addToLayer(JPanel p) {
        this.m_layeredPane.add((Component)p, JLayeredPane.PALETTE_LAYER);
    }

    private JPanel initInternalPanel() {
        JPanel p = this.createInternalPanel();
        return p;
    }

    private JToolBar initToolbar() {
        this.m_toolbar = new JToolBar(1);
        this.m_toolbar.setFloatable(false);
        ButtonGroup buttonModeGroup = new ButtonGroup();
        ExtendableButtonPanelGroup extendablePanelGroup = new ExtendableButtonPanelGroup();
        this.m_normalModeButton = new JToggleButton(IconManager.getIcon(IconManager.IconType.MOUSE_POINTER));
        this.m_normalModeButton.setFocusPainted(false);
        this.m_normalModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsToolbarPanel.this.m_plotPanel.setMouseMode(BasePlotPanel.MOUSE_MODE.NORMAL_MODE);
            }
        });
        buttonModeGroup.add(this.m_normalModeButton);
        ActionListener mouseSelectSquareActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsToolbarPanel.this.m_plotPanel.setMouseMode(BasePlotPanel.MOUSE_MODE.SELECTION_MODE);
                GraphicsToolbarPanel.this.m_plotPanel.setSelectionType(true);
            }
        };
        ActionListener mouseSelectFreeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsToolbarPanel.this.m_plotPanel.setMouseMode(BasePlotPanel.MOUSE_MODE.SELECTION_MODE);
                GraphicsToolbarPanel.this.m_plotPanel.setSelectionType(false);
            }
        };
        this.m_selectionModeButton = new JToggleButton(IconManager.getIcon(IconManager.IconType.MOUSE_SELECT_SQUARE));
        this.m_selectionModeButton.setSelected(false);
        this.m_selectionModeButton.setFocusPainted(false);
        this.m_selectionModeButton.addActionListener(mouseSelectSquareActionListener);
        buttonModeGroup.add(this.m_selectionModeButton);
        JButton selectionModeSquareButton = new JButton(IconManager.getIcon(IconManager.IconType.MOUSE_SELECT_SQUARE));
        selectionModeSquareButton.addActionListener(mouseSelectSquareActionListener);
        selectionModeSquareButton.setToolTipText("Square Selection");
        JButton selectionModeFreeButton = new JButton(IconManager.getIcon(IconManager.IconType.MOUSE_SELECT_FREE));
        selectionModeFreeButton.addActionListener(mouseSelectFreeActionListener);
        selectionModeFreeButton.setToolTipText("Free Selection");
        ExtendableButtonPanel extendableButtonSelectionPanel = new ExtendableButtonPanel(this.m_selectionModeButton);
        this.addToLayer(extendableButtonSelectionPanel);
        extendableButtonSelectionPanel.registerButton(selectionModeSquareButton);
        extendableButtonSelectionPanel.registerButton(selectionModeFreeButton);
        extendablePanelGroup.add(extendableButtonSelectionPanel);
        ActionListener zoomInAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsToolbarPanel.this.m_plotPanel.zoomIn();
            }
        };
        ActionListener zoomOutAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsToolbarPanel.this.m_plotPanel.zoomOut();
            }
        };
        ActionListener viewAllAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsToolbarPanel.this.m_plotPanel.viewAll();
            }
        };
        this.m_zoomButton = new JButton(IconManager.getIcon(IconManager.IconType.ZOOM_IN));
        this.m_zoomButton.addActionListener(zoomInAction);
        JButton zoomInButton = new JButton(IconManager.getIcon(IconManager.IconType.ZOOM_IN));
        zoomInButton.addActionListener(zoomInAction);
        zoomInButton.setToolTipText("Zoom In");
        JButton zoomOutButton = new JButton(IconManager.getIcon(IconManager.IconType.ZOOM_OUT));
        zoomOutButton.addActionListener(zoomOutAction);
        zoomOutButton.setToolTipText("Zoom Out");
        JButton viewAlltButton = new JButton(IconManager.getIcon(IconManager.IconType.ZOOM_FIT));
        viewAlltButton.addActionListener(viewAllAction);
        viewAlltButton.setToolTipText("View all");
        ExtendableButtonPanel extendableButtonPanel = new ExtendableButtonPanel(this.m_zoomButton);
        this.addToLayer(extendableButtonPanel);
        extendableButtonPanel.registerButton(zoomInButton);
        extendableButtonPanel.registerButton(zoomOutButton);
        extendableButtonPanel.registerButton(viewAlltButton);
        extendablePanelGroup.add(extendableButtonPanel);
        this.m_viewAllMapButton = new JToggleButton(IconManager.getIcon(IconManager.IconType.VIEW_ALL));
        this.m_viewAllMapButton.setSelected(false);
        this.m_viewAllMapButton.setFocusPainted(false);
        this.m_viewAllMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsToolbarPanel.this.m_plotPanel.displayViewAllMap(GraphicsToolbarPanel.this.m_viewAllMapButton.isSelected());
            }
        });
        this.m_gridButton = new JToggleButton(IconManager.getIcon(IconManager.IconType.GRID));
        this.m_gridButton.setSelected(true);
        this.m_gridButton.setFocusPainted(false);
        this.m_gridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsToolbarPanel.this.m_plotPanel.displayGrid(GraphicsToolbarPanel.this.m_gridButton.isSelected());
            }
        });
        this.m_normalModeButton.doClick();
        this.m_toolbar.add(this.m_normalModeButton);
        this.m_toolbar.add(this.m_selectionModeButton);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.m_zoomButton);
        this.m_toolbar.add(this.m_gridButton);
        this.m_toolbar.add(this.m_viewAllMapButton);
        return this.m_toolbar;
    }

    protected void fillGraphicToolbar() {
        this.fillToolbar(this.m_toolbar);
    }

    protected abstract JPanel createInternalPanel();

    protected abstract void fillToolbar(JToolBar var1);

    public boolean isNormalMode() {
        return this.m_normalModeButton.isSelected();
    }

    public boolean isSelectionMode() {
        return this.m_selectionModeButton.isSelected();
    }

    @Override
    public void stateModified(PlotToolbarListenerInterface.BUTTONS b) {
        switch (b) {
            case GRID: {
                if (this.m_plotPanel.displayGrid()) break;
                this.m_gridButton.setSelected(false);
                break;
            }
            case VIEW_ALL_MAP: {
                this.m_viewAllMapButton.setSelected(this.m_plotPanel.isViewAllMapDisplayed());
            }
        }
    }

    @Override
    public void enable(PlotToolbarListenerInterface.BUTTONS b, boolean v) {
        switch (b) {
            case GRID: {
                this.m_gridButton.setEnabled(v);
                break;
            }
            case IMPORT_SELECTION: {
                this.m_importSelectionButton.setEnabled(v);
                break;
            }
            case EXPORT_SELECTION: {
                this.m_exportSelectionButton.setEnabled(v);
                break;
            }
            case VIEW_ALL_MAP: {
                this.m_viewAllMapButton.setEnabled(v);
            }
        }
    }
}

