/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.measurement;

import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.measurement.DeltaXMeasurement;

public class IntegralMeasurement
extends DeltaXMeasurement {
    public IntegralMeasurement(PlotBaseAbstract plot) {
        super(plot);
        DeltaXMeasurement.AlgorithmMeasurement integralAlgorithm = new DeltaXMeasurement.AlgorithmMeasurement(){

            @Override
            public String getName() {
                return "Integral measurement";
            }

            @Override
            public String calculate(PlotBaseAbstract plot, double x1, double x2) {
                PlotLinear plotLinear = (PlotLinear)plot;
                double integral = IntegralMeasurement.this.calculateIntegral(plotLinear.getDataX(), plotLinear.getDataY(), x1, x2);
                String res = plot.getBasePlotPanel().getXAxis().defaultFormat(integral);
                return res;
            }
        };
        this.setAlgorithm(integralAlgorithm);
    }

    @Override
    public void applyMeasurement(int x, int y) {
        super.applyMeasurement(x, y);
    }

    private double calculateIntegral(double[] dataX, double[] dataY, double xStartD, double xEndD) {
        int size;
        double area = 0.0;
        int n = size = dataX == null ? 0 : dataX.length;
        if (size > 0) {
            double x0 = dataX[0];
            double y0 = dataY[0];
            boolean isNan0 = Double.isNaN(x0) || Double.isNaN(y0);
            for (int i = 1; i < size; ++i) {
                boolean isNan1;
                double x1 = dataX[i];
                double y1 = dataY[i];
                if (!isNan0 & !(isNan1 = Double.isNaN(x1) || Double.isNaN(y1)) && !(x1 < xStartD)) {
                    if (x0 > xEndD) break;
                    if (x0 < xStartD) {
                        if (x1 <= xEndD) {
                            yStartD = (xStartD - x0) / (x1 - x0) * (y1 - y0) + y0;
                            area += (yStartD + y1) / 2.0 * (x1 - xStartD);
                        } else {
                            yStartD = (xStartD - x0) / (x1 - x0) * (y1 - y0) + y0;
                            double yEndD = (xEndD - x0) / (x1 - x0) * (y1 - y0) + y0;
                            area += (yStartD + yEndD) / 2.0 * (xEndD - xStartD);
                        }
                    } else if (x1 <= xEndD) {
                        area += (y0 + y1) / 2.0 * (x1 - x0);
                    } else {
                        double yEndD = (xEndD - x0) / (x1 - x0) * (y1 - y0) + y0;
                        area += (yEndD + y1) / 2.0 * (x1 - xEndD);
                    }
                }
                x0 = x1;
                y0 = y1;
                isNan0 = isNan1;
            }
        }
        return area;
    }
}

