/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.Exceptions;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.settings.FilePreferences;
import fr.proline.studio.settings.SettingsDialog;
import fr.proline.studio.settings.SettingsUtils;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.slf4j.LoggerFactory;

public abstract class DefaultStorableDialog
extends DefaultDialog {
    public DefaultStorableDialog() {
        this.init();
    }

    public DefaultStorableDialog(Window parent) {
        super(parent);
        this.init();
    }

    public DefaultStorableDialog(Window parent, Dialog.ModalityType modalityType) {
        super(parent, modalityType);
        this.init();
    }

    public DefaultStorableDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setButtonVisible(3, true);
        this.setButtonVisible(4, true);
    }

    protected abstract String getSettingsKey();

    protected abstract void saveParameters(Preferences var1) throws Exception;

    protected abstract boolean checkParameters();

    protected abstract void resetParameters() throws Exception;

    protected abstract void loadParameters(Preferences var1) throws Exception;

    @Override
    protected boolean saveCalled() {
        if (!this.checkParameters()) {
            return false;
        }
        JFileChooser fileChooser = SettingsUtils.getFileChooser(this.getSettingsKey());
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            try {
                File f = fileChooser.getSelectedFile();
                if (f.exists()) {
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.close();
                }
                FilePreferences filePreferences = new FilePreferences(f, null, "");
                this.saveParameters(filePreferences);
                SettingsUtils.addSettingsPath(this.getSettingsKey(), f.getAbsolutePath());
                SettingsUtils.writeDefaultDirectory(this.getSettingsKey(), f.getParent());
            }
            catch (Exception e) {
                Exceptions.printStackTrace(e);
                JOptionPane.showMessageDialog(this, "Error saving settings " + e.getMessage(), "Save Settings Error", 0);
            }
        }
        return false;
    }

    @Override
    protected boolean loadCalled() {
        SettingsDialog settingsDialog = new SettingsDialog((Window)this, this.getSettingsKey());
        settingsDialog.setLocationRelativeTo(this);
        settingsDialog.setVisible(true);
        if (settingsDialog.getButtonClicked() == 0) {
            if (settingsDialog.isDefaultSettingsSelected()) {
                try {
                    this.resetParameters();
                }
                catch (Exception e) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Reset Settings Failed", (Throwable)e);
                    this.setStatus(true, "Reset Settings Failed");
                }
            } else {
                try {
                    File settingsFile = settingsDialog.getSelectedFile();
                    FilePreferences filePreferences = new FilePreferences(settingsFile, null, "");
                    this.loadParameters(filePreferences);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Parsing of User Settings File Failed", (Throwable)e);
                    this.setStatus(true, "Parsing of your Settings File failed");
                }
            }
        }
        return false;
    }
}

