/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class HelpHeaderPanel
extends JPanel {
    String m_title;
    String m_helpText;
    Icon m_icon;

    public HelpHeaderPanel() {
        this(null, null);
    }

    public HelpHeaderPanel(String title) {
        this(title, null);
    }

    public HelpHeaderPanel(String title, String helpText) {
        this(IconManager.getIcon(IconManager.IconType.WAND_HAT), title, helpText);
    }

    public HelpHeaderPanel(Icon icon, String title, String helpText) {
        this.m_title = title;
        this.m_helpText = helpText;
        this.m_icon = icon;
        this.initComponent();
    }

    private void initComponent() {
        if (this.m_title == null && this.m_helpText == null) {
            this.setVisible(false);
            return;
        }
        this.htmlWizard(this.m_title, this.m_helpText);
        this.setVisible(true);
    }

    public void htmlWizard(String htmlSupportedTitle, String htmlSupportedHelpText) {
        Object help;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, null, 0, 0);
        this.setBackground(Color.white);
        if (this.m_icon != null) {
            c.insets = new Insets(10, 15, 10, 15);
            JLabel wizardLabel = new JLabel(this.m_icon);
            wizardLabel.setPreferredSize(new Dimension(30, 30));
            this.add((Component)wizardLabel, c);
            c.gridx = 1;
            c.fill = 1;
            c.anchor = 18;
            c.weightx = 1.0;
            c.weighty = 1.0;
        }
        c.insets = new Insets(5, 5, 10, 5);
        JTextPane wizardPane = new JTextPane();
        wizardPane.setEditable(false);
        wizardPane.setContentType("text/html");
        Object title = HelpHeaderPanel.removeHtmlTag(htmlSupportedTitle);
        if (!((String)title).isEmpty()) {
            title = "<div id=\"label\">" + (String)title + "</div>";
        }
        if (!((String)(help = HelpHeaderPanel.removeHtmlTag(htmlSupportedHelpText))).isEmpty()) {
            help = "<div id=\"help\">" + (String)help + "</div>";
        }
        String fontFamily = this.getFont().getFamily();
        int fontSize = this.getFont().getSize();
        String html = String.format(this.htmlModel(), fontFamily, fontSize, fontFamily, fontSize, title, help);
        wizardPane.setText(html);
        this.add((Component)wizardPane, c);
        this.setBorder(BorderFactory.createEtchedBorder(1));
    }

    private String htmlModel() {
        return "<html> \n   <head>\n      <style type=\"text/css\">  \n         #label{\n         color: black; \n         font-family: %s;\n         font-weight: bold;\n         font-size: %d;\n         padding-top: 3px;\n         padding-bottom: 3px; \n         } \n         #help{\n         color: Gray; \n         font-family: %s;\n         font-size: %d;\n         padding-top: 6px;\n         padding-bottom: 6px;\n         } \n      </style> \n   </head> \n   <body>\n\t%s <!-- title --> \n\t%s <!-- help text -->\n   </body> \n</html>";
    }

    private static String removeHtmlTag(String txt) {
        if (txt != null && !txt.isEmpty()) {
            if (txt.contains("<html>") || txt.contains("</html>")) {
                String newTxt = txt.replaceAll("<html>", "").replaceAll("</html>", "");
                return newTxt;
            }
            return txt;
        }
        return "";
    }
}

