/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class InfoDialog
extends DefaultDialog {
    private String m_message;
    private JCheckBox m_showNextTimecheckBox = null;
    private String m_showAtStartKey;
    private boolean m_useArea;

    public InfoDialog(Window parent, InfoType type, String title, String message, boolean useBigIcon) {
        this(parent, type, title, message, null, useBigIcon, false);
    }

    public InfoDialog(Window parent, InfoType type, String title, String message, String showAtStartKey, boolean useBigIcon, boolean useTextArea) {
        super(parent);
        this.m_useArea = useTextArea;
        this.setTitle(title);
        this.m_message = message;
        this.m_showAtStartKey = showAtStartKey;
        this.setButtonVisible(5, false);
        this.setButtonName(0, "Yes");
        this.setButtonName(1, "No");
        this.setStatusVisible(false);
        ImageIcon icon = null;
        switch (type) {
            case WARNING: {
                if (useBigIcon) {
                    icon = IconManager.getIcon(IconManager.IconType.BIG_WARNING);
                    break;
                }
                icon = IconManager.getIcon(IconManager.IconType.WARNING_30);
                break;
            }
            case QUESTION: {
                if (useBigIcon) {
                    icon = IconManager.getIcon(IconManager.IconType.BIG_HELP);
                    break;
                }
                icon = IconManager.getIcon(IconManager.IconType.HELP_30);
                break;
            }
            case INFO: {
                if (useBigIcon) {
                    icon = IconManager.getIcon(IconManager.IconType.BIG_INFO);
                    break;
                }
                icon = IconManager.getIcon(IconManager.IconType.INFO_30);
                break;
            }
            case NO_ICON: {
                icon = null;
            }
        }
        JLabel leftImageLabel = new JLabel(icon);
        leftImageLabel.setBackground(Color.white);
        JPanel infoPanel = this.getInfoPanel();
        JPanel internalPanel = new JPanel(new GridBagLayout());
        internalPanel.setBackground(Color.white);
        internalPanel.setOpaque(true);
        internalPanel.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        internalPanel.add((Component)leftImageLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        internalPanel.add((Component)infoPanel, c);
        if (showAtStartKey != null) {
            this.m_showNextTimecheckBox = new JCheckBox("Do not show this dialog again at start");
            this.m_showNextTimecheckBox.setBackground(Color.white);
            Preferences preferences = NbPreferences.root();
            boolean selected = preferences.getBoolean(showAtStartKey, Boolean.FALSE);
            this.m_showNextTimecheckBox.setSelected(selected);
            c.weighty = 0.0;
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            internalPanel.add((Component)this.m_showNextTimecheckBox, c);
        }
        this.setInternalComponent(internalPanel);
    }

    private JPanel getInfoPanel() {
        JPanel infoPanel = new JPanel();
        infoPanel.setBackground(Color.white);
        infoPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        if (this.m_message != null) {
            c.gridwidth = 2;
            if (this.m_message.length() < 200 && !this.m_useArea) {
                String[] messageArray = this.m_message.split("\n");
                Font font = null;
                for (int i = 0; i < messageArray.length; ++i) {
                    JLabel messageLabel = new JLabel(messageArray[i]);
                    if (font == null) {
                        font = messageLabel.getFont().deriveFont(14).deriveFont(1);
                    }
                    messageLabel.setFont(font);
                    messageLabel.setBackground(Color.white);
                    infoPanel.add((Component)messageLabel, c);
                    ++c.gridy;
                }
            } else {
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.setResizable(true);
                JScrollPane scrollPane = new JScrollPane();
                JTextArea txtArea = new JTextArea(this.m_message);
                txtArea.setEditable(false);
                txtArea.setRows(20);
                txtArea.setColumns(50);
                txtArea.setLineWrap(true);
                scrollPane.setViewportView(txtArea);
                txtArea.setCaretPosition(0);
                infoPanel.add((Component)scrollPane, c);
                ++c.gridy;
                c.weightx = 0.0;
                c.weighty = 0.0;
            }
            c.gridwidth = 1;
        }
        return infoPanel;
    }

    @Override
    protected boolean okCalled() {
        if (this.m_showNextTimecheckBox != null) {
            Preferences preferences = NbPreferences.root();
            preferences.putBoolean(this.m_showAtStartKey, !this.m_showNextTimecheckBox.isSelected());
        }
        return true;
    }

    @Override
    protected boolean cancelCalled() {
        return true;
    }

    public static boolean showAtStart(String showAtStartKey) {
        Preferences preferences = NbPreferences.root();
        return preferences.getBoolean(showAtStartKey, Boolean.TRUE);
    }

    public static enum InfoType {
        WARNING,
        QUESTION,
        INFO,
        NO_ICON;

    }
}

