/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.performancetest;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.slf4j.Logger;

public class PerformanceTestData {
    private SpeedNode m_root;
    private SpeedNode m_currentNode;
    private Logger m_logger;
    private static Comparator m_comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return (int)(((SpeedNode)o2).m_totalTime - ((SpeedNode)o1).m_totalTime);
        }
    };

    public PerformanceTestData(Logger logger) {
        this.m_currentNode = this.m_root = new SpeedNode("", null);
        this.m_logger = logger;
    }

    public void startTime(String key, boolean global) {
        if (global) {
            SpeedNode node = this.m_root.getChild(key);
            node.setStartTime(System.currentTimeMillis());
        } else {
            this.m_currentNode = this.m_currentNode.getChild(key);
            this.m_currentNode.setStartTime(System.currentTimeMillis());
        }
    }

    public void stopTime(String key, boolean global) {
        if (global) {
            SpeedNode node = this.m_root.getChild(key);
            node.stop(System.currentTimeMillis());
        } else {
            SpeedNode currentNode = global ? this.m_root : this.m_currentNode;
            currentNode.stop(System.currentTimeMillis());
            if (!currentNode.m_key.equals(key)) {
                this.m_logger.debug(" PROBLEM : " + key);
            }
            this.m_currentNode = this.m_currentNode.m_parent;
        }
    }

    public void displayTime() {
        LinkedList<SpeedNode> sortedNodes = new LinkedList<SpeedNode>();
        this.m_root.getSortedNodes(sortedNodes);
        for (SpeedNode curNode : sortedNodes) {
            curNode.display();
        }
    }

    public void merge(PerformanceTestData testData) {
        this.merge(this.m_root, testData.m_root);
    }

    private void merge(SpeedNode node1, SpeedNode node2) {
        if (node2.m_children != null) {
            for (String childKey : node2.m_children.keySet()) {
                SpeedNode child1;
                SpeedNode child2 = node2.m_children.get(childKey);
                SpeedNode speedNode = child1 = node1.m_children != null ? node1.m_children.get(childKey) : null;
                if (child1 == null) {
                    child1 = new SpeedNode(childKey, node1);
                    child1.m_totalTime = child2.m_totalTime;
                    child1.m_callNumbers = child2.m_callNumbers;
                    child1.m_minTime = child2.m_minTime;
                    child1.m_maxTime = child2.m_maxTime;
                    node1.addChild(child1);
                } else {
                    child1.m_totalTime += child2.m_totalTime;
                    child1.m_callNumbers += child2.m_callNumbers;
                    if (child2.m_minTime < child1.m_minTime) {
                        child1.m_minTime = child2.m_minTime;
                    }
                    if (child2.m_maxTime > child1.m_maxTime) {
                        child1.m_maxTime = child2.m_maxTime;
                    }
                }
                this.merge(child1, child2);
            }
        }
    }

    public class SpeedNode {
        private String m_key;
        private String m_fullKey;
        private long m_startTime;
        private long m_callNumbers = 0L;
        private long m_minTime = Long.MAX_VALUE;
        private long m_maxTime = 0L;
        private long m_totalTime = 0L;
        private SpeedNode m_parent;
        private HashMap<String, SpeedNode> m_children = null;

        public SpeedNode(String key, SpeedNode parent) {
            this.m_key = key;
            this.m_parent = parent;
            this.m_fullKey = parent != null ? parent.getFullKey() + " - " + key : key;
        }

        public SpeedNode getChild(String key) {
            SpeedNode child = null;
            if (this.m_children == null) {
                this.m_children = new HashMap();
            } else {
                child = this.m_children.get(key);
            }
            if (child == null) {
                child = new SpeedNode(key, this);
                this.m_children.put(key, child);
            }
            return child;
        }

        public void addChild(SpeedNode child) {
            if (this.m_children == null) {
                this.m_children = new HashMap();
            }
            this.m_children.put(child.m_key, child);
        }

        public void setStartTime(long startTime) {
            this.m_startTime = startTime;
        }

        public void stop(long stopTime) {
            ++this.m_callNumbers;
            long delay = stopTime - this.m_startTime;
            if (delay < this.m_minTime) {
                this.m_minTime = delay;
            }
            if (delay > this.m_maxTime) {
                this.m_maxTime = delay;
            }
            this.m_totalTime += delay;
        }

        public void getSortedNodes(LinkedList<SpeedNode> list) {
            if (this.m_children != null) {
                LinkedList<SpeedNode> childrenList = new LinkedList<SpeedNode>();
                childrenList.addAll(this.m_children.values());
                Collections.sort(childrenList, m_comparator);
                for (SpeedNode curNode : childrenList) {
                    list.add(curNode);
                    curNode.getSortedNodes(list);
                }
            }
        }

        public String getFullKey() {
            return this.m_fullKey;
        }

        public void display() {
            try {
                PerformanceTestData.this.m_logger.debug(this.m_fullKey + " Total:" + this.m_totalTime + "ms   **** NbCalls:" + this.m_callNumbers + "  Average:" + this.m_totalTime / this.m_callNumbers + "ms  Min:" + this.m_minTime + "ms  Max:" + this.m_maxTime + "ms");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

