/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.table.AbstractTableAction;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TablePopupMenu
extends JPopupMenu {
    private final ArrayList<AbstractTableAction> m_actions = new ArrayList();
    private int m_row;
    private int m_col;
    private int[] m_selectedRows;
    private JTable m_table;

    public TablePopupMenu(boolean setDefaultActions) {
        if (setDefaultActions) {
            this.addAction(new CopyCellAction());
            this.addAction(new SelectAllAction());
            this.addAction(null);
        }
    }

    public TablePopupMenu() {
        this(true);
    }

    public final void addAction(AbstractTableAction action) {
        this.m_actions.add(action);
        if (action != null) {
            action.setTablePopupMenu(this);
        }
    }

    public int getRow() {
        return this.m_row;
    }

    public int getCol() {
        return this.m_col;
    }

    public int[] getSelectedRows() {
        return this.m_selectedRows;
    }

    public JTable getTable() {
        return this.m_table;
    }

    public void preparePopup() {
        this.removeAll();
        int nbActions = this.m_actions.size();
        for (int i = 0; i < nbActions; ++i) {
            AbstractTableAction action = this.m_actions.get(i);
            if (action == null) {
                this.addSeparator();
                continue;
            }
            this.add(action.getPopupPresenter());
        }
    }

    public void show(int mouseX, int mouseY, JTable table) {
        Point mousePoint = new Point(mouseX, mouseY);
        this.m_table = table;
        this.m_selectedRows = table.getSelectedRows();
        this.m_row = table.rowAtPoint(mousePoint);
        this.m_col = table.columnAtPoint(mousePoint);
        int nbActions = this.m_actions.size();
        for (int i = 0; i < nbActions; ++i) {
            AbstractTableAction action = this.m_actions.get(i);
            if (action == null) continue;
            action.updateEnabled(this.m_row, this.m_col, this.m_selectedRows, table);
        }
        this.show(table, mouseX, mouseY);
    }

    public static class CopyCellAction
    extends AbstractTableAction {
        public CopyCellAction() {
            super("Copy cell");
        }

        @Override
        public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
            TableCellRenderer renderer = table.getCellRenderer(row, col);
            Component c = table.prepareRenderer(renderer, row, col);
            String text = this.componentToText(c);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(text), null);
        }

        @Override
        public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
            this.setEnabled(row != -1);
        }

        private String componentToText(Component c) {
            if (c instanceof JLabel) {
                return ((JLabel)c).getText();
            }
            if (c instanceof AbstractButton) {
                return ((AbstractButton)c).getText();
            }
            return "";
        }
    }

    public static class SelectAllAction
    extends AbstractTableAction {
        public SelectAllAction() {
            super("Select All");
        }

        @Override
        public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
            table.selectAll();
        }

        @Override
        public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
            this.setEnabled(true);
        }
    }
}

