/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model.params;

import fr.profi.mzdb.db.model.params.AbstractXMLParamTree;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;

@XmlRootElement(name="precursorList")
public class PrecursorList
extends AbstractXMLParamTree {
    @XmlAttribute(required=true)
    @XmlSchemaType(name="nonNegativeInteger")
    protected int count;
    @XmlElement(name="precursor")
    protected List<Precursor> precursors;

    public PrecursorList() {
    }

    public PrecursorList(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public PrecursorList(int c) {
        this.count = c;
    }

    public List<Precursor> getPrecursors() {
        return this.precursors;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt32(this.count);
        boolean hasData = this.precursors != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeInt32(this.precursors.size());
            for (SerializationInterface serializationInterface : this.precursors) {
                serializationInterface.write(writer);
            }
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        super.read(reader);
        this.count = reader.readInt32();
        boolean hasData = reader.readBoolean();
        if (hasData) {
            int size = reader.readInt32();
            this.precursors = new ArrayList<Precursor>(size);
            for (int i = 0; i < size; ++i) {
                Precursor element = new Precursor(reader);
                this.precursors.add(element);
            }
        } else {
            this.precursors = null;
        }
    }
}

