/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;

public class Spectrum
implements SerializationInterface {
    protected SpectrumHeader header;
    protected SpectrumData spectrumData;

    public Spectrum(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public Spectrum(SpectrumHeader header, SpectrumData spectrumData) {
        this.header = header;
        this.spectrumData = spectrumData;
    }

    public SpectrumHeader getHeader() {
        return this.header;
    }

    public SpectrumData getData() {
        return this.spectrumData;
    }

    public Peak[] toPeaks() {
        return this.spectrumData.toPeaks(this.header);
    }

    public Peak getNearestPeak(double mz, double mzTolPPM) {
        return this.spectrumData.getNearestPeak(mz, mzTolPPM, this.header);
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        this.header.write(writer);
        this.spectrumData.write(writer);
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        this.header = new SpectrumHeader(reader);
        this.spectrumData = new SpectrumData(reader);
    }
}

