/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EnginePreparedStatement;

public class BrokeredPreparedStatement
extends BrokeredStatement
implements EnginePreparedStatement {
    final String sql;
    private final Object generatedKeys;

    public BrokeredPreparedStatement(BrokeredStatementControl brokeredStatementControl, String string, Object object) throws SQLException {
        super(brokeredStatementControl);
        this.sql = string;
        this.generatedKeys = object;
    }

    public final ResultSet executeQuery() throws SQLException {
        return this.wrapResultSet(this.getPreparedStatement().executeQuery());
    }

    public final int executeUpdate() throws SQLException {
        return this.getPreparedStatement().executeUpdate();
    }

    public void close() throws SQLException {
        this.control.closeRealPreparedStatement();
    }

    public final void setNull(int n, int n2) throws SQLException {
        this.getPreparedStatement().setNull(n, n2);
    }

    public final void setNull(int n, int n2, String string) throws SQLException {
        this.getPreparedStatement().setNull(n, n2, string);
    }

    public final void setBoolean(int n, boolean bl) throws SQLException {
        this.getPreparedStatement().setBoolean(n, bl);
    }

    public final void setByte(int n, byte by) throws SQLException {
        this.getPreparedStatement().setByte(n, by);
    }

    public final void setShort(int n, short s) throws SQLException {
        this.getPreparedStatement().setShort(n, s);
    }

    public final void setInt(int n, int n2) throws SQLException {
        this.getPreparedStatement().setInt(n, n2);
    }

    public final void setLong(int n, long l) throws SQLException {
        this.getPreparedStatement().setLong(n, l);
    }

    public final void setFloat(int n, float f) throws SQLException {
        this.getPreparedStatement().setFloat(n, f);
    }

    public final void setDouble(int n, double d) throws SQLException {
        this.getPreparedStatement().setDouble(n, d);
    }

    public final void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.getPreparedStatement().setBigDecimal(n, bigDecimal);
    }

    public final void setString(int n, String string) throws SQLException {
        this.getPreparedStatement().setString(n, string);
    }

    public final void setBytes(int n, byte[] byArray) throws SQLException {
        this.getPreparedStatement().setBytes(n, byArray);
    }

    public final void setDate(int n, Date date) throws SQLException {
        this.getPreparedStatement().setDate(n, date);
    }

    public final void setTime(int n, Time time) throws SQLException {
        this.getPreparedStatement().setTime(n, time);
    }

    public final void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.getPreparedStatement().setTimestamp(n, timestamp);
    }

    public final void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.getPreparedStatement().setAsciiStream(n, inputStream, n2);
    }

    public final void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.getPreparedStatement().setUnicodeStream(n, inputStream, n2);
    }

    public final void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.getPreparedStatement().setBinaryStream(n, inputStream, n2);
    }

    public final void addBatch() throws SQLException {
        this.getPreparedStatement().addBatch();
    }

    public final void clearParameters() throws SQLException {
        this.getPreparedStatement().clearParameters();
    }

    public final ResultSetMetaData getMetaData() throws SQLException {
        return this.getPreparedStatement().getMetaData();
    }

    public final void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.getPreparedStatement().setObject(n, object, n2, n3);
    }

    public final void setObject(int n, Object object, int n2) throws SQLException {
        this.getPreparedStatement().setObject(n, object, n2);
    }

    public final void setObject(int n, Object object) throws SQLException {
        this.getPreparedStatement().setObject(n, object);
    }

    public final boolean execute() throws SQLException {
        return this.getPreparedStatement().execute();
    }

    public final void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.getPreparedStatement().setCharacterStream(n, reader, n2);
    }

    public final void setRef(int n, Ref ref) throws SQLException {
        this.getPreparedStatement().setRef(n, ref);
    }

    public final void setBlob(int n, Blob blob) throws SQLException {
        this.getPreparedStatement().setBlob(n, blob);
    }

    public final void setClob(int n, Clob clob) throws SQLException {
        this.getPreparedStatement().setClob(n, clob);
    }

    public final void setArray(int n, Array array) throws SQLException {
        this.getPreparedStatement().setArray(n, array);
    }

    public final void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.getPreparedStatement().setDate(n, date, calendar);
    }

    public final void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.getPreparedStatement().setTime(n, time, calendar);
    }

    public final void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.getPreparedStatement().setTimestamp(n, timestamp, calendar);
    }

    public long executeLargeUpdate() throws SQLException {
        EnginePreparedStatement enginePreparedStatement = (EnginePreparedStatement)this.getPreparedStatement();
        return enginePreparedStatement.executeLargeUpdate();
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        EnginePreparedStatement enginePreparedStatement = (EnginePreparedStatement)this.getPreparedStatement();
        enginePreparedStatement.setBinaryStream(n, inputStream);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        EnginePreparedStatement enginePreparedStatement = (EnginePreparedStatement)this.getPreparedStatement();
        enginePreparedStatement.setCharacterStream(n, reader);
    }

    public final void setURL(int n, URL uRL) throws SQLException {
        this.getPreparedStatement().setURL(n, uRL);
    }

    public final ParameterMetaData getParameterMetaData() throws SQLException {
        return this.getPreparedStatement().getParameterMetaData();
    }

    PreparedStatement getPreparedStatement() throws SQLException {
        return this.control.getRealPreparedStatement();
    }

    public final Statement getStatement() throws SQLException {
        return this.getPreparedStatement();
    }

    public PreparedStatement createDuplicateStatement(Connection connection, PreparedStatement preparedStatement) throws SQLException {
        PreparedStatement preparedStatement2 = this.generatedKeys == null ? connection.prepareStatement(this.sql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability) : (this.generatedKeys instanceof Integer ? connection.prepareStatement(this.sql, (Integer)this.generatedKeys) : (this.generatedKeys instanceof int[] ? connection.prepareStatement(this.sql, (int[])this.generatedKeys) : connection.prepareStatement(this.sql, (String[])this.generatedKeys)));
        this.setStatementState(preparedStatement, preparedStatement2);
        return preparedStatement2;
    }

    public final long getVersionCounter() throws SQLException {
        return ((EnginePreparedStatement)this.getPreparedStatement()).getVersionCounter();
    }
}

