/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife;

import Preprocessing.Config;
import Preprocessing.DeltaMassDB;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.mgf.MGFECleaner;
import fr.profi.mzknife.mgf.MGFFilter;
import fr.profi.mzknife.mgf.MGFMerger;
import fr.profi.mzknife.mgf.MGFMetrics;
import fr.profi.mzknife.mgf.MGFRecalibrator;
import fr.profi.mzknife.mgf.MGFRewriter;
import fr.profi.mzknife.mgf.PCleanProcessor;
import fr.profi.mzknife.util.AbstractProcessing;
import fr.profi.mzscope.InvalidMGFFormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGFProcessing
extends AbstractProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(MGFProcessing.class);

    public static void main(String[] args) {
        CommandArguments.MgfRecalibrateCommand mgfRecalibrateCommand = new CommandArguments.MgfRecalibrateCommand();
        CommandArguments.MgfFilterCommand mgfFilterCommand = new CommandArguments.MgfFilterCommand();
        CommandArguments.MgfCleanerCommand mgfCleanerCommand = new CommandArguments.MgfCleanerCommand();
        CommandArguments.MgfMergerCommand mgfMergerCommand = new CommandArguments.MgfMergerCommand();
        CommandArguments.PCleanCommand pCleanCommand = new CommandArguments.PCleanCommand();
        CommandArguments.MgfMetricsCommand mgfMetricsCommand = new CommandArguments.MgfMetricsCommand();
        MGFProcessing.addCommand(mgfRecalibrateCommand);
        MGFProcessing.addCommand(mgfFilterCommand);
        MGFProcessing.addCommand(mgfCleanerCommand);
        MGFProcessing.addCommand(mgfMergerCommand);
        MGFProcessing.addCommand(pCleanCommand);
        MGFProcessing.addCommand(mgfMetricsCommand);
        try {
            String parsedCmd;
            switch (parsedCmd = MGFProcessing.parseCommand(args)) {
                case "recalibrate": {
                    if (mgfRecalibrateCommand.help) {
                        MGFProcessing.usage();
                    }
                    MGFProcessing.recalibrateMgf(mgfRecalibrateCommand);
                    break;
                }
                case "filter": {
                    if (mgfFilterCommand.help) {
                        MGFProcessing.usage();
                    }
                    MGFProcessing.filterMgf(mgfFilterCommand);
                    break;
                }
                case "eclean": {
                    if (mgfCleanerCommand.help) {
                        MGFProcessing.usage();
                    }
                    MGFProcessing.cleanMgf(mgfCleanerCommand);
                    break;
                }
                case "merge": {
                    if (mgfMergerCommand.help) {
                        MGFProcessing.usage();
                    }
                    MGFProcessing.mergeMgf(mgfMergerCommand);
                    break;
                }
                case "pclean": {
                    if (pCleanCommand.help) {
                        MGFProcessing.usage();
                    }
                    MGFProcessing.pCleanMgf(pCleanCommand);
                    break;
                }
                case "metrics": {
                    if (mgfMetricsCommand.help) {
                        MGFProcessing.usage();
                    }
                    MGFProcessing.computeMgfMetrics(mgfMetricsCommand);
                    break;
                }
                default: {
                    LOG.warn("Invalid command specified ");
                    MGFProcessing.usage();
                    break;
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("File not found", (Throwable)fnfe);
        }
        catch (InvalidMGFFormatException imfe) {
            LOG.error("Invalid MGF file format", (Throwable)imfe);
        }
        catch (Exception e) {
            LOG.error("ERROR ", (Throwable)e);
        }
    }

    public static void pCleanMgf(CommandArguments.PCleanCommand pCleanCommand) throws InvalidMGFFormatException, IOException {
        File mgfPCleanSrcFile = new File(pCleanCommand.mgf);
        File mgfPCleanDstFile = MGFProcessing.getDestFile(pCleanCommand.outputFileName, ".pclean.mgf", mgfPCleanSrcFile);
        PCleanProcessor pCleanProcessor = new PCleanProcessor(mgfPCleanSrcFile, mgfPCleanDstFile, pCleanCommand.labelMethod);
        pCleanProcessor.setPCleanParameters(pCleanCommand.ionFilter, pCleanCommand.repFilter, pCleanCommand.labelFilter, pCleanCommand.low, pCleanCommand.high, pCleanCommand.isoReduction, pCleanCommand.chargeDeconv, pCleanCommand.ionsMerge, pCleanCommand.largerThanPrecursor);
        DeltaMassDB.consider2aa = pCleanCommand.aa2;
        Config.ms2tol = pCleanCommand.itol;
        pCleanProcessor.rewriteMGF();
    }

    public static void mergeMgf(CommandArguments.MgfMergerCommand mgfMergerCommand) throws InvalidMGFFormatException, IOException {
        File mgfMergerSrcFile = new File(mgfMergerCommand.inputFileName1);
        File mgfMergerFragmentsFile = new File(mgfMergerCommand.inputFileName2);
        File mgfMergerDstFile = MGFProcessing.getDestFile(mgfMergerCommand.outputFileName, ".merge.mgf", mgfMergerSrcFile);
        MGFMerger mgfMerger = new MGFMerger(mgfMergerSrcFile, mgfMergerFragmentsFile, mgfMergerDstFile);
        mgfMerger.setFilterSpectrum(mgfMergerCommand.filter);
        mgfMerger.setReplaceFragments(mgfMergerCommand.replace);
        mgfMerger.rewriteMGF();
        mgfMerger.dumpMetric();
    }

    public static void cleanMgf(CommandArguments.MgfCleanerCommand mgfCleanerCommand) throws InvalidMGFFormatException, IOException {
        File mgfCleanerSrcFile = new File(mgfCleanerCommand.inputFileName);
        File mgfCleanerDstFile = MGFProcessing.getDestFile(mgfCleanerCommand.outputFileName, ".clean.mgf", mgfCleanerSrcFile);
        MGFRewriter mgfCleaner = null;
        if (mgfCleanerCommand.labelingMethodName != null) {
            try {
                MGFECleaner.IsobaricTag isobaricTag = MGFECleaner.IsobaricTag.valueOf(mgfCleanerCommand.labelingMethodName.toUpperCase());
                mgfCleaner = new MGFECleaner(mgfCleanerSrcFile, mgfCleanerDstFile, mgfCleanerCommand.mzTolPPM.floatValue(), isobaricTag);
            }
            catch (IllegalArgumentException iae) {
                LOG.error("labelling method {} not found");
                MGFProcessing.usage();
            }
        } else {
            mgfCleaner = new MGFECleaner(mgfCleanerSrcFile, mgfCleanerDstFile, mgfCleanerCommand.mzTolPPM.floatValue());
        }
        mgfCleaner.rewriteMGF();
    }

    public static void computeMgfMetrics(CommandArguments.MgfMetricsCommand mgfMetricsCommand) throws InvalidMGFFormatException, IOException {
        File srcFile = new File(mgfMetricsCommand.inputFileName);
        File destFile = MGFProcessing.getDestFile(mgfMetricsCommand.outputFileName, ".metrics.tsv", srcFile);
        MGFMetrics mgfMetrics = new MGFMetrics(srcFile, destFile);
        mgfMetrics.dumpMGFMetrics();
    }

    public static void recalibrateMgf(CommandArguments.MgfRecalibrateCommand mgfRecalibrateCommand) throws InvalidMGFFormatException, IOException {
        File mgfRecalSrcFile = new File(mgfRecalibrateCommand.inputFileName);
        File mgfRecalDstFile = MGFProcessing.getDestFile(mgfRecalibrateCommand.outputFileName, ".recal.mgf", mgfRecalSrcFile);
        MGFRecalibrator mgfRecalibrator = new MGFRecalibrator(mgfRecalSrcFile, mgfRecalDstFile, mgfRecalibrateCommand.firstTime, mgfRecalibrateCommand.lastTime, mgfRecalibrateCommand.deltaMass);
        mgfRecalibrator.rewriteMGF();
    }

    public static void filterMgf(CommandArguments.MgfFilterCommand mgfFilterCommand) throws InvalidMGFFormatException, IOException {
        File mgfFilterSrcFile = new File(mgfFilterCommand.inputFileName);
        File mgfFilterDstFile = MGFProcessing.getDestFile(mgfFilterCommand.outputFileName, ".filter.mgf", mgfFilterSrcFile);
        List<Integer> charges2Ignore = mgfFilterCommand.charges2Ignore;
        List<Integer> charges2Keep = mgfFilterCommand.charges2Keep;
        if (charges2Ignore != null && !charges2Ignore.isEmpty() && charges2Keep != null && !charges2Keep.isEmpty() || (charges2Ignore == null || charges2Ignore.isEmpty()) && charges2Keep == null && charges2Keep.isEmpty()) {
            LOG.info("One, and only one, of the 2 parameters, --charges and --exclude-charges, should be specified!! ");
            System.exit(1);
        }
        MGFFilter filter = new MGFFilter(mgfFilterSrcFile, mgfFilterDstFile);
        if (charges2Ignore != null) {
            filter.setExcludeCharges(charges2Ignore);
        } else {
            filter.setCharges(charges2Keep);
        }
        filter.rewriteMGF();
    }
}

