/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.mzdb;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.model.params.IsolationWindowParamTree;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.db.model.params.ScanParamTree;
import fr.profi.mzdb.db.model.params.param.CVEntry;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.param.UserParam;
import fr.profi.mzdb.io.writer.mgf.MgfBoostPrecursorExtractor;
import fr.profi.mzdb.model.IonMobilityMode;
import fr.profi.mzdb.model.IonMobilityType;
import fr.profi.mzdb.model.IsolationWindow;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzDBMetrics {
    private static final CharSequence DELIMITER = "\t";
    final File m_inputMzdbFile;
    final File m_outputFile;
    MzDbReader m_mzDbReader;
    private static final Logger LOG = LoggerFactory.getLogger(MzDBMetrics.class);

    public MzDBMetrics(File inputMzdbFile, File outputFile) {
        this.m_inputMzdbFile = inputMzdbFile;
        this.m_outputFile = outputFile;
        this.initReader();
    }

    private void initReader() {
        try {
            this.m_mzDbReader = new MzDbReader(this.m_inputMzdbFile, true);
            this.m_mzDbReader.enableScanListLoading();
            this.m_mzDbReader.enableParamTreeLoading();
            this.m_mzDbReader.enablePrecursorListLoading();
            this.m_mzDbReader.enableDataStringCache();
        }
        catch (SQLiteException | FileNotFoundException e) {
            e.printStackTrace();
            if (this.m_mzDbReader != null) {
                this.m_mzDbReader.close();
            }
            throw new IllegalArgumentException("Unable to read specified mzDbFile");
        }
    }

    public void computeMetrics() {
        LOG.info(" Compute mzDB metrics " + this.m_inputMzdbFile.getName());
        try {
            SpectrumHeader[] ms2SpectrumHeaders;
            if (!this.m_mzDbReader.getConnection().isOpen()) {
                this.initReader();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_outputFile));
            String[] columns = new String[]{"scan.id", "scan.rt", "master_scan.id", "master_scan.rt", "master_scan.peaks_count", "samecycle_scan.id", "samecycle_scan.rt", "samecycle_scan.peaks_count", "nearest_scan.id", "nearest_scan.rt", "nearest_scan.peaks_count"};
            writer.write(Arrays.stream(columns).collect(Collectors.joining(DELIMITER)));
            writer.newLine();
            for (SpectrumHeader spHeader : ms2SpectrumHeaders = this.m_mzDbReader.getMs2SpectrumHeaders()) {
                IsolationWindow iw = this.retrieveIsolationWindow(spHeader);
                List<Optional<SpectrumSlice>> ms1DataList = this.retrieveMS1Data(spHeader, iw);
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append(spHeader.getSpectrumId()).append(DELIMITER);
                strBuilder.append(spHeader.getElutionTime()).append(DELIMITER);
                for (Optional<SpectrumSlice> spectrumSlice : ms1DataList) {
                    if (spectrumSlice.isPresent()) {
                        strBuilder.append(spectrumSlice.get().getSpectrumId()).append(DELIMITER);
                        strBuilder.append(spectrumSlice.get().getHeader().getElutionTime()).append(DELIMITER);
                        strBuilder.append(this.countSWPeaks(spectrumSlice.get(), iw)).append(DELIMITER);
                        continue;
                    }
                    strBuilder.append("NA").append(DELIMITER);
                    strBuilder.append("NA").append(DELIMITER);
                    strBuilder.append("NA").append(DELIMITER);
                }
                writer.write(strBuilder.toString());
                writer.newLine();
                writer.flush();
            }
        }
        catch (SQLiteException | IOException e) {
            e.printStackTrace();
            this.m_mzDbReader.close();
        }
    }

    private IsolationWindow retrieveIsolationWindow(SpectrumHeader spectrumHeader) {
        Precursor precursor = spectrumHeader.getPrecursor();
        IsolationWindowParamTree iw = precursor.getIsolationWindow();
        if (iw == null) {
            return null;
        }
        CVEntry[] cvEntries = new CVEntry[]{CVEntry.ISOLATION_WINDOW_LOWER_OFFSET, CVEntry.ISOLATION_WINDOW_TARGET_MZ, CVEntry.ISOLATION_WINDOW_UPPER_OFFSET};
        CVParam[] cvParams = iw.getCVParams(cvEntries);
        float lowerMzOffset = Float.parseFloat(cvParams[0].getValue());
        float targetMz = Float.parseFloat(cvParams[1].getValue());
        float upperMzOffset = Float.parseFloat(cvParams[2].getValue());
        float minmz = targetMz - lowerMzOffset;
        float maxmz = targetMz + upperMzOffset;
        return new IsolationWindow((double)minmz, (double)maxmz);
    }

    private List<Optional<SpectrumSlice>> retrieveMS1Data(SpectrumHeader spectrumHeader, IsolationWindow isolationWindow) throws StreamCorruptedException, SQLiteException {
        int masterScanIndex;
        float time = spectrumHeader.getElutionTime();
        double minmz = isolationWindow.getMinMz();
        double maxmz = isolationWindow.getMaxMz();
        float minrt = time - 5.0f;
        float maxrt = time + 5.0f;
        UserParam masterScanUP = ((ScanParamTree)spectrumHeader.getScanList().getScans().get(0)).getUserParam("[Thermo Trailer Extra]Master Scan Number:");
        Optional<Object> masterScanOpt = Optional.empty();
        if (masterScanUP != null && (masterScanIndex = Integer.parseInt(masterScanUP.getValue())) >= 0) {
            Spectrum masterScan = this.m_mzDbReader.getSpectrum((long)masterScanIndex);
            masterScanOpt = Optional.of(new SpectrumSlice(masterScan.getHeader(), masterScan.getData().mzRangeFilter(minmz - 5.0, maxmz + 5.0)));
        }
        SpectrumSlice[] spectrumSlices = this.m_mzDbReader.getMsSpectrumSlices(minmz - 5.0, maxmz + 5.0, minrt, maxrt);
        IonMobilityMode ionMobilityMode = this.m_mzDbReader.getIonMobilityMode();
        boolean hasIonMobility = ionMobilityMode != null && ionMobilityMode.getIonMobilityType().equals((Object)IonMobilityType.FAIMS);
        String cv = hasIonMobility ? (String)MgfBoostPrecursorExtractor.readIonMobilityCV((SpectrumHeader)spectrumHeader).get() : null;
        Optional<SpectrumSlice> sameCycleScanOpt = Arrays.stream(spectrumSlices).filter(s -> s.getHeader().getCycle() == spectrumHeader.getCycle() && (!hasIonMobility || cv == MgfBoostPrecursorExtractor.readIonMobilityCV((SpectrumHeader)s.getHeader()).get())).findFirst();
        Stream<SpectrumSlice> spectrumSliceStream = Arrays.stream(spectrumSlices).filter(s -> !hasIonMobility || cv == MgfBoostPrecursorExtractor.readIonMobilityCV((SpectrumHeader)s.getHeader()).get());
        Optional<SpectrumSlice> nearestScanOpt = spectrumSliceStream.min((o1, o2) -> Double.compare(Math.abs(o1.getHeader().getElutionTime() - time), Math.abs(o2.getHeader().getElutionTime() - time)));
        return Arrays.asList(masterScanOpt, sameCycleScanOpt, nearestScanOpt);
    }

    private long countSWPeaks(SpectrumSlice spectrum, IsolationWindow iw) {
        return Arrays.stream(spectrum.toPeaks()).filter(p -> p.getMz() >= iw.getMinMz() && p.getMz() <= iw.getMaxMz()).count();
    }
}

