/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.mzdb;

import fr.profi.mzdb.BBSizes;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.io.util.MzDBUtil;
import fr.profi.mzdb.io.writer.MzDBWriter;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.MzDBMetaData;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumMetaData;
import fr.profi.mzknife.util.RecalibrateUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzDBRecalibrator {
    private static final Logger LOG = LoggerFactory.getLogger(MzDBRecalibrator.class);
    private final MzDbReader m_srcReader;
    private final File m_dstFile;

    public MzDBRecalibrator(MzDbReader srcReader, File dstFile) {
        this.m_dstFile = dstFile;
        this.m_srcReader = srcReader;
        this.m_srcReader.enableParamTreeLoading();
        this.m_srcReader.enablePrecursorListLoading();
        this.m_srcReader.enableScanListLoading();
        this.m_srcReader.enableDataStringCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalibrate(Long firstScan, Long lastScan, double deltaMass) {
        MzDBWriter writer = null;
        try {
            BBSizes defaultBBsize = new BBSizes(5.0, 10000.0, 15.0f, 0.0f);
            MzDBMetaData mzDbMetaData = MzDBUtil.createMzDbMetaData((MzDbReader)this.m_srcReader);
            AcquisitionMode srcAcqMode = this.m_srcReader.getAcquisitionMode();
            boolean isDIA = srcAcqMode != null && srcAcqMode.equals((Object)AcquisitionMode.SWATH);
            writer = new MzDBWriter(this.m_dstFile, false, mzDbMetaData, defaultBBsize, Boolean.valueOf(isDIA));
            writer.initialize();
            SpectrumHeader[] headers = this.m_srcReader.getSpectrumHeaders();
            Arrays.sort(headers, Comparator.comparingLong(SpectrumHeader::getSpectrumId));
            int recalibratedScanCount = 0;
            for (SpectrumHeader srcSpectrumHeader : headers) {
                Spectrum srcSpectrum = this.m_srcReader.getSpectrum(srcSpectrumHeader.getSpectrumId());
                SpectrumData srcSpectrumData = srcSpectrum.getData();
                double[] mzValues = null;
                if (srcSpectrumHeader.getSpectrumId() >= firstScan && srcSpectrumHeader.getSpectrumId() <= lastScan) {
                    ++recalibratedScanCount;
                    mzValues = RecalibrateUtil.recalibrateMasses(srcSpectrumData.getMzList(), deltaMass);
                    LOG.info(" Recalibrate spectrum {] at RT {} ", (Object)srcSpectrumHeader.getId(), (Object)Float.valueOf(srcSpectrumHeader.getTime()));
                } else {
                    mzValues = srcSpectrumData.getMzList();
                }
                SpectrumData spData = new SpectrumData(mzValues, srcSpectrumData.getIntensityList(), srcSpectrumData.getLeftHwhmList(), srcSpectrumData.getRightHwhmList());
                Spectrum mzdb4sSp = new Spectrum(srcSpectrumHeader, spData);
                SpectrumMetaData spectrumMetaData = new SpectrumMetaData(Long.valueOf(srcSpectrumHeader.getSpectrumId()), srcSpectrumHeader.getParamTreeAsString(this.m_srcReader.getConnection()), srcSpectrumHeader.getScanListAsString(this.m_srcReader.getConnection()), srcSpectrumHeader.getPrecursorListAsString(this.m_srcReader.getConnection()));
                writer.insertSpectrum(mzdb4sSp, spectrumMetaData, this.m_srcReader.getSpectrumDataEncoding(srcSpectrumHeader.getSpectrumId()));
                if (srcSpectrumHeader.getSpectrumId() % 5000L != 0L && srcSpectrumHeader.getSpectrumId() != (long)this.m_srcReader.getSpectraCount()) continue;
                LOG.info("Write {} spectra over {} ({} already recalibrated)", new Object[]{srcSpectrumHeader.getSpectrumId(), this.m_srcReader.getSpectraCount(), recalibratedScanCount});
            }
            LOG.info("{} spectrum recalibrated", (Object)recalibratedScanCount);
        }
        catch (Exception e) {
            LOG.error("Exception in Spectrum iterator ", (Throwable)e);
            e.printStackTrace();
        }
        catch (Throwable t) {
            LOG.error("Throwable in Spectrum iterator ", t);
            t.printStackTrace();
        }
        finally {
            LOG.debug("Finally   writer close ");
            writer.close();
        }
    }
}

