/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.lines;

import java.util.HashMap;
import jwave.datatypes.Super;
import jwave.datatypes.lines.Line;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailureNotFound;

public class LineHash
extends Line {
    HashMap<Integer, Double> _hashMap;

    public LineHash() {
    }

    public LineHash(Line line) {
        super(line);
        try {
            this.alloc();
            for (int i = 0; i < line._noOfRows; ++i) {
                this.set(i, line.get(i));
            }
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
    }

    public LineHash(int noOfRows) {
        super(noOfRows);
    }

    public LineHash(int offSetRow, int noOfRows) {
        super(offSetRow, noOfRows);
    }

    @Override
    public Line copy() {
        int offSetRow = this.getOffSetRow();
        int noOfRows = this.getNoOfRows();
        LineHash line = new LineHash(offSetRow, noOfRows);
        try {
            if (this.isAllocated()) {
                ((Super)line).alloc();
                for (int i = 0; i < noOfRows; ++i) {
                    try {
                        ((Line)line).set(i, this.get(i));
                        continue;
                    }
                    catch (JWaveFailureNotFound jWaveFailureNotFound) {
                        continue;
                    }
                    catch (JWaveException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
        return line;
    }

    @Override
    public boolean isAllocated() {
        boolean isAllocated = true;
        if (this._hashMap == null) {
            isAllocated = false;
        }
        return isAllocated;
    }

    @Override
    public void alloc() throws JWaveException {
        if (!this.isAllocated()) {
            this._hashMap = new HashMap();
        }
    }

    @Override
    public void erase() throws JWaveException {
        this._hashMap = null;
    }

    @Override
    public double get(int i) throws JWaveException {
        this.checkMemory();
        this.checkIndex(i);
        double value = 0.0;
        if (!this._hashMap.containsKey(i)) {
            throw new JWaveFailureNotFound("Line - no value stored for requested i: " + i);
        }
        value = this._hashMap.get(i);
        return value;
    }

    @Override
    public void set(int i, double value) throws JWaveException {
        this.checkMemory();
        this.checkIndex(i);
        this._hashMap.put(i, value);
    }
}

