/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util;

import java.util.Objects;

public class Interval1D<V extends Comparable<V>>
implements Comparable<Interval1D<V>> {
    public final V lo;
    public final V hi;
    private int hashCode;

    public Interval1D(V left, V right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Illegal interval: nulls not allowed");
        }
        if (left.compareTo(right) > 0) {
            throw new IllegalArgumentException("Illegal interval: left < right");
        }
        this.lo = left;
        this.hi = right;
    }

    public static void main(String[] args) {
        Interval1D<Integer> a = new Interval1D<Integer>(15, 20);
        Interval1D<Integer> b = new Interval1D<Integer>(25, 30);
        Interval1D<Integer> c = new Interval1D<Integer>(10, 40);
        Interval1D<Integer> d = new Interval1D<Integer>(40, 50);
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("c = " + c);
        System.out.println("d = " + d);
        System.out.println("b intersects a = " + b.intersects(a));
        System.out.println("a intersects b = " + a.intersects(b));
        System.out.println("a intersects c = " + a.intersects(c));
        System.out.println("a intersects d = " + a.intersects(d));
        System.out.println("b intersects c = " + b.intersects(c));
        System.out.println("b intersects d = " + b.intersects(d));
        System.out.println("c intersects d = " + c.intersects(d));
    }

    public boolean intersects(Interval1D<V> other) {
        if (other.hi.compareTo(this.lo) < 0) {
            return false;
        }
        return this.hi.compareTo(other.lo) >= 0;
    }

    public boolean contains(V x) {
        return this.lo.compareTo(x) <= 0 && x.compareTo(this.hi) <= 0;
    }

    @Override
    public int compareTo(Interval1D<V> other) {
        if (this.lo.compareTo(other.lo) < 0) {
            return -1;
        }
        if (this.lo.compareTo(other.lo) > 0) {
            return 1;
        }
        if (this.hi.compareTo(other.hi) < 0) {
            return -1;
        }
        if (this.hi.compareTo(other.hi) > 0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[" + this.lo + ", " + this.hi + "]";
    }

    public V getLo() {
        return this.lo;
    }

    public V getHi() {
        return this.hi;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 7;
            hash = 41 * hash + Objects.hashCode(this.lo);
            this.hashCode = hash = 41 * hash + Objects.hashCode(this.hi);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval1D other = (Interval1D)obj;
        if (!Objects.equals(this.lo, other.lo)) {
            return false;
        }
        return Objects.equals(this.hi, other.hi);
    }
}

