/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.AbstractContext;
import javolution.lang.Configurable;
import javolution.osgi.internal.OSGiServices;

public abstract class LogContext
extends AbstractContext {
    public static final Configurable<Level> LEVEL = new Configurable<Level>(){

        @Override
        protected Level getDefault() {
            return Level.INFO;
        }

        @Override
        public Level parse(String str) {
            return Level.valueOf(str);
        }
    };

    public static void debug(Object ... message) {
        LogContext.currentLogContext().log(Level.DEBUG, message);
    }

    public static LogContext enter() {
        return (LogContext)LogContext.currentLogContext().enterInner();
    }

    public static void error(Object ... message) {
        LogContext.currentLogContext().log(Level.ERROR, message);
    }

    public static void info(Object ... message) {
        LogContext.currentLogContext().log(Level.INFO, message);
    }

    public static void warning(Object ... message) {
        LogContext.currentLogContext().log(Level.WARNING, message);
    }

    private static LogContext currentLogContext() {
        LogContext ctx = LogContext.current(LogContext.class);
        if (ctx != null) {
            return ctx;
        }
        return OSGiServices.getLogContext();
    }

    protected LogContext() {
    }

    public abstract void prefix(Object ... var1);

    public abstract void setLevel(Level var1);

    public abstract void suffix(Object ... var1);

    protected abstract void log(Level var1, Object ... var2);

    public static enum Level {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FATAL;

    }
}

