/*
 * Decompiled with CFR 0.152.
 */
package javolution.tools;

import javolution.context.LogContext;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.text.TextBuilder;
import javolution.util.FastTable;

public abstract class Perfometer<T> {
    public static final Configurable<Integer> DURATION_MS = new Configurable<Integer>(){

        @Override
        public String getName() {
            return this.getClass().getEnclosingClass().getName() + "#DURATION_MS";
        }

        @Override
        protected Integer getDefault() {
            return 1000;
        }
    };
    public static final Configurable<Boolean> SKIP = new Configurable<Boolean>(){

        @Override
        public String getName() {
            return this.getClass().getEnclosingClass().getName() + "#SKIP";
        }

        @Override
        protected Boolean getDefault() {
            return false;
        }
    };
    private final String description;
    private T input;
    private long[] times;

    public Perfometer(String description) {
        this.description = description;
    }

    public double getAvgTimeInSeconds() {
        if (this.times == null) {
            return Double.NaN;
        }
        long sum = 0L;
        for (long time : this.times) {
            sum += time;
        }
        return (double)sum / 1.0E9 / (double)this.times.length;
    }

    public String getDescription() {
        return this.description;
    }

    public T getInput() {
        return this.input;
    }

    public int getNbrOfIterations() {
        return this.times != null ? this.times.length : 0;
    }

    public double[] getTimesInSeconds() {
        if (this.times == null) {
            return new double[0];
        }
        double[] timesSec = new double[this.times.length];
        for (int i = 0; i < this.times.length; ++i) {
            timesSec[i] = (double)this.times[i] / 1.0E9;
        }
        return timesSec;
    }

    public Perfometer<T> measure(T input) {
        return this.measure(input, 1);
    }

    public Perfometer<T> measure(T input, int nbrOfIterations) {
        if (SKIP.get().booleanValue()) {
            return this;
        }
        this.input = input;
        this.times = new long[nbrOfIterations];
        long[] calibrations = this.longArray(nbrOfIterations, Long.MAX_VALUE);
        long[] measures = this.longArray(nbrOfIterations, Long.MAX_VALUE);
        try {
            int i;
            long exitTime = System.currentTimeMillis() + (long)DURATION_MS.get().intValue();
            do {
                long time;
                long start;
                this.initialize();
                for (i = 0; i < nbrOfIterations; ++i) {
                    start = System.nanoTime();
                    this.run(false);
                    time = System.nanoTime() - start;
                    calibrations[i] = MathLib.min(calibrations[i], time);
                }
                this.initialize();
                for (i = 0; i < nbrOfIterations; ++i) {
                    start = System.nanoTime();
                    this.run(true);
                    time = System.nanoTime() - start;
                    measures[i] = MathLib.min(measures[i], time);
                }
            } while (System.currentTimeMillis() < exitTime);
            for (i = 0; i < nbrOfIterations; ++i) {
                this.times[i] = measures[i] - calibrations[i];
            }
            return this;
        }
        catch (Exception error) {
            throw new RuntimeException("Perfometer Exception", error);
        }
    }

    public void print() {
        if (SKIP.get().booleanValue()) {
            return;
        }
        TextBuilder txt = new TextBuilder();
        txt.append(this.description).append(" (").append(this.getNbrOfIterations()).append(") for ").append(this.input).append(": ");
        while (txt.length() < 80) {
            txt.append(' ');
        }
        txt.append(this.getAvgTimeInSeconds() * 1.0E9, 8, false, true);
        txt.append(" ns (avg), ");
        txt.append(this.getWCETinSeconds() * 1.0E9, 8, false, true);
        txt.append(" ns (wcet#").append(this.getWorstCaseNumber()).append(")");
        LogContext.info(txt);
    }

    public void printDetails() {
        if (SKIP.get().booleanValue()) {
            return;
        }
        FastTable<Long> measurements = new FastTable<Long>();
        for (long time : this.times) {
            measurements.add(time);
        }
        LogContext.debug(measurements);
    }

    public double getWCETinSeconds() {
        if (this.times == null) {
            return Double.NaN;
        }
        long wcet = 0L;
        for (long time : this.times) {
            if (time <= wcet) continue;
            wcet = time;
        }
        return (double)wcet / 1.0E9;
    }

    public int getWorstCaseNumber() {
        if (this.times == null) {
            return -1;
        }
        long wcet = 0L;
        int j = -1;
        for (int i = 0; i < this.times.length; ++i) {
            if (this.times[i] <= wcet) continue;
            wcet = this.times[i];
            j = i;
        }
        return j;
    }

    protected abstract void initialize() throws Exception;

    protected abstract void run(boolean var1) throws Exception;

    protected void validate() {
    }

    private long[] longArray(int length, long initialValue) {
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = initialValue;
        }
        return array;
    }
}

