/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.math;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.util.math.package$;
import java.io.Serializable;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class RatioFitting$
implements LazyLogging {
    public static RatioFitting$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new RatioFitting$();
    }

    private Logger logger$lzycompute() {
        RatioFitting$ ratioFitting$ = this;
        synchronized (ratioFitting$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public float[] fit(float[][] abundanceMatrix, float[] minAbundances) {
        int[] valuesCountByColumns = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix)).transpose((Function1)Predef$.MODULE$.$conforms()))).map((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToInteger((int)RatioFitting$.$anonfun$fit$1(col)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return this._fit(abundanceMatrix, this.buildImputedRatioMatrix(abundanceMatrix, minAbundances, valuesCountByColumns), valuesCountByColumns);
    }

    public float[] fitWithoutImputation(float[][] abundanceMatrix) {
        int[] valuesCountByColumns = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix)).transpose((Function1)Predef$.MODULE$.$conforms()))).map((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToInteger((int)RatioFitting$.$anonfun$fitWithoutImputation$1(col)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return this._fit(abundanceMatrix, this.buildRatioMatrix(abundanceMatrix), valuesCountByColumns);
    }

    public float[] fitWithCountPredicate(float[][] abundanceMatrix, int minRatioCount) {
        ObjectRef matrix = ObjectRef.create((Object)((float[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix)).transpose((Function1)Predef$.MODULE$.$conforms())));
        int[] valuesCountByColumns = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((float[][])matrix.elem))).map((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToInteger((int)RatioFitting$.$anonfun$fitWithCountPredicate$1(col)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        valuesCountByColumns = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(valuesCountByColumns)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)c -> c < scala.math.package$.MODULE$.min(minRatioCount, abundanceMatrix.length - 1) ? 0 : c, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(valuesCountByColumns)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RatioFitting$.$anonfun$fitWithCountPredicate$4(matrix, abundanceMatrix, x0$1);
            return BoxedUnit.UNIT;
        });
        matrix.elem = (float[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((float[][])matrix.elem))).transpose((Function1)Predef$.MODULE$.$conforms());
        return this._fit((float[][])matrix.elem, this.buildRatioMatrix((float[][])matrix.elem), valuesCountByColumns);
    }

    private float[] _fit(float[][] abundanceMatrix, double[][] imputedRatioMatrixr, int[] valuesCountByColumns) {
        double[] ratios = this.rowMedian(imputedRatioMatrixr);
        double[] logRatios = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(ratios)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> Math.log(x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        int[] naNRatiosIndexes = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logRatios)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RatioFitting$.$anonfun$_fit$2(p))))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5._2$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        double[] filteredLogRatios = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logRatios)).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> !Predef$.MODULE$.double2Double(x$6).isNaN());
        if (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(filteredLogRatios)).isEmpty()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No eligible columns for ratios computation");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix)).transpose((Function1)Predef$.MODULE$.$conforms()))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToFloat((float)RatioFitting$.MODULE$._calcAbundanceSum(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        }
        double[][] gc = this.buildCoefficientMatrix(abundanceMatrix, naNRatiosIndexes);
        DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(gc, false)).getSolver();
        ArrayRealVector constants = new ArrayRealVector(filteredLogRatios, false);
        RealVector solution = solver.solve((RealVector)constants);
        double[] coeffs = solution.toArray();
        coeffs = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coeffs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RatioFitting$.$anonfun$_fit$6(valuesCountByColumns, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double coeffSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coeffs)).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$8, x$9) -> x$8 + x$9));
        double intensitySum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)RatioFitting$.$anonfun$_fit$8(x$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(a, b) -> a + b));
        coeffs = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coeffs)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$11 -> x$11 * intensitySum / coeffSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        float[] abundances = (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coeffs)).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$12 -> (float)x$12, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        abundances = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(abundances)).map((Function1)(JFunction1.mcFF.sp & Serializable & scala.Serializable)p -> (double)p == 0.0 ? Float.NaN : p, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        return abundances;
    }

    private double[][] buildImputedRatioMatrix(float[][] pep, float[] min, int[] valuesColumnCount) {
        ObjectRef ratiosMatrix = ObjectRef.create((Object)this.buildRatioMatrix(pep));
        int[] nonNullRatiosCount = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((double[][])ratiosMatrix.elem))).transpose((Function1)Predef$.MODULE$.$conforms()))).map((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToInteger((int)RatioFitting$.$anonfun$buildImputedRatioMatrix$1(col)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        IntRef rowIdx = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pep)).foreach((Function1 & Serializable & scala.Serializable)row -> {
            RatioFitting$.$anonfun$buildImputedRatioMatrix$3(ratiosMatrix, rowIdx, nonNullRatiosCount, min, row);
            return BoxedUnit.UNIT;
        });
        return (double[][])ratiosMatrix.elem;
    }

    private double[][] buildRatioMatrix(float[][] pep) {
        int length = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), pep[0].length - 1).view().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ObjectRef matrix = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pep)).foreach((Function1 & Serializable & scala.Serializable)row -> {
            double[] nr = (double[])Array$.MODULE$.fill(length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.NaN, ClassTag$.MODULE$.Double());
            IntRef index = IntRef.create((int)0);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ((float[])row).length - 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(i + 1), ((float[])row).length - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                if (!Predef$.MODULE$.float2Float(row[i]).isNaN() && !Predef$.MODULE$.float2Float(row[j]).isNaN() && row[i] * row[j] != 0.0f) {
                    nr$2[index$2.elem] = row[j] / row[i];
                }
                ++index$2.elem;
            }));
            return ((ArrayBuffer)matrix$2.elem).$plus$eq((Object)nr);
        });
        return (double[][])((ArrayBuffer)matrix.elem).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public double[][] buildCoefficientMatrix(float[][] pep, int[] naNRatiosIndexes) {
        ObjectRef matrix = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        IntRef row = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), pep[0].length - 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(i + 1), pep[0].length - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            BoxedUnit boxedUnit;
            if (!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(naNRatiosIndexes)).contains((Object)BoxesRunTime.boxToInteger((int)row$3.elem))) {
                double[] nr = (double[])Array$.MODULE$.fill(pep[0].length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
                nr[i$3] = -1.0;
                nr[j] = 1.0;
                boxedUnit = ((ArrayBuffer)matrix$3.elem).$plus$eq((Object)nr);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ++row$3.elem;
        }));
        return (double[][])((ArrayBuffer)matrix.elem).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    /*
     * WARNING - void declaration
     */
    private double[] rowMedian(double[][] values) {
        void var2_2;
        double[] medians = (double[])Array$.MODULE$.fill(values[0].length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), values[0].length - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)col -> {
            double[] colValues = (double[])Array$.MODULE$.fill(values.length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.NaN, ClassTag$.MODULE$.Double());
            IntRef k = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).foreach((Function1 & Serializable & scala.Serializable)row -> {
                RatioFitting$.$anonfun$rowMedian$4(colValues, k, col, row);
                return BoxedUnit.UNIT;
            });
            medians$1[col] = package$.MODULE$.filteredMedian(colValues);
        });
        return var2_2;
    }

    private float _calcAbundanceSum(float[] abundances) {
        float[] defAbundances = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(abundances)).filter((Function1)(JFunction1.mcZF.sp & Serializable & scala.Serializable)x$14 -> !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$14));
        return defAbundances.length == 0 ? Float.NaN : BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(defAbundances)).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$fit$1(float[] col) {
        return new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(col)).count((Function1)(JFunction1.mcZF.sp & Serializable & scala.Serializable)x$1 -> !Predef$.MODULE$.float2Float(x$1).isNaN());
    }

    public static final /* synthetic */ int $anonfun$fitWithoutImputation$1(float[] col) {
        return new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(col)).count((Function1)(JFunction1.mcZF.sp & Serializable & scala.Serializable)x$2 -> !Predef$.MODULE$.float2Float(x$2).isNaN());
    }

    public static final /* synthetic */ int $anonfun$fitWithCountPredicate$1(float[] col) {
        return new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(col)).count((Function1)(JFunction1.mcZF.sp & Serializable & scala.Serializable)x$3 -> !Predef$.MODULE$.float2Float(x$3).isNaN());
    }

    public static final /* synthetic */ void $anonfun$fitWithCountPredicate$4(ObjectRef matrix$1, float[][] abundanceMatrix$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int c = tuple2._1$mcI$sp();
            int index = tuple2._2$mcI$sp();
            if (c == 0) {
                ((float[][])matrix$1.elem)[index] = (float[])Array$.MODULE$.fill(abundanceMatrix$1.length, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> Float.NaN, ClassTag$.MODULE$.Float());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$_fit$2(Tuple2 p) {
        return Predef$.MODULE$.double2Double(p._1$mcD$sp()).isNaN();
    }

    public static final /* synthetic */ double $anonfun$_fit$6(int[] valuesCountByColumns$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double p = tuple2._1$mcD$sp();
        int i = tuple2._2$mcI$sp();
        double d = valuesCountByColumns$1[i] == 0 ? 0.0 : Math.exp(p);
        return d;
    }

    public static final /* synthetic */ double $anonfun$_fit$9(double a, float b) {
        return Predef$.MODULE$.float2Float(b).isNaN() ? a : a + (double)b;
    }

    public static final /* synthetic */ double $anonfun$_fit$8(float[] x$10) {
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$10)).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToDouble((double)RatioFitting$.$anonfun$_fit$9(BoxesRunTime.unboxToDouble((Object)a), BoxesRunTime.unboxToFloat((Object)b)))));
    }

    public static final /* synthetic */ int $anonfun$buildImputedRatioMatrix$1(double[] col) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(col)).count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$13 -> !Predef$.MODULE$.double2Double(x$13).isNaN());
    }

    public static final /* synthetic */ void $anonfun$buildImputedRatioMatrix$3(ObjectRef ratiosMatrix$1, IntRef rowIdx$1, int[] nonNullRatiosCount$1, float[] min$1, float[] row) {
        double[] nr = ((double[][])ratiosMatrix$1.elem)[rowIdx$1.elem];
        IntRef index = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), row.length - 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(i + 1), row.length - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            if (!Predef$.MODULE$.float2Float(row[i]).isNaN() || !Predef$.MODULE$.float2Float(row[j]).isNaN()) {
                float a = Predef$.MODULE$.float2Float(row[j]).isNaN() && nonNullRatiosCount$1[index$1.elem] != 0 ? min$1[j] : row[j];
                float b = Predef$.MODULE$.float2Float(row[i]).isNaN() && nonNullRatiosCount$1[index$1.elem] != 0 ? min$1[i] : row[i];
                nr$1[index$1.elem] = a / b;
            }
            ++index$1.elem;
        }));
        ++rowIdx$1.elem;
    }

    public static final /* synthetic */ void $anonfun$rowMedian$4(double[] colValues$1, IntRef k$1, int col$1, double[] row) {
        colValues$1[k$1.elem] = row[col$1];
        ++k$1.elem;
    }

    private RatioFitting$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

