/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ssl;

import com.ning.http.util.Base64;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sun.security.util.HostnameChecker;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u001b\t9B)\u001a4bk2$\bj\\:u]\u0006lWMV3sS\u001aLWM\u001d\u0006\u0003\u0007\u0011\t1a]:m\u0015\t)a!\u0001\u0002xg*\u0011q\u0001C\u0001\u0005Y&\u00147O\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0003-\tA\u0001\u001d7bs\u000e\u00011c\u0001\u0001\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u0018;5\t\u0001D\u0003\u0002\u00043)\u0011!dG\u0001\u0004]\u0016$(\"\u0001\u000f\u0002\u000b)\fg/\u0019=\n\u0005yA\"\u0001\u0005%pgRt\u0017-\\3WKJLg-[3s\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!\u0001C\u0004&\u0001\t\u0007I\u0011\u0002\u0014\u0002\r1|wmZ3s+\u00059\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013aA8sO&\u0011a&\u000b\u0002\u0007\u0019><w-\u001a:\t\rA\u0002\u0001\u0015!\u0003(\u0003\u001dawnZ4fe\u0002BQA\r\u0001\u0005\u0002M\nq\u0002[8ti:\fW.Z\"iK\u000e\\WM]\u000b\u0002iA\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\u0005kRLGN\u0003\u0002:u\u0005A1/Z2ve&$\u0018PC\u0001<\u0003\r\u0019XO\\\u0005\u0003{Y\u0012q\u0002S8ti:\fW.Z\"iK\u000e\\WM\u001d\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u000e[\u0006$8\r[&fe\n,'o\\:\u0015\u0007\u0005;\u0005\u000b\u0005\u0002C\u000b6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15IA\u0004C_>dW-\u00198\t\u000b!s\u0004\u0019A%\u0002\u0011!|7\u000f\u001e8b[\u0016\u0004\"AS'\u000f\u0005\t[\u0015B\u0001'D\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051\u001b\u0005\"B)?\u0001\u0004\u0011\u0016!\u00039sS:\u001c\u0017\u000e]1m!\t\u0019V+D\u0001U\u0015\tI$#\u0003\u0002W)\nI\u0001K]5oG&\u0004\u0018\r\u001c\u0005\u00061\u0002!\t!W\u0001\u000bSN\\UM\u001d2fe>\u001cHCA![\u0011\u0015\tv\u000b1\u0001S\u0011\u0015a\u0006\u0001\"\u0001^\u0003\u00191XM]5gsR\u0019\u0011IX0\t\u000b![\u0006\u0019A%\t\u000b\u0001\\\u0006\u0019A1\u0002\u000fM,7o]5p]B\u0011qCY\u0005\u0003Gb\u0011!bU*M'\u0016\u001c8/[8o\u0001")
public class DefaultHostnameVerifier
implements HostnameVerifier {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private Logger logger() {
        return this.logger;
    }

    public HostnameChecker hostnameChecker() {
        return HostnameChecker.getInstance((byte)1);
    }

    public boolean matchKerberos(String hostname, Principal principal) {
        return HostnameChecker.match((String)hostname, (Principal)((KerberosPrincipal)principal));
    }

    public boolean isKerberos(Principal principal) {
        return principal != null && principal instanceof KerberosPrincipal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean verify(String hostname, SSLSession session) {
        boolean bl;
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: hostname = ", ", sessionId (base64) = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostname, Base64.encode((byte[])session.getId())})));
        HostnameChecker checker = this.hostnameChecker();
        try {
            boolean bl2;
            Certificate cert;
            Certificate[] certificateArray = session.getPeerCertificates();
            Option option = Array$.MODULE$.unapplySeq((Object)certificateArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) < 0 || !((cert = (Certificate)((SeqLike)option.get()).apply(0)) instanceof X509Certificate)) {
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: Peer does not have any certificates: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certificateArray})));
                bl2 = false;
            } else {
                boolean bl3;
                X509Certificate x509Certificate = (X509Certificate)cert;
                try {
                    checker.match(hostname, x509Certificate);
                    bl3 = true;
                }
                catch (CertificateException certificateException) {
                    Collection<List<?>> subjectAltNames = x509Certificate.getSubjectAlternativeNames();
                    this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: Certificate does not match hostname! subjectAltNames = ", ", hostName = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subjectAltNames, hostname})), (Throwable)certificateException);
                    bl3 = false;
                }
                bl2 = bl3;
            }
            bl = bl2;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            try {
                Principal principal = session.getPeerPrincipal();
                if (this.isKerberos(principal)) {
                    bl = this.matchKerberos(hostname, principal);
                } else {
                    this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: Can't verify principal, not Kerberos"})).s((Seq)Nil$.MODULE$));
                    bl = false;
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException2) {
                this.logger().debug("Can't verify principal, no principal", (Throwable)sSLPeerUnverifiedException2);
                bl = false;
            }
        }
        boolean result = bl;
        this.logger().debug("verify: returning {}", (Object)BoxesRunTime.boxToBoolean((boolean)result));
        return result;
    }
}

