/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class Json {
    private static final ObjectMapper defaultObjectMapper = Json.newDefaultMapper();
    private static volatile ObjectMapper objectMapper = null;

    static ObjectMapper newDefaultMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JSR310Module());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static ObjectMapper mapper() {
        if (objectMapper == null) {
            return defaultObjectMapper;
        }
        return objectMapper;
    }

    private static String generateJson(Object object, boolean bl, boolean bl2) {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonGenerator jsonGenerator = new JsonFactory((ObjectCodec)Json.mapper()).createGenerator((Writer)stringWriter);
            if (bl) {
                jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            }
            if (bl2) {
                jsonGenerator.enable(JsonGenerator.Feature.ESCAPE_NON_ASCII);
            }
            Json.mapper().writeValue(jsonGenerator, object);
            stringWriter.flush();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static JsonNode toJson(Object object) {
        try {
            return Json.mapper().valueToTree(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <A> A fromJson(JsonNode jsonNode, Class<A> clazz) {
        try {
            return (A)Json.mapper().treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ObjectNode newObject() {
        return Json.mapper().createObjectNode();
    }

    public static ArrayNode newArray() {
        return Json.mapper().createArrayNode();
    }

    public static String stringify(JsonNode jsonNode) {
        return Json.generateJson(jsonNode, false, false);
    }

    public static String asciiStringify(JsonNode jsonNode) {
        return Json.generateJson(jsonNode, false, true);
    }

    public static String prettyPrint(JsonNode jsonNode) {
        return Json.generateJson(jsonNode, true, false);
    }

    public static JsonNode parse(String string) {
        try {
            return Json.mapper().readTree(string);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static JsonNode parse(InputStream inputStream) {
        try {
            return Json.mapper().readTree(inputStream);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static JsonNode parse(byte[] byArray) {
        try {
            return Json.mapper().readTree(byArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        Json.objectMapper = objectMapper;
    }
}

