/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import play.core.j.JavaParsers;
import play.mvc.Http;

public interface BodyParser {
    public play.api.mvc.BodyParser<Http.RequestBody> parser(long var1);

    public static class Empty
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            if (l != -1L) {
                throw new IllegalArgumentException("Empty BodyParser's maxLength argument is ignored so it must have a value of -1, was: " + l);
            }
            return JavaParsers.empty();
        }
    }

    public static class MultipartFormData
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.multipartFormData(l);
        }
    }

    public static class FormUrlEncoded
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.formUrlEncoded(l);
        }
    }

    public static class Raw
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.raw(l);
        }
    }

    public static class TolerantText
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.tolerantText(l);
        }
    }

    public static class Text
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.text(l);
        }
    }

    public static class TolerantXml
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.tolerantXml(l);
        }
    }

    public static class Xml
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.xml(l);
        }
    }

    public static class TolerantJson
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.tolerantJson(l);
        }
    }

    public static class Json
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.json(l);
        }
    }

    public static class AnyContent
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.anyContent(l);
        }
    }

    public static class Default
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(long l) {
            return JavaParsers.default_(l);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Of {
        public Class<? extends BodyParser> value();

        public long maxLength() default -1L;
    }
}

