/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.DirectBufferAccess;
import sun.misc.Unsafe;

public class MessageBuffer {
    static final boolean isUniversalBuffer;
    static final Unsafe unsafe;
    private static final Constructor<?> mbArrConstructor;
    static final int ARRAY_BYTE_BASE_OFFSET;
    private static final String UNIVERSAL_MESSAGE_BUFFER = "org.msgpack.core.buffer.MessageBufferU";
    private static final String BIGENDIAN_MESSAGE_BUFFER = "org.msgpack.core.buffer.MessageBufferBE";
    private static final String DEFAULT_MESSAGE_BUFFER = "org.msgpack.core.buffer.MessageBuffer";
    protected final Object base;
    protected final long address;
    protected final int size;

    public static MessageBuffer allocate(int n) {
        return MessageBuffer.wrap(new byte[n]);
    }

    public static MessageBuffer wrap(byte[] byArray) {
        return MessageBuffer.newMessageBuffer(byArray, 0, byArray.length);
    }

    public static MessageBuffer wrap(byte[] byArray, int n, int n2) {
        return MessageBuffer.newMessageBuffer(byArray, n, n2);
    }

    private static MessageBuffer newMessageBuffer(byte[] byArray, int n, int n2) {
        Preconditions.checkNotNull(byArray);
        try {
            return (MessageBuffer)mbArrConstructor.newInstance(byArray, n, n2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void releaseBuffer(MessageBuffer messageBuffer) {
        if (!isUniversalBuffer && !(messageBuffer.base instanceof byte[])) {
            unsafe.freeMemory(messageBuffer.address);
        }
    }

    MessageBuffer(byte[] byArray, int n, int n2) {
        this.base = byArray;
        this.address = ARRAY_BYTE_BASE_OFFSET + n;
        this.size = n2;
    }

    protected MessageBuffer(Object object, long l, int n) {
        this.base = object;
        this.address = l;
        this.size = n;
    }

    public int size() {
        return this.size;
    }

    public MessageBuffer slice(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        Preconditions.checkArgument(n + n2 <= this.size());
        return new MessageBuffer(this.base, this.address + (long)n, n2);
    }

    public byte getByte(int n) {
        return unsafe.getByte(this.base, this.address + (long)n);
    }

    public boolean getBoolean(int n) {
        return unsafe.getBoolean(this.base, this.address + (long)n);
    }

    public short getShort(int n) {
        short s = unsafe.getShort(this.base, this.address + (long)n);
        return Short.reverseBytes(s);
    }

    public int getInt(int n) {
        int n2 = unsafe.getInt(this.base, this.address + (long)n);
        return Integer.reverseBytes(n2);
    }

    public float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    public long getLong(int n) {
        long l = unsafe.getLong(this.base, this.address + (long)n);
        return Long.reverseBytes(l);
    }

    public double getDouble(int n) {
        return Double.longBitsToDouble(this.getLong(n));
    }

    public void getBytes(int n, byte[] byArray, int n2, int n3) {
        unsafe.copyMemory(this.base, this.address + (long)n, byArray, ARRAY_BYTE_BASE_OFFSET + n2, n3);
    }

    public void getBytes(int n, int n2, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < n2) {
            throw new BufferOverflowException();
        }
        ByteBuffer byteBuffer2 = this.sliceAsByteBuffer(n, n2);
        byteBuffer.put(byteBuffer2);
    }

    public void putByte(int n, byte by) {
        unsafe.putByte(this.base, this.address + (long)n, by);
    }

    public void putBoolean(int n, boolean bl) {
        unsafe.putBoolean(this.base, this.address + (long)n, bl);
    }

    public void putShort(int n, short s) {
        s = Short.reverseBytes(s);
        unsafe.putShort(this.base, this.address + (long)n, s);
    }

    public void putInt(int n, int n2) {
        n2 = Integer.reverseBytes(n2);
        unsafe.putInt(this.base, this.address + (long)n, n2);
    }

    public void putFloat(int n, float f) {
        this.putInt(n, Float.floatToRawIntBits(f));
    }

    public void putLong(int n, long l) {
        l = Long.reverseBytes(l);
        unsafe.putLong(this.base, this.address + (long)n, l);
    }

    public void putDouble(int n, double d) {
        this.putLong(n, Double.doubleToRawLongBits(d));
    }

    public void putBytes(int n, byte[] byArray, int n2, int n3) {
        unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + n2, this.base, this.address + (long)n, n3);
    }

    public void putByteBuffer(int n, ByteBuffer byteBuffer, int n2) {
        assert (n2 <= byteBuffer.remaining());
        assert (!isUniversalBuffer);
        if (byteBuffer.isDirect()) {
            unsafe.copyMemory(null, DirectBufferAccess.getAddress(byteBuffer) + (long)byteBuffer.position(), this.base, this.address + (long)n, n2);
            byteBuffer.position(byteBuffer.position() + n2);
        } else if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + byteBuffer.position(), this.base, this.address + (long)n, n2);
            byteBuffer.position(byteBuffer.position() + n2);
        } else if (this.base != null) {
            byteBuffer.get((byte[])this.base, n, n2);
        } else {
            for (int i = 0; i < n2; ++i) {
                unsafe.putByte(this.base, this.address + (long)n, byteBuffer.get());
            }
        }
    }

    public ByteBuffer sliceAsByteBuffer(int n, int n2) {
        return ByteBuffer.wrap((byte[])this.base, (int)(this.address - (long)ARRAY_BYTE_BASE_OFFSET + (long)n), n2);
    }

    public ByteBuffer sliceAsByteBuffer() {
        return this.sliceAsByteBuffer(0, this.size());
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        unsafe.copyMemory(this.base, this.address, byArray, ARRAY_BYTE_BASE_OFFSET, this.size());
        return byArray;
    }

    public byte[] array() {
        return (byte[])this.base;
    }

    public int arrayOffset() {
        return (int)this.address - ARRAY_BYTE_BASE_OFFSET;
    }

    public void copyTo(int n, MessageBuffer messageBuffer, int n2, int n3) {
        unsafe.copyMemory(this.base, this.address + (long)n, messageBuffer.base, messageBuffer.address + (long)n2, n3);
    }

    public String toHexString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2; ++i) {
            if (i != n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("%02x", this.getByte(i)));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        String string;
        int n;
        Unsafe unsafe;
        boolean bl;
        block21: {
            int n2;
            block20: {
                int n3;
                bl = false;
                unsafe = null;
                n = 16;
                string = System.getProperty("java.specification.version", "");
                n2 = string.indexOf(46);
                boolean bl2 = false;
                if (n2 != -1) {
                    try {
                        n3 = Integer.parseInt(string.substring(0, n2));
                        int n4 = Integer.parseInt(string.substring(n2 + 1));
                        bl2 = n3 > 1 || n3 == 1 && n4 >= 7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace(System.err);
                    }
                }
                n3 = 0;
                try {
                    n3 = Class.forName("sun.misc.Unsafe") != null ? 1 : 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl3 = System.getProperty("java.runtime.name", "").toLowerCase().contains("android");
                boolean bl4 = System.getProperty("com.google.appengine.runtime.version") != null;
                boolean bl5 = bl = Boolean.parseBoolean(System.getProperty("msgpack.universal-buffer", "false")) || bl3 || bl4 || !bl2 || n3 == 0;
                if (!bl) {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    unsafe = (Unsafe)field.get(null);
                    if (unsafe == null) {
                        throw new RuntimeException("Unsafe is unavailable");
                    }
                    n = unsafe.arrayBaseOffset(byte[].class);
                    int n5 = unsafe.arrayIndexScale(byte[].class);
                    if (n5 != 1) {
                        throw new IllegalStateException("Byte array index scale must be 1, but is " + n5);
                    }
                }
                MessageBuffer.unsafe = unsafe;
                ARRAY_BYTE_BASE_OFFSET = n;
                isUniversalBuffer = bl;
                if (!isUniversalBuffer) break block20;
                string = UNIVERSAL_MESSAGE_BUFFER;
                break block21;
            }
            n2 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0;
            string = n2 != 0 ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
            constructor.setAccessible(true);
            mbArrConstructor = constructor;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new RuntimeException(exception);
        }
        catch (Exception exception) {
            String string2;
            block22: {
                try {
                    exception.printStackTrace(System.err);
                    bl = true;
                    MessageBuffer.unsafe = unsafe;
                    ARRAY_BYTE_BASE_OFFSET = n;
                    isUniversalBuffer = bl;
                    if (!isUniversalBuffer) break block22;
                    string2 = UNIVERSAL_MESSAGE_BUFFER;
                }
                catch (Throwable throwable) {
                    String string3;
                    MessageBuffer.unsafe = unsafe;
                    ARRAY_BYTE_BASE_OFFSET = n;
                    isUniversalBuffer = bl;
                    if (isUniversalBuffer) {
                        string3 = UNIVERSAL_MESSAGE_BUFFER;
                    } else {
                        boolean bl6 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
                        string3 = bl6 ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER;
                    }
                    try {
                        Class<?> clazz = Class.forName(string3);
                        Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
                        constructor.setAccessible(true);
                        mbArrConstructor = constructor;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace(System.err);
                        throw new RuntimeException(exception2);
                    }
                    throw throwable;
                }
            }
            boolean bl7 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
            string2 = bl7 ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER;
            try {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
                constructor.setAccessible(true);
                mbArrConstructor = constructor;
            }
            catch (Exception exception3) {
                exception3.printStackTrace(System.err);
                throw new RuntimeException(exception3);
            }
        }
    }
}

