/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.msangel.gui.component.task.creation;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.msangel.gui.component.task.creation.DataFolderAndOptionsPanel$;
import fr.profi.msangel.gui.component.task.creation.InputDataPanel$;
import fr.profi.msangel.om.workflow.FileMonitoringConfig;
import fr.profi.msangel.om.workflow.FileMonitoringConfig$;
import fr.profi.util.scala.CheckResult;
import fr.profi.util.scala.CheckResult$;
import fr.profi.util.scala.ScalaUtils$;
import fr.profi.util.scalafx.NumericTextField;
import fr.profi.util.scalafx.TimeSpinner;
import fr.profi.util.scalafx.TitledBorderPane;
import fr.profi.util.scalafx.implicits.package$;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import javafx.scene.control.SpinnerValueFactory;
import org.joda.time.DateTime;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalafx.Includes$;
import scalafx.scene.Node;
import scalafx.scene.control.Button;
import scalafx.scene.control.CheckBox;
import scalafx.scene.control.DatePicker;
import scalafx.scene.control.DatePicker$;
import scalafx.scene.control.Label;
import scalafx.scene.control.RadioButton;
import scalafx.scene.control.TextField;
import scalafx.scene.control.ToggleGroup;
import scalafx.scene.control.ToggleGroup$;
import scalafx.scene.layout.VBox;

public final class DataFolderAndOptionsPanel$
implements LazyLogging {
    public static final DataFolderAndOptionsPanel$ MODULE$;
    private final TextField folderPathField;
    private final Button selectFolderButton;
    private final String wildcardTooltipText;
    private final Label wildcardLabel;
    private final TextField wildcardPatternField;
    private final ToggleGroup wildcardPatternToggleGroup;
    private final RadioButton includeRadio;
    private final RadioButton excludeRadio;
    private final CheckBox newFilesOnlyBox;
    private final CheckBox includeSubFoldersBox;
    private final CheckBox maxFileCountBox;
    private final NumericTextField maxFileCountSpinner;
    private final CheckBox maxDateBox;
    private final DatePicker maxDatePicker;
    private final TimeSpinner maxTimeSpinner;
    private final CheckBox maxIntervalBetweenAcquisitionBox;
    private final VBox folderBox;
    private final VBox endingOptionsBox;
    private final TitledBorderPane endingOptionsPane;
    private final VBox inputFolderRtmBox;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DataFolderAndOptionsPanel$();
    }

    private Logger logger$lzycompute() {
        DataFolderAndOptionsPanel$ dataFolderAndOptionsPanel$ = this;
        synchronized (dataFolderAndOptionsPanel$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public TextField folderPathField() {
        return this.folderPathField;
    }

    public Button selectFolderButton() {
        return this.selectFolderButton;
    }

    public String wildcardTooltipText() {
        return this.wildcardTooltipText;
    }

    public Label wildcardLabel() {
        return this.wildcardLabel;
    }

    public TextField wildcardPatternField() {
        return this.wildcardPatternField;
    }

    public ToggleGroup wildcardPatternToggleGroup() {
        return this.wildcardPatternToggleGroup;
    }

    public RadioButton includeRadio() {
        return this.includeRadio;
    }

    public RadioButton excludeRadio() {
        return this.excludeRadio;
    }

    public CheckBox newFilesOnlyBox() {
        return this.newFilesOnlyBox;
    }

    public CheckBox includeSubFoldersBox() {
        return this.includeSubFoldersBox;
    }

    public CheckBox maxFileCountBox() {
        return this.maxFileCountBox;
    }

    public NumericTextField maxFileCountSpinner() {
        return this.maxFileCountSpinner;
    }

    public CheckBox maxDateBox() {
        return this.maxDateBox;
    }

    public DatePicker maxDatePicker() {
        return this.maxDatePicker;
    }

    public TimeSpinner maxTimeSpinner() {
        return this.maxTimeSpinner;
    }

    public CheckBox maxIntervalBetweenAcquisitionBox() {
        return this.maxIntervalBetweenAcquisitionBox;
    }

    public VBox folderBox() {
        return this.folderBox;
    }

    public VBox endingOptionsBox() {
        return this.endingOptionsBox;
    }

    public TitledBorderPane endingOptionsPane() {
        return this.endingOptionsPane;
    }

    public VBox inputFolderRtmBox() {
        return this.inputFolderRtmBox;
    }

    public VBox apply() {
        return this.inputFolderRtmBox();
    }

    /*
     * WARNING - void declaration
     */
    public CheckResult checkInputData() {
        void var1_1;
        CheckResult checkResult = new CheckResult(new Some<Integer>(BoxesRunTime.boxToInteger(2)), CheckResult$.MODULE$.$lessinit$greater$default$2());
        Predef$.MODULE$.println();
        Predef$.MODULE$.println(this._getDateTime());
        Predef$.MODULE$.println();
        Serializable serializable = ((String)this.folderPathField().text().apply()).isEmpty() ? checkResult.addError("You must provide the data folder.\n") : BoxedUnit.UNIT;
        Serializable serializable2 = ((IterableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new CheckBox[]{this.maxFileCountBox(), this.maxDateBox(), this.maxIntervalBetweenAcquisitionBox()}))).forall(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CheckBox x$2) {
                return !x$2.selected().apply$mcZ$sp();
            }
        }) ? checkResult.addError("You must specify at least one ending option.\n") : BoxedUnit.UNIT;
        Serializable serializable3 = this._getDateTime().isBeforeNow() ? checkResult.addError("The maximal date/time has already passed.\n") : BoxedUnit.UNIT;
        return var1_1;
    }

    public Option<FileMonitoringConfig> toFileMonitoringConfig() {
        Option option;
        try {
            String x$4 = package$.MODULE$.field2string(this.folderPathField());
            String x$5 = (String)this.wildcardPatternField().text().apply();
            boolean x$6 = this.includeRadio().selected().apply$mcZ$sp();
            boolean x$7 = this.newFilesOnlyBox().selected().apply$mcZ$sp();
            boolean x$8 = this.includeSubFoldersBox().selected().apply$mcZ$sp();
            Option x$9 = this.maxFileCountBox().selected().apply$mcZ$sp() ? new Some<Integer>(BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString((String)this.maxFileCountSpinner().text().apply())).toInt())) : None$.MODULE$;
            None$ x$10 = this.maxDateBox().selected().apply$mcZ$sp() ? Option$.MODULE$.apply(this._getDateTime()) : None$.MODULE$;
            None$ x$11 = None$.MODULE$;
            Option x$12 = FileMonitoringConfig$.MODULE$.$lessinit$greater$default$7();
            FileMonitoringConfig rtmForm = new FileMonitoringConfig(x$4, x$5, x$6, x$7, x$8, x$9, x$12, (Option)x$10, (Option)x$11);
            option = new Some<FileMonitoringConfig>(rtmForm);
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Unable to create Real-Time Monitoring form :", (Throwable)exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            option = None$.MODULE$;
        }
        return option;
    }

    public void loadFileMonitoringConfig(Option<FileMonitoringConfig> configOpt) {
        if (configOpt.isDefined()) {
            FileMonitoringConfig config = configOpt.get();
            this.folderPathField().text_$eq(config.directory());
            this.wildcardPatternField().text_$eq(config.wildcardPattern());
            if (config.includeFilesMatchingWildcard()) {
                this.includeRadio().selected_$eq(true);
            } else {
                this.excludeRadio().selected_$eq(true);
            }
            this.newFilesOnlyBox().selected_$eq(config.newFilesOnly());
            this.includeSubFoldersBox().selected_$eq(config.includeSubDirs());
            if (config.maxFileCount().isEmpty()) {
                this.maxFileCountBox().selected_$eq(false);
            } else {
                this.maxFileCountBox().selected_$eq(true);
                this.maxFileCountSpinner().text_$eq(config.maxFileCount().get().toString());
            }
            if (config.maxDate().isEmpty()) {
                this.maxDateBox().selected_$eq(false);
            } else {
                DateTime maxDateTime = (DateTime)config.maxDate().get();
                this.maxDateBox().selected_$eq(true);
                this.maxDatePicker().value_$eq((Object)ScalaUtils$.MODULE$.dateTime2localDate(maxDateTime));
                Includes$.MODULE$.jfxSpinnerValueFactory2sfx((SpinnerValueFactory)this.maxTimeSpinner().valueFactory().apply()).value_$eq((Object)ScalaUtils$.MODULE$.dateTime2localTime(maxDateTime));
            }
            if (config.maxIntervalBetweenAcquisition().isEmpty()) {
                this.maxIntervalBetweenAcquisitionBox().selected_$eq(false);
            } else {
                this.maxIntervalBetweenAcquisitionBox().selected_$eq(true);
            }
        }
    }

    public void clear() {
        this.folderPathField().text_$eq("");
        this.wildcardPatternField().text_$eq("");
        this.maxFileCountSpinner().text_$eq("");
        this.maxDatePicker().value_$eq(null);
        ((IterableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new CheckBox[]{this.newFilesOnlyBox(), this.includeSubFoldersBox(), this.maxFileCountBox(), this.maxDateBox(), this.maxIntervalBetweenAcquisitionBox()}))).foreach(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CheckBox x$3) {
                x$3.selected_$eq(false);
            }
        });
    }

    public void fr$profi$msangel$gui$component$task$creation$DataFolderAndOptionsPanel$$_browseDirectory(Option<String> initDir) {
        File selectedDir = InputDataPanel$.MODULE$.browseDir(initDir);
        if (selectedDir != null) {
            this.folderPathField().text_$eq(selectedDir.getAbsolutePath());
        }
    }

    private Option<String> _browseDirectory$default$1() {
        return None$.MODULE$;
    }

    public DateTime _getDateTime() {
        LocalDate date = (LocalDate)this.maxDatePicker().value().apply();
        LocalTime time = (LocalTime)this.maxTimeSpinner().value().apply();
        return new DateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), time.getHour(), time.getMinute());
    }

    private DataFolderAndOptionsPanel$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.folderPathField = new anon.9();
        this.selectFolderButton = new anon.6();
        this.wildcardTooltipText = "Use '*' to match any characters. See examples below:\n\nWildcard= '*.raw' + option= include:\nonly files finishing by '.raw' will be taken into account\n\nWildcard= '*RKO*,*.scan,*Bgal*' + option= exclude:\nwill ignore all files which name contains 'RKO' and/or 'Bgal', and/or finishing by '.scan'.\nThis one is very convenient for monitoring WIFF files.\n\nWildcard= 'ABCDE' + option= include:\nwill only match a file which name is exactly 'ABCDE', without extension.\nTo match files beginning by 'ABCDE', use: 'ABCDE*'.\nTo match files containing 'ABCDE': use '*ABCDE*'.";
        this.wildcardLabel = new anon.10();
        this.wildcardPatternField = new anon.11();
        this.wildcardPatternToggleGroup = new ToggleGroup(ToggleGroup$.MODULE$.$lessinit$greater$default$1());
        this.includeRadio = new anon.1();
        this.excludeRadio = new anon.2();
        this.newFilesOnlyBox = new anon.7();
        this.includeSubFoldersBox = new CheckBox("Include sub-folders");
        this.maxFileCountBox = new CheckBox("Max. files count :");
        this.maxFileCountSpinner = new NumericTextField();
        this.maxDateBox = new CheckBox("Max. creation date :");
        this.maxDatePicker = new DatePicker(DatePicker$.MODULE$.$lessinit$greater$default$1());
        this.maxTimeSpinner = new TimeSpinner(LocalTime.of(18, 0));
        this.maxIntervalBetweenAcquisitionBox = new anon.8();
        this.folderBox = new anon.16();
        this.endingOptionsBox = new anon.21();
        this.endingOptionsPane = new TitledBorderPane("Ending options", (Node)this.endingOptionsBox(), "#AAAAAA");
        this.inputFolderRtmBox = new anon.25();
    }
}

