/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.msangel.gui.dal.cache;

import fr.profi.msangel.gui.dal.cache.AbstractJobCache;
import fr.profi.msangel.gui.dal.cache.WorkflowTaskCache$;
import fr.profi.msangel.om.MongoDbCollection$;
import fr.profi.msangel.om.workflow.WorkflowJob;
import fr.profi.msangel.om.workflow.WorkflowTask;
import fr.profi.util.scala.package$;
import org.joda.time.DateTime;
import play.api.libs.json.JsObject;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.VolatileByteRef;

public final class WorkflowJobCache$
extends AbstractJobCache<WorkflowJob> {
    public static final WorkflowJobCache$ MODULE$;
    private final Enumeration.Value collection;

    static {
        new WorkflowJobCache$();
    }

    @Override
    public Enumeration.Value collection() {
        return this.collection;
    }

    @Override
    public Option<WorkflowJob> json2objectOpt(JsObject jsObj) {
        return jsObj.asOpt((Reads)fr.profi.msangel.om.package$.MODULE$.workflowJobFormat());
    }

    @Override
    public Seq<Tuple2<String, WorkflowJob>> sortJobsByDate(Seq<Tuple2<String, WorkflowJob>> jobsWithId) {
        return (Seq)jobsWithId.sortBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DateTime apply(Tuple2<String, WorkflowJob> x$7) {
                return (DateTime)x$7._2().creationDate().get();
            }
        }, package$.MODULE$.dateTimeOrdering());
    }

    @Override
    public Seq<Tuple2<String, WorkflowJob>> getAllJobsForTask(String taskId) {
        return (Seq)this.getCachedObjects().filter((Function1)((Object)new Serializable(taskId){
            public static final long serialVersionUID = 0L;
            private final String taskId$4;

            public final boolean apply(Tuple2<String, WorkflowJob> x0$1) {
                Tuple2<String, WorkflowJob> tuple2 = x0$1;
                if (tuple2 != null) {
                    WorkflowJob job = tuple2._2();
                    String string = job.workflowTaskId();
                    String string2 = this.taskId$4;
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.taskId$4 = taskId$4;
            }
        }));
    }

    @Override
    public Seq<Tuple2<String, WorkflowJob>> updateAllJobsForTaskNow(String taskId) {
        return this.updateCacheNow("/get_docs_where", new Some<JsObject>(Json$.MODULE$.obj(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("workflowTaskId"), Json$.MODULE$.toJsFieldJsValueWrapper((Object)taskId, (Writes)Writes$.MODULE$.StringWrites()))}))), this.updateCacheNow$default$3());
    }

    @Override
    public void updateAllJobsForTaskIfNeeded(String taskId) {
        BooleanRef noJobForTaskInCache$lzy = BooleanRef.zero();
        BooleanRef someJobsAreIncomplete$lzy = BooleanRef.zero();
        BooleanRef workflowTaskIsIncomplete$lzy = BooleanRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        if (this.noJobForTaskInCache$2(taskId, noJobForTaskInCache$lzy, bitmap$0) || this.someJobsAreIncomplete$1(taskId, someJobsAreIncomplete$lzy, bitmap$0) || this.workflowTaskIsIncomplete$1(taskId, workflowTaskIsIncomplete$lzy, bitmap$0)) {
            this.updateAllJobsForTaskNow(taskId);
        }
    }

    private final boolean noJobForTaskInCache$lzycompute$1(String taskId$3, BooleanRef noJobForTaskInCache$lzy$2, VolatileByteRef bitmap$0$1) {
        WorkflowJobCache$ workflowJobCache$ = this;
        synchronized (workflowJobCache$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                noJobForTaskInCache$lzy$2.elem = !this.someJobsForTaskInCache(taskId$3);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return noJobForTaskInCache$lzy$2.elem;
        }
    }

    private final boolean noJobForTaskInCache$2(String taskId$3, BooleanRef noJobForTaskInCache$lzy$2, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.noJobForTaskInCache$lzycompute$1(taskId$3, noJobForTaskInCache$lzy$2, bitmap$0$1) : noJobForTaskInCache$lzy$2.elem;
    }

    private final boolean someJobsAreIncomplete$lzycompute$1(String taskId$3, BooleanRef someJobsAreIncomplete$lzy$1, VolatileByteRef bitmap$0$1) {
        WorkflowJobCache$ workflowJobCache$ = this;
        synchronized (workflowJobCache$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                someJobsAreIncomplete$lzy$1.elem = !this.getAllJobsForTask(taskId$3).forall((Function1<Tuple2<String, WorkflowJob>, Object>)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, WorkflowJob> x$8) {
                        return x$8._2().isComplete();
                    }
                }));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return someJobsAreIncomplete$lzy$1.elem;
        }
    }

    private final boolean someJobsAreIncomplete$1(String taskId$3, BooleanRef someJobsAreIncomplete$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.someJobsAreIncomplete$lzycompute$1(taskId$3, someJobsAreIncomplete$lzy$1, bitmap$0$1) : someJobsAreIncomplete$lzy$1.elem;
    }

    private final boolean workflowTaskIsIncomplete$lzycompute$1(String taskId$3, BooleanRef workflowTaskIsIncomplete$lzy$1, VolatileByteRef bitmap$0$1) {
        WorkflowJobCache$ workflowJobCache$ = this;
        synchronized (workflowJobCache$) {
            if ((byte)(bitmap$0$1.elem & 4) == 0) {
                workflowTaskIsIncomplete$lzy$1.elem = !((WorkflowTask)WorkflowTaskCache$.MODULE$.getCachedObject(taskId$3).get()).isComplete();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 4);
            }
            return workflowTaskIsIncomplete$lzy$1.elem;
        }
    }

    private final boolean workflowTaskIsIncomplete$1(String taskId$3, BooleanRef workflowTaskIsIncomplete$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 4) == 0 ? this.workflowTaskIsIncomplete$lzycompute$1(taskId$3, workflowTaskIsIncomplete$lzy$1, bitmap$0$1) : workflowTaskIsIncomplete$lzy$1.elem;
    }

    private WorkflowJobCache$() {
        super(ClassTag$.MODULE$.apply(WorkflowJob.class));
        MODULE$ = this;
        this.collection = MongoDbCollection$.MODULE$.WORKFLOW_JOB_COLLECTION();
    }
}

