/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.msangel.gui.dal;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.msangel.gui.GUI$;
import fr.profi.msangel.gui.dal.DataStoreRetriever$;
import fr.profi.msangel.gui.dal.cache.MSAngelConfigCache$;
import java.net.ConnectException;
import javafx.scene.Scene;
import play.api.http.Writeable$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsLookupResult$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsReadable;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSResponse;
import play.api.libs.ws.ning.NingWSClient;
import play.api.mvc.Codec$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scalafx.scene.Cursor$;

public final class DataStoreRetriever$
implements LazyLogging {
    public static final DataStoreRetriever$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DataStoreRetriever$();
    }

    private Logger logger$lzycompute() {
        DataStoreRetriever$ dataStoreRetriever$ = this;
        synchronized (dataStoreRetriever$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <T> Future<Seq<Option<T>>> retrieve(String requestUrl, Function1<JsObject, T> mappingFunction, Option<JsValue> requestBody, ClassTag<T> tag) {
        BoxedUnit boxedUnit;
        NingWSClient WS2 = GUI$.MODULE$.app().WS();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieving data from Proline server at ", "..."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{requestUrl})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Future futureResponse = requestBody.isDefined() ? WS2.url(requestUrl).post((Object)requestBody.get(), Writeable$.MODULE$.writeableOf_JsValue(Codec$.MODULE$.utf_8())) : WS2.url(requestUrl).get();
        futureResponse.onFailure(new Serializable(requestUrl){
            public static final long serialVersionUID = 0L;
            private final String requestUrl$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to execute request at URL ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.requestUrl$1}));
                if (DataStoreRetriever$.MODULE$.logger().underlying().isDebugEnabled()) {
                    DataStoreRetriever$.MODULE$.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{msg})), A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return (B1)boxedUnit2;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.requestUrl$1 = requestUrl$1;
            }
        }, ExecutionContext.Implicits$.MODULE$.global());
        return futureResponse.map(new Serializable(requestUrl, mappingFunction, tag){
            public static final long serialVersionUID = 0L;
            public final String requestUrl$1;
            public final Function1 mappingFunction$1;
            public final ClassTag tag$1;

            public final Seq<Option<T>> apply(WSResponse response) {
                Seq<A> seq;
                try {
                    BoxedUnit boxedUnit;
                    Option<JsValue> respAsJsonOpt = Option$.MODULE$.apply(Json$.MODULE$.parse(response.body()));
                    Predef$.MODULE$.require(!respAsJsonOpt.isEmpty(), (Function0<Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.retrieve.2 $outer;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse server response into JSON data\\n(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.requestUrl$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    Option<Seq<JsObject>> seqOpt = ((JsReadable)respAsJsonOpt.get()).asOpt(Reads$.MODULE$.traversableReads(Seq$.MODULE$.canBuildFrom(), (Reads)Reads$.MODULE$.JsObjectReads()));
                    Option objOpt = ((JsReadable)respAsJsonOpt.get()).asOpt((Reads)Reads$.MODULE$.JsObjectReads());
                    Option<Seq<JsObject>> objAsSeqOpt = objOpt.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<JsObject> apply(JsObject x$1) {
                            return (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new JsObject[]{x$1}));
                        }
                    });
                    Option<Seq<JsObject>> finalSeqOpt = seqOpt.isDefined() ? seqOpt : (seqOpt.isEmpty() && objAsSeqOpt.isDefined() ? objAsSeqOpt : None$.MODULE$);
                    Predef$.MODULE$.require(!finalSeqOpt.isEmpty(), (Function0<Object>)((Object)new Serializable(this, respAsJsonOpt){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.retrieve.2 $outer;
                        private final Option respAsJsonOpt$1;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract desired objects from JSON response:\\n(", ")\\n", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.requestUrl$1, ((JsValue)this.respAsJsonOpt$1.get()).toString()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.respAsJsonOpt$1 = respAsJsonOpt$1;
                        }
                    }));
                    Seq<A> resultObjectOpts = ((TraversableLike)finalSeqOpt.get()).map(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.retrieve.2 $outer;

                        public final Option<T> apply(JsObject jsObj) {
                            Option option;
                            try {
                                option = new Some<R>(this.$outer.mappingFunction$1.apply(jsObj));
                            }
                            catch (Throwable throwable) {
                                BoxedUnit boxedUnit;
                                String className = package$.MODULE$.classTag(this.$outer.tag$1).runtimeClass().getName();
                                Option oid = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)jsObj), "_id")), "$oid").asOpt((Reads)Reads$.MODULE$.StringReads());
                                Option name = JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)jsObj), "name").asOpt((Reads)Reads$.MODULE$.StringReads());
                                if (DataStoreRetriever$.MODULE$.logger().underlying().isErrorEnabled()) {
                                    DataStoreRetriever$.MODULE$.logger().underlying().error(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't retrieve object of type ", " (returning None)\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{className}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"oid= ", ", name='", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{oid, name}))).toString());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                option = None$.MODULE$;
                            }
                            return option;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    if (DataStoreRetriever$.MODULE$.logger().underlying().isTraceEnabled()) {
                        DataStoreRetriever$.MODULE$.logger().underlying().trace(new StringBuilder().append(resultObjectOpts.length()).append((Object)" objects found.").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    seq = resultObjectOpts;
                }
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (DataStoreRetriever$.MODULE$.logger().underlying().isWarnEnabled()) {
                        DataStoreRetriever$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)"Unable to retrieve objects sequence from server response body:\n").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request URL = ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.requestUrl$1}))).toString(), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    seq = (Seq<A>)Seq$.MODULE$.apply(Nil$.MODULE$);
                }
                catch (ConnectException connectException) {
                    BoxedUnit boxedUnit;
                    if (DataStoreRetriever$.MODULE$.logger().underlying().isWarnEnabled()) {
                        DataStoreRetriever$.MODULE$.logger().underlying().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection interrupted\\n(", ")\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.requestUrl$1})), (Throwable)connectException);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    seq = (Seq)Seq$.MODULE$.apply(Nil$.MODULE$);
                }
                return seq;
            }
            {
                this.requestUrl$1 = requestUrl$1;
                this.mappingFunction$1 = mappingFunction$1;
                this.tag$1 = tag$1;
            }
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public <T> Option<JsValue> retrieve$default$3() {
        return None$.MODULE$;
    }

    public <T> Seq<Option<T>> retrieveNow(String requestUrl, Function1<JsObject, T> mappingFct, Option<JsValue> requestBody, Duration awaitDuration, ClassTag<T> tag) {
        ((Scene)GUI$.MODULE$.stage().scene().apply()).setCursor(Cursor$.MODULE$.sfxCursor2jfx(Cursor$.MODULE$.WAIT()));
        Future<Seq<Option<T>>> futureRes = this.retrieve(requestUrl, mappingFct, requestBody, tag);
        Seq<Option<T>> result2 = Await$.MODULE$.result(futureRes, awaitDuration);
        ((Scene)GUI$.MODULE$.stage().scene().apply()).setCursor(Cursor$.MODULE$.sfxCursor2jfx(Cursor$.MODULE$.DEFAULT()));
        return result2;
    }

    public <T> Option<JsValue> retrieveNow$default$3() {
        return None$.MODULE$;
    }

    public <T> Duration retrieveNow$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(MSAngelConfigCache$.MODULE$.readTimeout())).milliseconds();
    }

    private DataStoreRetriever$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

