/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.msangel.gui.dal.cache;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.msangel.gui.dal.cache.ConversionToolConfigCache$;
import fr.profi.msangel.om.workflow.operation.ConversionToolConfig;
import fr.profi.msangel.om.workflow.operation.IFileConversionTool;
import fr.profi.msangel.om.workflow.operation.conversion.ExtractMSn$;
import fr.profi.msangel.om.workflow.operation.conversion.MsConvert$;
import fr.profi.msangel.om.workflow.operation.conversion.MsDataConverter$;
import fr.profi.msangel.om.workflow.operation.conversion.MzdbAccess$;
import fr.profi.msangel.om.workflow.operation.conversion.Raw2mzDB$;
import fr.profi.msangel.om.workflow.operation.package;
import fr.profi.util.scala.CheckResult;
import fr.profi.util.scala.CheckResult$;
import fr.profi.util.scalafx.ShowAlert$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ConversionToolConfigCache$
implements LazyLogging {
    public static final ConversionToolConfigCache$ MODULE$;
    private final Seq<ConversionToolConfig> _cache;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ConversionToolConfigCache$();
    }

    private Logger logger$lzycompute() {
        ConversionToolConfigCache$ conversionToolConfigCache$ = this;
        synchronized (conversionToolConfigCache$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Seq<ConversionToolConfig> _cache() {
        return this._cache;
    }

    public Seq<ConversionToolConfig> get() {
        return this._cache();
    }

    public Seq<ConversionToolConfig> getByFormats(Enumeration.Value inputFileFormat, Enumeration.Value outputFileForamt) {
        return (Seq)this._cache().filter((Function1<ConversionToolConfig, Object>)((Object)new Serializable(inputFileFormat, outputFileForamt){
            public static final long serialVersionUID = 0L;
            private final Enumeration.Value inputFileFormat$1;
            private final Enumeration.Value outputFileForamt$1;

            public final boolean apply(ConversionToolConfig config) {
                return Predef$.MODULE$.refArrayOps((Object[])config.getFormatMappings()).toSeq().contains(new Tuple2<Enumeration.Value, Enumeration.Value>(this.inputFileFormat$1, this.outputFileForamt$1));
            }
            {
                this.inputFileFormat$1 = inputFileFormat$1;
                this.outputFileForamt$1 = outputFileForamt$1;
            }
        }));
    }

    public Option<ConversionToolConfig> getByName(Enumeration.Value name) {
        return this._cache().find((Function1<ConversionToolConfig, Object>)((Object)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final Enumeration.Value name$1;

            public final boolean apply(ConversionToolConfig x$2) {
                Enumeration.Value value = x$2.tool();
                Enumeration.Value value2 = this.name$1;
                return !(value != null ? !((Object)value).equals(value2) : value2 != null);
            }
            {
                this.name$1 = name$1;
            }
        }));
    }

    public CheckResult compareVersion(package.FileConversion conversion, boolean showAlert) {
        ConversionToolConfig config = conversion.config();
        Enumeration.Value toolName = config.tool();
        Option versionOptInClone = config.toolVersion();
        Option<String> latestVersionOpt = this.getByName(toolName).flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(ConversionToolConfig x$3) {
                return x$3.toolVersion();
            }
        });
        CheckResult result = new CheckResult(new Some<Integer>(BoxesRunTime.boxToInteger(1)), CheckResult$.MODULE$.$lessinit$greater$default$2());
        Option option = versionOptInClone;
        Option<String> option2 = latestVersionOpt;
        if (option == null ? option2 != null : !option.equals(option2)) {
            Enumeration.Value inputFormat = conversion.inputFileFormat();
            Enumeration.Value ouputFormat = conversion.outputFileFormat();
            String errorMsg = new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nThe options for the file conversion from ", " to ", " fit ", " in version ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputFormat, ouputFormat, toolName, versionOptInClone.getOrElse(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "<unknown>";
                }
            })}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which is not the latest (", ").\\n\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{latestVersionOpt.getOrElse(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "<unknown>";
                }
            })}))).toString();
            result.addError(errorMsg);
            if (showAlert) {
                ShowAlert$.MODULE$.warning(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " -> ", " conversion not using latest version"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputFormat, ouputFormat})), new StringBuilder().append((Object)"WARNING:").append((Object)errorMsg).append((Object)"You are STRONGLY RECOMMENED to delete this conversion from the workflow (click on the icon figuring a trash), then design it again to assess the new conversion options.\n").append((Object)"Click 'Options...' near conversion tool choice to open its configuration window.\n\n").append((Object)"Neglecting this warning may lead to file conversion errors.").toString(), ShowAlert$.MODULE$.warning$default$3(), ShowAlert$.MODULE$.warning$default$4(), ShowAlert$.MODULE$.warning$default$5(), ShowAlert$.MODULE$.warning$default$6(), ShowAlert$.MODULE$.warning$default$7());
            }
        }
        return result;
    }

    public boolean compareVersion$default$2() {
        return true;
    }

    private ConversionToolConfigCache$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this._cache = ((TraversableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new IFileConversionTool[]{Raw2mzDB$.MODULE$, MzdbAccess$.MODULE$, ExtractMSn$.MODULE$, MsConvert$.MODULE$, MsDataConverter$.MODULE$}))).map(new anonfun.1(), Seq$.MODULE$.canBuildFrom());
    }
}

