/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.msangel.gui.dal.cache;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.msangel.gui.om.MSAngelConfig;
import fr.profi.msangel.gui.om.MSAngelConfig$;
import java.io.File;
import java.io.FileWriter;
import java.net.URLDecoder;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class MSAngelConfigCache$
implements LazyLogging {
    public static final MSAngelConfigCache$ MODULE$;
    private ClassLoader classLoader;
    private final String path;
    private final String decodedPath;
    private final String extConfFilePath;
    private final File externalConfFile;
    private MSAngelConfig _configCache;
    private Config _appConfParams;
    private final Logger logger;
    private volatile byte bitmap$0;

    static {
        new MSAngelConfigCache$();
    }

    private ClassLoader classLoader$lzycompute() {
        MSAngelConfigCache$ mSAngelConfigCache$ = this;
        synchronized (mSAngelConfigCache$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.classLoader = this.getClass().getClassLoader();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.classLoader;
        }
    }

    private Logger logger$lzycompute() {
        MSAngelConfigCache$ mSAngelConfigCache$ = this;
        synchronized (mSAngelConfigCache$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public ClassLoader classLoader() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.classLoader$lzycompute() : this.classLoader;
    }

    public String path() {
        return this.path;
    }

    public String decodedPath() {
        return this.decodedPath;
    }

    public String extConfFilePath() {
        return this.extConfFilePath;
    }

    public File externalConfFile() {
        return this.externalConfFile;
    }

    private MSAngelConfig _configCache() {
        return this._configCache;
    }

    private void _configCache_$eq(MSAngelConfig x$1) {
        this._configCache = x$1;
    }

    private Config _appConfParams() {
        return this._appConfParams;
    }

    private void _appConfParams_$eq(Config x$1) {
        this._appConfParams = x$1;
    }

    public String prolineUrl() {
        return this._configCache().prolineConfig().url();
    }

    public String pwxMSAngelUrl() {
        return new StringBuilder().append((Object)this.prolineUrl()).append((Object)"/PWX/msangel").toString();
    }

    public String fakeMascotUrl() {
        return this._configCache().prolineConfig().fakeMascotServerUrl();
    }

    public String mascotUrl() {
        return this._configCache().mascotConfig().url();
    }

    public int readTimeout() {
        return this._configCache().timerConfig().httpReadTimeout();
    }

    public int connTimeout() {
        return this._configCache().timerConfig().httpConnTimeout();
    }

    public int autoRefresh() {
        return this._configCache().timerConfig().autoRefresh();
    }

    public String inputFilesDir() {
        return this._configCache().inputFilesDir();
    }

    public String createdMgfFilesDir() {
        return this._configCache().createdMgfFilesDir();
    }

    public String createdMzdbFilesDir() {
        return this._configCache().createdMzdbFilesDir();
    }

    public String parFilesDir() {
        return this._configCache().parFilesDir();
    }

    public MSAngelConfig get() {
        return this._configCache();
    }

    public void createConfigCache() {
        this._configCache_$eq(this.getUpdatedConfig());
    }

    public void updateConfig(Config newConfig) {
        block9: {
            this.setConfigParams(newConfig);
            try {
                try {
                    MSAngelConfigCache$ mSAngelConfigCache$ = this;
                    synchronized (mSAngelConfigCache$) {
                        ConfigRenderOptions renderOptions = ConfigRenderOptions.concise().setComments(true).setFormatted(true).setJson(false);
                        String render = newConfig.root().render(renderOptions);
                        FileWriter fileWriter = new FileWriter(this.externalConfFile());
                        fileWriter.write(render);
                        fileWriter.close();
                    }
                }
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Can't save settings in application.conf : ", new Object[]{exception.getMessage()});
                        boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                this.createConfigCache();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Config getConfigParams() {
        BoxedUnit boxedUnit;
        if (this._appConfParams() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return this._appConfParams();
        }
        MSAngelConfigCache$ mSAngelConfigCache$ = this;
        synchronized (mSAngelConfigCache$) {
            this._appConfParams_$eq(ConfigFactory.parseFile((File)this.externalConfFile()));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : mSAngelConfigCache$
            boxedUnit = boxedUnit2;
            return this._appConfParams();
        }
    }

    public synchronized void setConfigParams(Config newConfig) {
        this._appConfParams_$eq(newConfig);
    }

    public MSAngelConfig getUpdatedConfig() {
        return MSAngelConfig$.MODULE$.apply(this.getConfigParams());
    }

    private MSAngelConfigCache$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        this.decodedPath = URLDecoder.decode(this.path(), "UTF-8").replaceAll("\\\\", "/");
        this.extConfFilePath = new StringBuilder().append((Object)this.decodedPath()).append((Object)"/../config/application.conf").toString();
        this.externalConfFile = new File(this.extConfFilePath());
        this._appConfParams = null;
    }
}

