/*
 * Decompiled with CFR 0.152.
 */
package play.http;

import javax.inject.Inject;
import javax.inject.Provider;
import play.Configuration;
import play.Environment;
import play.Logger;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.HttpErrorHandlerExceptions;
import play.api.routing.Router;
import play.http.HttpErrorHandler;
import play.libs.F;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;
import scala.Option;
import scala.Some;
import views.html.defaultpages.badRequest;
import views.html.defaultpages.devError;
import views.html.defaultpages.devNotFound;
import views.html.defaultpages.error;
import views.html.defaultpages.notFound;
import views.html.defaultpages.unauthorized;

public class DefaultHttpErrorHandler
implements HttpErrorHandler {
    private final Option<String> playEditor;
    private final Environment environment;
    private final OptionalSourceMapper sourceMapper;
    private final Provider<Router> routes;

    @Inject
    public DefaultHttpErrorHandler(Configuration configuration, Environment environment, OptionalSourceMapper optionalSourceMapper, Provider<Router> provider) {
        this.environment = environment;
        this.sourceMapper = optionalSourceMapper;
        this.routes = provider;
        this.playEditor = Option.apply((Object)configuration.getString("play.editor"));
    }

    @Override
    public F.Promise<Result> onClientError(Http.RequestHeader requestHeader, int n, String string) {
        if (n == 400) {
            return this.onBadRequest(requestHeader, string);
        }
        if (n == 403) {
            return this.onForbidden(requestHeader, string);
        }
        if (n == 404) {
            return this.onNotFound(requestHeader, string);
        }
        if (n >= 400 && n < 500) {
            return this.onOtherClientError(requestHeader, n, string);
        }
        throw new IllegalArgumentException("onClientError invoked with non client error status code " + n + ": " + string);
    }

    protected F.Promise<Result> onBadRequest(Http.RequestHeader requestHeader, String string) {
        return F.Promise.pure(Results.badRequest((Content)badRequest.render(requestHeader.method(), requestHeader.uri(), string)));
    }

    protected F.Promise<Result> onForbidden(Http.RequestHeader requestHeader, String string) {
        return F.Promise.pure(Results.forbidden((Content)unauthorized.render()));
    }

    protected F.Promise<Result> onNotFound(Http.RequestHeader requestHeader, String string) {
        if (this.environment.isProd()) {
            return F.Promise.pure(Results.notFound((Content)notFound.render(requestHeader.method(), requestHeader.uri())));
        }
        return F.Promise.pure(Results.notFound((Content)devNotFound.render(requestHeader.method(), requestHeader.uri(), (Option<Router>)Some.apply((Object)this.routes.get()))));
    }

    protected F.Promise<Result> onOtherClientError(Http.RequestHeader requestHeader, int n, String string) {
        return F.Promise.pure(Results.status(n, (Content)badRequest.render(requestHeader.method(), requestHeader.uri(), string)));
    }

    @Override
    public F.Promise<Result> onServerError(Http.RequestHeader requestHeader, Throwable throwable) {
        try {
            UsefulException usefulException = this.throwableToUsefulException(throwable);
            this.logServerError(requestHeader, usefulException);
            switch (this.environment.mode()) {
                case PROD: {
                    return this.onProdServerError(requestHeader, usefulException);
                }
            }
            return this.onDevServerError(requestHeader, usefulException);
        }
        catch (Exception exception) {
            Logger.error("Error while handling error", exception);
            return F.Promise.pure(Results.internalServerError());
        }
    }

    protected void logServerError(Http.RequestHeader requestHeader, UsefulException usefulException) {
        Logger.error(String.format("\n\n! @%s - Internal server error, for (%s) [%s] ->\n", usefulException.id, requestHeader.method(), requestHeader.uri()), (Throwable)usefulException);
    }

    private UsefulException throwableToUsefulException(Throwable throwable) {
        return HttpErrorHandlerExceptions.throwableToUsefulException(this.sourceMapper.sourceMapper(), this.environment.isProd(), throwable);
    }

    protected F.Promise<Result> onDevServerError(Http.RequestHeader requestHeader, UsefulException usefulException) {
        return F.Promise.pure(Results.internalServerError((Content)devError.render(this.playEditor, usefulException)));
    }

    protected F.Promise<Result> onProdServerError(Http.RequestHeader requestHeader, UsefulException usefulException) {
        return F.Promise.pure(Results.internalServerError((Content)error.render(usefulException)));
    }
}

