/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.concurrent;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import scala.Option;
import scala.Predef$;
import scala.collection.AbstractIterable;
import scala.collection.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.Queue;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-f!B\u0001\u0003\u0003\u0003Y!aE\"p]\u000e,(O]3oiN\u000bg-Z)vKV,'BA\u0002\u0005\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u000b\u0019\tA!\u001e;jY*\u0011q\u0001C\u0001\u0006aJ|g-\u001b\u0006\u0002\u0013\u0005\u0011aM]\u0002\u0001+\taAeE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u001c\u001b\u0005)\"B\u0001\f\u0018\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tA\u0012$\u0001\u0005usB,7/\u00194f\u0015\u0005Q\u0012aA2p[&\u0011A$\u0006\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0003\u001f\u0001\u0011\u0005q$\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0019\u0011\u0005\u0001\u0012\u000e\u0003\t\u0001\"a\t\u0013\r\u0001\u0011)Q\u0005\u0001b\u0001M\t\tA+\u0005\u0002(UA\u0011a\u0002K\u0005\u0003S=\u0011qAT8uQ&tw\r\u0005\u0002\u000fW%\u0011Af\u0004\u0002\u0004\u0003:L\b\"\u0002\u0018\u0001\r\u0003y\u0013!\u00069sS>\u0014\u0018\u000e^=Rk\u0016,Xm\u0014:eKJLgnZ\u000b\u0002aA\u0019a\"M\u001a\n\u0005Iz!AB(qi&|g\u000eE\u00025y\tr!!\u000e\u001e\u000f\u0005YJT\"A\u001c\u000b\u0005aR\u0011A\u0002\u001fs_>$h(C\u0001\u0011\u0013\tYt\"A\u0004qC\u000e\\\u0017mZ3\n\u0005ur$\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0005mzaa\u0002!\u0001!\u0003\r\n\"\u0011\u0002\u0011\u0013:$XM\u001d8bYF+X-^3PaN,\"AQ$\u0014\u0005}j\u0001\"\u0002#@\r\u0003)\u0015a\u00023fcV,W/\u001a\u000b\u0002\rB\u00111e\u0012\u0003\u0006K}\u0012\rA\n\u0005\u0006\u0013~2\tAS\u0001\bK:\fX/Z;f)\tYe\n\u0005\u0002\u000f\u0019&\u0011Qj\u0004\u0002\u0005+:LG\u000fC\u0003P\u0011\u0002\u0007\u0001+A\u0003fY\u0016l7\u000fE\u0002\u000f#\u001aK!AU\b\u0003\u0015q\u0012X\r]3bi\u0016$gH\u0002\u0003U\u0001!)&!F%oi\u0016\u0014h.\u00197Qe&|'/\u001b;z#V,W/Z\u000b\u0003-\u0002\u001c2aU,b!\rAVlX\u0007\u00023*\u0011!lW\u0001\b[V$\u0018M\u00197f\u0015\tav\"\u0001\u0006d_2dWm\u0019;j_:L!AX-\u0003\u001bA\u0013\u0018n\u001c:jif\fV/Z;f!\t\u0019\u0003\rB\u0003&'\n\u0007a\u0005E\u0002c\u007f}k\u0011\u0001\u0001\u0005\nIN\u0013\t\u0011)A\u0006K\u001a\f1a\u001c:e!\r!DhX\u0005\u0003IvCQAH*\u0005\u0002!$\u0012!\u001b\u000b\u0003U.\u00042AY*`\u0011\u0015!w\rq\u0001f\r\u0011i\u0007\u0001\u00038\u0003\u001b%sG/\u001a:oC2\fV/Z;f+\tyGoE\u0002maV\u00042\u0001W9t\u0013\t\u0011\u0018LA\u0003Rk\u0016,X\r\u0005\u0002$i\u0012)Q\u0005\u001cb\u0001MA\u0019!mP:\t\u000byaG\u0011A<\u0015\u0003a\u00042A\u00197t\u0011\u0015Q\bA\"\u0001|\u0003\u001di\u0017\r_*ju\u0016,\u0012\u0001 \t\u0004\u001dEj\bC\u0001\b\u007f\u0013\tyxBA\u0002J]RD\u0011\"a\u0001\u0001\u0001\u0004%I!!\u0002\u0002\u0013%\u001c8\u000b^8qa\u0016$WCAA\u0004!\rq\u0011\u0011B\u0005\u0004\u0003\u0017y!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0005\u0003#\tQ\"[:Ti>\u0004\b/\u001a3`I\u0015\fHcA&\u0002\u0014!Q\u0011QCA\u0007\u0003\u0003\u0005\r!a\u0002\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0015BA\u0004\u0003)I7o\u0015;paB,G\r\t\u0005\u000b\u0003;\u0001\u0001R1A\u0005\u0012\u0005}\u0011!D5oi\u0016\u0014h.\u00197Rk\u0016,X-\u0006\u0002\u0002\"Iq\u00111EA\u0014\u0003[\t)$a\u0013\u0002^\u0005\rdABA\u0013\u0001\u0001\t\tC\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0003Y\u0003S\u0011\u0013bAA\u00163\nA\u0011\n^3sC\ndW\rE\u0003\u00020\u0005E\"%D\u0001\\\u0013\r\t\u0019d\u0017\u0002\u0011\u0003\n\u001cHO]1di&#XM]1cY\u0016\u0004b\u0001WA\u001cE\u0005m\u0012bAA\u001d3\n9!)^5mI\u0016\u0014(\u0003DA\u001f\u0003O\ti#a\u0010\u0002L\u0005ucABA\u0013\u0001\u0001\tY\u0004\u0005\u0004Y\u0003o\u0011\u0013\u0011\t\n\r\u0003\u0007\n9#!\f\u0002F\u0005-\u0013Q\f\u0004\u0007\u0003K\u0001\u0001!!\u0011\u0011\ra\u000b9DIA$%1\tI%a\n\u0002.\u0005-\u0013\u0011KA/\r\u0019\t)\u0003\u0001\u0001\u0002HA\u0019a\"!\u0014\n\u0007\u0005=sBA\u0005DY>tW-\u00192mKB)\u00111KA-E5\u0011\u0011Q\u000b\u0006\u0004\u0003/Z\u0016aB4f]\u0016\u0014\u0018nY\u0005\u0005\u00037\n)F\u0001\u0005He><\u0018M\u00197f!\rq\u0011qL\u0005\u0004\u0003Cz!\u0001D*fe&\fG.\u001b>bE2,\u0007c\u00012@E!Q\u0011q\r\u0001\t\u0002\u0003\u0006K!!\t\u0002\u001d%tG/\u001a:oC2\fV/Z;fA!9\u00111\u000e\u0001\u0005\u0002\u00055\u0014!B2mK\u0006\u0014H#A&\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u0005Q\u0001.Y:F]R\u0014\u0018.Z:\u0015\u0005\u0005\u001d\u0001bBA<\u0001\u0011\u0005\u0011QN\u0001\u0005gR|\u0007\u000f\u0003\u0004E\u0001\u0011\u0005\u00111\u0010\u000b\u0002E!1\u0011\n\u0001C\u0001\u0003\u007f\"2aSAA\u0011\u001d\t\u0019)! A\u0002\t\n!\"];fk\u0016,e\u000e\u001e:z\u0011%\t9\t\u0001b\u0001\n#\tI)\u0001\bfq\u000e,\u0007\u000f^5p]F+X-^3\u0016\u0005\u0005-\u0005\u0003\u0002-r\u0003\u001b\u00032\u0001NAH\u0013\r\t\tJ\u0010\u0002\n)\"\u0014xn^1cY\u0016D\u0001\"!&\u0001A\u0003%\u00111R\u0001\u0010Kb\u001cW\r\u001d;j_:\fV/Z;fA!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005M\u0014!\u00045bg\u0016C8-\u001a9uS>t7\u000fC\u0004\u0002\u001e\u0002!\t!a(\u0002!\u0011,\u0017/^3vK\u0016C8-\u001a9uS>tGCAAG\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003K\u000b\u0001#\u001a8rk\u0016,X-\u0012=dKB$\u0018n\u001c8\u0015\u0007-\u000b9\u000b\u0003\u0005\u0002*\u0006\u0005\u0006\u0019AAG\u0003\u0005!\b")
public abstract class ConcurrentSafeQueue<T>
implements LazyLogging {
    private boolean isStopped;
    private Iterable<T> internalQueue;
    private final Queue<Throwable> exceptionQueue;
    private final Logger logger;
    private volatile byte bitmap$0;

    private AbstractIterable internalQueue$lzycompute() {
        ConcurrentSafeQueue concurrentSafeQueue = this;
        synchronized (concurrentSafeQueue) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.internalQueue = this.priorityQueueOrdering().isDefined() ? new InternalPriorityQueue(this, (Ordering)this.priorityQueueOrdering().get()) : new InternalQueue(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.internalQueue;
        }
    }

    private Logger logger$lzycompute() {
        ConcurrentSafeQueue concurrentSafeQueue = this;
        synchronized (concurrentSafeQueue) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public abstract Option<Ordering<T>> priorityQueueOrdering();

    public abstract Option<Object> maxSize();

    private boolean isStopped() {
        return this.isStopped;
    }

    private void isStopped_$eq(boolean x$1) {
        this.isStopped = x$1;
    }

    public Iterable<T> internalQueue() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.internalQueue$lzycompute() : this.internalQueue;
    }

    public void clear() {
        ((Builder)this.internalQueue()).clear();
    }

    public boolean hasEntries() {
        return !this.internalQueue().isEmpty();
    }

    public synchronized void stop() {
        this.isStopped_$eq(true);
    }

    public T dequeue() {
        AbstractIterable abstractIterable = this.internalQueue();
        synchronized (abstractIterable) {
            if (this.isStopped()) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                return null;
            }
            while (this.internalQueue().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Waiting for new entries in the queue...");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.internalQueue().wait();
            }
            this.internalQueue().notifyAll();
            Object t = ((InternalQueueOps)this.internalQueue()).dequeue();
            return t;
        }
    }

    public void enqueue(T queueEntry) {
        AbstractIterable abstractIterable = this.internalQueue();
        synchronized (abstractIterable) {
            if (this.isStopped()) {
                return;
            }
            if (this.maxSize().isDefined()) {
                int size = BoxesRunTime.unboxToInt((Object)this.maxSize().get());
                while (this.internalQueue().size() >= size) {
                    this.internalQueue().wait();
                }
            }
            this.internalQueue().notifyAll();
            ((InternalQueueOps)this.internalQueue()).enqueue(Predef$.MODULE$.genericWrapArray((Object)new Object[]{queueEntry}));
            return;
        }
    }

    public Queue<Throwable> exceptionQueue() {
        return this.exceptionQueue;
    }

    public boolean hasExceptions() {
        return !this.exceptionQueue().isEmpty();
    }

    public Throwable dequeueException() {
        Queue<Throwable> queue = this.exceptionQueue();
        synchronized (queue) {
            while (this.exceptionQueue().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Watching for new exception in the queue...");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.exceptionQueue().wait();
            }
            this.exceptionQueue().notifyAll();
            Object object = this.exceptionQueue().dequeue();
            return (Throwable)object;
        }
    }

    public void enqueueException(Throwable t) {
        Queue<Throwable> queue = this.exceptionQueue();
        synchronized (queue) {
            this.exceptionQueue().notifyAll();
            this.exceptionQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{t}));
            return;
        }
    }

    public ConcurrentSafeQueue() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.isStopped = false;
        this.exceptionQueue = new Queue();
    }

    public static class InternalQueue<T>
    extends Queue<T>
    implements InternalQueueOps<T> {
        public final /* synthetic */ ConcurrentSafeQueue $outer;

        public /* synthetic */ ConcurrentSafeQueue fr$profi$util$concurrent$ConcurrentSafeQueue$InternalQueue$$$outer() {
            return this.$outer;
        }

        public InternalQueue(ConcurrentSafeQueue<T> $outer) {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public interface InternalQueueOps<T> {
        public T dequeue();

        public void enqueue(Seq<T> var1);
    }

    public static class InternalPriorityQueue<T>
    extends PriorityQueue<T>
    implements InternalQueueOps<T> {
        public final /* synthetic */ ConcurrentSafeQueue $outer;

        public /* synthetic */ ConcurrentSafeQueue fr$profi$util$concurrent$ConcurrentSafeQueue$InternalPriorityQueue$$$outer() {
            return this.$outer;
        }

        public InternalPriorityQueue(ConcurrentSafeQueue<T> $outer, Ordering<T> ord) {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(ord);
        }
    }
}

