/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.math;

import fr.profi.util.math.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.math.Fractional;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public float filteredMean(float[] s) {
        float[] defS = (float[])Predef$.MODULE$.floatArrayOps(s).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(float x$1) {
                return this.apply$mcZF$sp(x$1);
            }

            public boolean apply$mcZF$sp(float x$1) {
                return !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$1);
            }
        });
        return Predef$.MODULE$.floatArrayOps(defS).isEmpty() ? Float.NaN : BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(defS).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)defS.length;
    }

    public float filteredMedian(float[] s) {
        float[] defS = (float[])Predef$.MODULE$.floatArrayOps(s).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(float x$2) {
                return this.apply$mcZF$sp(x$2);
            }

            public boolean apply$mcZF$sp(float x$2) {
                return !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$2);
            }
        });
        return Predef$.MODULE$.floatArrayOps(defS).isEmpty() ? Float.NaN : BoxesRunTime.unboxToFloat(this.median((Seq)Predef$.MODULE$.wrapFloatArray(defS), (Fractional)Numeric.FloatIsFractional$.MODULE$));
    }

    public double filteredMean(double[] s) {
        double[] defS = (double[])Predef$.MODULE$.doubleArrayOps(s).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$3) {
                return this.apply$mcZD$sp(x$3);
            }

            public boolean apply$mcZD$sp(double x$3) {
                return !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$3);
            }
        });
        return Predef$.MODULE$.doubleArrayOps(defS).isEmpty() ? Double.NaN : BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(defS).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)defS.length;
    }

    public double filteredMedian(double[] s) {
        double[] defS = (double[])Predef$.MODULE$.doubleArrayOps(s).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$4) {
                return this.apply$mcZD$sp(x$4);
            }

            public boolean apply$mcZD$sp(double x$4) {
                return !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$4);
            }
        });
        return Predef$.MODULE$.doubleArrayOps(defS).isEmpty() ? Double.NaN : BoxesRunTime.unboxToDouble(this.median((Seq)Predef$.MODULE$.wrapDoubleArray(defS), (Fractional)Numeric.DoubleIsFractional$.MODULE$));
    }

    public <T> T median(Seq<T> s, Fractional<T> n) {
        Tuple2 tuple2 = ((TraversableLike)s.sortBy((Function1)new anonfun.5(), n)).splitAt(s.size() / 2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq lower = (Seq)tuple2._1();
            Seq upper = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)lower, (Object)upper);
            Seq lower2 = (Seq)tuple23._1();
            Seq upper2 = (Seq)tuple23._2();
            return (T)(s.size() % 2 == 0 ? n.mkNumericOps(n.mkNumericOps(lower2.last()).$plus(upper2.head())).$div(n.fromInt(2)) : upper2.head());
        }
        throw new MatchError((Object)tuple2);
    }

    public <T> T getMedianObject(Seq<T> objects, Function2<T, T, Object> sortingFunc) {
        Seq sortedObjects = (Seq)objects.sortWith((Function2)new Serializable(sortingFunc){
            public static final long serialVersionUID = 0L;
            private final Function2 sortingFunc$1;

            public final boolean apply(T a, T b) {
                return BoxesRunTime.unboxToBoolean((Object)this.sortingFunc$1.apply(a, b));
            }
            {
                this.sortingFunc$1 = sortingFunc$1;
            }
        });
        int nbObjects = sortedObjects.length();
        int medianIndex = 0;
        medianIndex = nbObjects % 2 == 0 ? nbObjects / 2 : (nbObjects - 1) / 2;
        return (T)sortedObjects.apply(medianIndex);
    }

    public Tuple2<Object, Object> calcLineParams(double x1, double y1, double x2, double y2) {
        double deltaX = x2 - x1;
        Predef$.MODULE$.require(deltaX != 0.0, (Function0)new Serializable(x1){
            public static final long serialVersionUID = 0L;
            private final double x1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"can't solve line parameters with two identical x values (").append((Object)BoxesRunTime.boxToDouble((double)this.x1$1)).append((Object)")").toString();
            }
            {
                this.x1$1 = x1$1;
            }
        });
        double slope = (y2 - y1) / deltaX;
        double intercept = y1 - slope * x1;
        return new Tuple2.mcDD.sp(slope, intercept);
    }

    public double linearInterpolation(double xValue, Seq<Tuple2<Object, Object>> xyValues, boolean fixOutOfRange) {
        Tuple2 tuple2;
        block9: {
            Tuple2 tuple22;
            block10: {
                Tuple2<Object, Object> tuple23;
                block12: {
                    double d;
                    block7: {
                        Tuple2.mcDD.sp sp2;
                        double y2;
                        double x2;
                        double y1;
                        double x1;
                        block11: {
                            Tuple2.mcDD.sp sp3;
                            Tuple2.mcDD.sp sp4;
                            int index;
                            block8: {
                                block6: {
                                    index = xyValues.indexWhere((Function1)new Serializable(xValue){
                                        public static final long serialVersionUID = 0L;
                                        private final double xValue$1;

                                        public final boolean apply(Tuple2<Object, Object> x$9) {
                                            return x$9._1$mcD$sp() >= this.xValue$1;
                                        }
                                        {
                                            this.xValue$1 = xValue$1;
                                        }
                                    });
                                    if (index == -1) {
                                        if (fixOutOfRange) {
                                            index = xValue < ((Tuple2)xyValues.head())._1$mcD$sp() ? 0 : -1;
                                        } else {
                                            throw new IllegalArgumentException("index is out of range");
                                        }
                                    }
                                    if (index != 0) break block6;
                                    d = ((Tuple2)xyValues.head())._2$mcD$sp();
                                    break block7;
                                }
                                if (index != -1) break block8;
                                d = ((Tuple2)xyValues.last())._2$mcD$sp();
                                break block7;
                            }
                            tuple2 = (Tuple2)xyValues.apply(index - 1);
                            if (tuple2 == null) break block9;
                            double x12 = tuple2._1$mcD$sp();
                            double y12 = tuple2._2$mcD$sp();
                            Tuple2.mcDD.sp sp5 = sp4 = new Tuple2.mcDD.sp(x12, y12);
                            x1 = sp5._1$mcD$sp();
                            y1 = sp5._2$mcD$sp();
                            tuple22 = (Tuple2)xyValues.apply(index);
                            if (tuple22 == null) break block10;
                            double x22 = tuple22._1$mcD$sp();
                            double y22 = tuple22._2$mcD$sp();
                            Tuple2.mcDD.sp sp6 = sp3 = new Tuple2.mcDD.sp(x22, y22);
                            x2 = sp6._1$mcD$sp();
                            y2 = sp6._2$mcD$sp();
                            if (x1 != x2) break block11;
                            d = (y1 + y2) / (double)2;
                            break block7;
                        }
                        tuple23 = this.calcLineParams(x1, y1, x2, y2);
                        if (tuple23 == null) break block12;
                        double a = tuple23._1$mcD$sp();
                        double b = tuple23._2$mcD$sp();
                        Tuple2.mcDD.sp sp7 = sp2 = new Tuple2.mcDD.sp(a, b);
                        double a2 = sp7._1$mcD$sp();
                        double b2 = sp7._2$mcD$sp();
                        d = a2 * xValue + b2;
                    }
                    return d;
                }
                throw new MatchError(tuple23);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    public double linearInterpolation(double xValue, Seq<Tuple2<Object, Object>> xyValues) {
        return this.linearInterpolation(xValue, xyValues, true);
    }

    public float linearInterpolation(float xValue, Seq<Tuple2<Object, Object>> xyValues, boolean fixOutOfRange) {
        Tuple2 tuple2;
        block9: {
            Tuple2 tuple22;
            block10: {
                Tuple2<Object, Object> tuple23;
                block12: {
                    float f;
                    block7: {
                        Tuple2.mcDD.sp sp2;
                        float y2;
                        float x2;
                        float y1;
                        float x1;
                        block11: {
                            Tuple2 tuple24;
                            Tuple2 tuple25;
                            int index;
                            block8: {
                                block6: {
                                    index = xyValues.indexWhere((Function1)new Serializable(xValue){
                                        public static final long serialVersionUID = 0L;
                                        private final float xValue$2;

                                        public final boolean apply(Tuple2<Object, Object> x$13) {
                                            return BoxesRunTime.unboxToFloat((Object)x$13._1()) >= this.xValue$2;
                                        }
                                        {
                                            this.xValue$2 = xValue$2;
                                        }
                                    });
                                    if (index == -1) {
                                        if (fixOutOfRange) {
                                            index = xValue < BoxesRunTime.unboxToFloat((Object)((Tuple2)xyValues.head())._1()) ? 0 : -1;
                                        } else {
                                            throw new IllegalArgumentException("index is out of range");
                                        }
                                    }
                                    if (index != 0) break block6;
                                    f = BoxesRunTime.unboxToFloat((Object)((Tuple2)xyValues.head())._2());
                                    break block7;
                                }
                                if (index != -1) break block8;
                                f = BoxesRunTime.unboxToFloat((Object)((Tuple2)xyValues.last())._2());
                                break block7;
                            }
                            tuple2 = (Tuple2)xyValues.apply(index - 1);
                            if (tuple2 == null) break block9;
                            float x12 = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                            float y12 = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                            Tuple2 tuple26 = tuple25 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)x12), (Object)BoxesRunTime.boxToFloat((float)y12));
                            x1 = BoxesRunTime.unboxToFloat((Object)tuple26._1());
                            y1 = BoxesRunTime.unboxToFloat((Object)tuple26._2());
                            tuple22 = (Tuple2)xyValues.apply(index);
                            if (tuple22 == null) break block10;
                            float x22 = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                            float y22 = BoxesRunTime.unboxToFloat((Object)tuple22._2());
                            Tuple2 tuple27 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)x22), (Object)BoxesRunTime.boxToFloat((float)y22));
                            x2 = BoxesRunTime.unboxToFloat((Object)tuple27._1());
                            y2 = BoxesRunTime.unboxToFloat((Object)tuple27._2());
                            if (x1 != x2) break block11;
                            f = (y1 + y2) / (float)2;
                            break block7;
                        }
                        tuple23 = this.calcLineParams(x1, y1, x2, y2);
                        if (tuple23 == null) break block12;
                        double a = tuple23._1$mcD$sp();
                        double b = tuple23._2$mcD$sp();
                        Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(a, b);
                        double a2 = sp3._1$mcD$sp();
                        double b2 = sp3._2$mcD$sp();
                        f = (float)(a2 * (double)xValue + b2);
                    }
                    return f;
                }
                throw new MatchError(tuple23);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    public float linearInterpolation(float xValue, Seq<Tuple2<Object, Object>> xyValues) {
        return this.linearInterpolation(xValue, xyValues, true);
    }

    private package$() {
        MODULE$ = this;
    }
}

