/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.primitives;

import fr.profi.util.StringUtils;
import fr.profi.util.primitives.package$DataType$;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static final package$ MODULE$;
    private final Pattern datePattern;
    private final Pattern dateTimePattern;
    private final SimpleDateFormat localDateFormat;
    private final SimpleDateFormat localDateTimeFormat;

    static {
        new package$();
    }

    private Pattern datePattern() {
        return this.datePattern;
    }

    private Pattern dateTimePattern() {
        return this.dateTimePattern;
    }

    private SimpleDateFormat newDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    private SimpleDateFormat newDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    private SimpleDateFormat localDateFormat() {
        return this.localDateFormat;
    }

    private SimpleDateFormat localDateTimeFormat() {
        return this.localDateTimeFormat;
    }

    public boolean isZeroOrNaN(float value) {
        return Predef$.MODULE$.float2Float(value).isNaN() || value == 0.0f;
    }

    public boolean isZeroOrNaN(double value) {
        return Predef$.MODULE$.double2Double(value).isNaN() || value == 0.0;
    }

    public boolean toBoolean(Object value) {
        block5: {
            boolean bl;
            block3: {
                Object object;
                block4: {
                    block2: {
                        boolean bl2;
                        object = value;
                        if (!(object instanceof Boolean)) break block2;
                        bl = bl2 = BoxesRunTime.unboxToBoolean((Object)object);
                        break block3;
                    }
                    if (!(object instanceof Boolean)) break block4;
                    Boolean bl3 = (Boolean)object;
                    bl = bl3;
                    break block3;
                }
                if (!(object instanceof String)) break block5;
                String string = (String)object;
                bl = Boolean.parseBoolean(this.normalizeString(string));
            }
            return bl;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Type of value is ").append((Object)this.getTypeAsString(value)).append((Object)" not boolean").toString());
    }

    public int toInt(Object value) {
        block5: {
            int n;
            block3: {
                Object object;
                block4: {
                    block2: {
                        int n2;
                        object = value;
                        if (!(object instanceof Integer)) break block2;
                        n = n2 = BoxesRunTime.unboxToInt((Object)object);
                        break block3;
                    }
                    if (!(object instanceof Number)) break block4;
                    Number number = (Number)object;
                    n = this.checkInt(number.longValue());
                    break block3;
                }
                if (!(object instanceof String)) break block5;
                String string = (String)object;
                n = this.checkInt(Long.parseLong(this.normalizeString(string)));
            }
            return n;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Type of value is ").append((Object)this.getTypeAsString(value)).append((Object)" not integer").toString());
    }

    public long toLong(Object value) {
        block5: {
            long l;
            block3: {
                Object object;
                block4: {
                    block2: {
                        long l2;
                        object = value;
                        if (!(object instanceof Long)) break block2;
                        l = l2 = BoxesRunTime.unboxToLong((Object)object);
                        break block3;
                    }
                    if (!(object instanceof Number)) break block4;
                    Number number = (Number)object;
                    l = number.longValue();
                    break block3;
                }
                if (!(object instanceof String)) break block5;
                String string = (String)object;
                l = Long.parseLong(this.normalizeString(string));
            }
            return l;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Type of value is ").append((Object)this.getTypeAsString(value)).append((Object)" not long").toString());
    }

    public float toFloat(Object value) {
        block5: {
            float f;
            block3: {
                Object object;
                block4: {
                    block2: {
                        float f2;
                        object = value;
                        if (!(object instanceof Float)) break block2;
                        f = f2 = BoxesRunTime.unboxToFloat((Object)object);
                        break block3;
                    }
                    if (!(object instanceof Number)) break block4;
                    Number number = (Number)object;
                    f = number.floatValue();
                    break block3;
                }
                if (!(object instanceof String)) break block5;
                String string = (String)object;
                f = Float.parseFloat(this.normalizeString(string));
            }
            return f;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Type of value is ").append((Object)this.getTypeAsString(value)).append((Object)" not float").toString());
    }

    public double toDouble(Object value) {
        block5: {
            double d;
            block3: {
                Object object;
                block4: {
                    block2: {
                        double d2;
                        object = value;
                        if (!(object instanceof Double)) break block2;
                        d = d2 = BoxesRunTime.unboxToDouble((Object)object);
                        break block3;
                    }
                    if (!(object instanceof Number)) break block4;
                    Number number = (Number)object;
                    d = number.doubleValue();
                    break block3;
                }
                if (!(object instanceof String)) break block5;
                String string = (String)object;
                d = Double.parseDouble(this.normalizeString(string));
            }
            return d;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Type of value is ").append((Object)this.getTypeAsString(value)).append((Object)" not double").toString());
    }

    public String castToString(Object value) {
        String string;
        if (value == null) {
            return (String)value;
        }
        Object object = value;
        String string2 = object instanceof String ? (string = (String)object) : value.toString();
        return string2;
    }

    public Date castToDate(Object value) {
        block6: {
            Date date;
            block5: {
                Object object;
                block4: {
                    Date date2;
                    if (value == null) {
                        return (Date)value;
                    }
                    object = value;
                    if (!(object instanceof Date)) break block4;
                    date = date2 = (Date)object;
                    break block5;
                }
                if (!(object instanceof String)) break block6;
                String string = (String)object;
                date = this.localDateTimeFormat().parse(this.normalizeString(string));
            }
            return date;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Type of value is ").append((Object)this.getTypeAsString(value)).append((Object)" not Date").toString());
    }

    public Timestamp castToTimestamp(Object value) {
        block7: {
            Timestamp timestamp;
            block5: {
                Object object;
                block6: {
                    block4: {
                        Timestamp timestamp2;
                        if (value == null) {
                            return (Timestamp)value;
                        }
                        object = value;
                        if (!(object instanceof Timestamp)) break block4;
                        timestamp = timestamp2 = (Timestamp)object;
                        break block5;
                    }
                    if (!(object instanceof Date)) break block6;
                    Date date = (Date)object;
                    timestamp = new Timestamp(date.getTime());
                    break block5;
                }
                if (!(object instanceof String)) break block7;
                String string = (String)object;
                timestamp = new Timestamp(this.localDateTimeFormat().parse(this.normalizeString(string)).getTime());
            }
            return timestamp;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Type of value is ").append((Object)this.getTypeAsString(value)).append((Object)" not Date").toString());
    }

    private String normalizeString(String rawStr) {
        if (StringUtils.isEmpty((String)rawStr)) {
            throw new IllegalArgumentException("Invalid raw String value");
        }
        return rawStr.trim();
    }

    private int checkInt(long longValue) {
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer value out of range");
        }
        return (int)longValue;
    }

    /*
     * WARNING - void declaration
     */
    private String getTypeAsString(Object value) {
        void var2_3;
        String string;
        try {
            string = value.getClass().toString();
        }
        catch (Throwable throwable) {
            string = "unknown";
        }
        String valueType = string;
        return var2_3;
    }

    /*
     * Loose catch block
     */
    public Object parseString(String str) {
        Enumeration.Value dataType;
        Enumeration.Value value = dataType = this.inferDataType(str);
        Enumeration.Value value2 = package$DataType$.MODULE$.STRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            if (this.dateTimePattern().matcher(str).matches()) {
                return this.localDateTimeFormat().parse(str);
            }
            if (this.datePattern().matcher(str).matches()) {
                return this.localDateFormat().parse(str);
            }
            return str;
        }
        Enumeration.Value value4 = package$DataType$.MODULE$.NULL();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return str;
        }
        Enumeration.Value value6 = package$DataType$.MODULE$.BOOLEAN();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(str)).toBoolean());
        }
        Enumeration.Value value8 = package$DataType$.MODULE$.INTEGER();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return BoxesRunTime.boxToInteger((int)this.toInt(str));
        }
        Enumeration.Value value10 = package$DataType$.MODULE$.DECIMAL();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            String zeroStrippedStr = str.replaceFirst("\\.0*$|(\\.\\d*?)0+$", "$1");
            int numberOfSigD = zeroStrippedStr.replaceFirst("\\.", "").length();
            if (numberOfSigD > 7) {
                return BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(str)).toDouble());
            }
            return BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(str)).toFloat());
        }
        throw new Exception("invalid data type");
        catch (Exception exception) {
            return str;
        }
        catch (Exception exception) {
            return BoxesRunTime.boxToLong((long)this.toLong(str));
        }
    }

    public Enumeration.Value inferDataType(String str) {
        int length;
        block12: {
            block11: {
                if (str == null) {
                    return package$DataType$.MODULE$.NULL();
                }
                length = str.length();
                if (length == 0) {
                    return package$DataType$.MODULE$.NULL();
                }
                String string = str;
                String string2 = "true";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block11;
                String string3 = str;
                String string4 = "false";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block12;
            }
            return package$DataType$.MODULE$.BOOLEAN();
        }
        Enumeration.Value dataType = package$DataType$.MODULE$.INTEGER();
        char c = '\u0000';
        int i = 0;
        boolean hasDot = false;
        if (str.charAt(0) == '-') {
            i = 1;
        }
        while (i < length) {
            c = str.charAt(i);
            if (c < '0' || c > '9') {
                if (c == '.') {
                    if (hasDot) {
                        return package$DataType$.MODULE$.STRING();
                    }
                    dataType = package$DataType$.MODULE$.DECIMAL();
                } else {
                    return package$DataType$.MODULE$.STRING();
                }
            }
            ++i;
        }
        return dataType;
    }

    public boolean isValidDate(String text) {
        if (text == null || !this.datePattern().matcher(text).matches()) {
            return false;
        }
        SimpleDateFormat df = this.newDateFormat();
        df.setLenient(false);
        try {
            df.parse(text);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isValidDateTime(String text) {
        if (text == null || !this.dateTimePattern().matcher(text).matches()) {
            return false;
        }
        SimpleDateFormat df = this.newDateTimeFormat();
        df.setLenient(false);
        try {
            df.parse(text);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private package$() {
        MODULE$ = this;
        this.datePattern = Pattern.compile("\\d{4}-[01]\\d-[0-3]\\d");
        this.dateTimePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d{3}");
        this.localDateFormat = this.newDateFormat();
        this.localDateTimeFormat = this.newDateTimeFormat();
    }
}

