/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.HashMap;

public enum DataMode implements SerializationInterface
{
    PROFILE(-1),
    CENTROID(12),
    FITTED(20);

    private final int value;
    private static HashMap<Integer, DataMode> map;

    private DataMode(int val) {
        this.value = val;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        writer.writeInt32(this.value);
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        throw new IOException("read is not allowed for Enums");
    }

    public static DataMode getEnum(SerializationReader reader) throws IOException {
        int key = reader.readInt32();
        return map.get(key);
    }

    static {
        map = new HashMap();
        for (DataMode legEnum : DataMode.values()) {
            map.put(legEnum.value, legEnum);
        }
    }
}

