/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.FilterStatus;
import fr.proline.studio.table.LazyData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;

public abstract class Filter {
    protected ArrayList<Integer> m_valueKeys = null;
    protected HashMap<Integer, Component> m_components = null;
    protected String m_variableName;
    protected boolean m_used;
    protected boolean m_defined;
    private int m_index = -1;
    protected final int m_modelColumn;
    protected final int m_extraModelColumn;
    protected final ConvertValueInterface m_convertValueInterface;

    public Filter(String variableName, ConvertValueInterface convertValueInterface, int modelColumn) {
        this(variableName, convertValueInterface, modelColumn, -1);
    }

    public Filter(String variableName, ConvertValueInterface convertValueInterface, int modelColumn, int extraModelColumn) {
        this.m_variableName = variableName;
        this.m_convertValueInterface = convertValueInterface;
        this.m_modelColumn = modelColumn;
        this.m_extraModelColumn = extraModelColumn;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public int getIndex() {
        return this.m_index;
    }

    public abstract boolean filter(Object var1, Object var2);

    public abstract Filter cloneFilter4Search();

    public void setValuesForClone(Filter clone) {
        clone.m_used = this.m_used;
        clone.m_defined = this.m_defined;
        clone.m_valueKeys = this.m_valueKeys;
    }

    public int getModelColumn() {
        return this.m_modelColumn;
    }

    public int getExtraModelColumn() {
        return this.m_extraModelColumn;
    }

    public Object convertValue(Object o) {
        if (o instanceof LazyData) {
            o = ((LazyData)o).getData();
        }
        if (this.m_convertValueInterface == null) {
            return o;
        }
        return this.m_convertValueInterface.convertValue(o);
    }

    public abstract FilterStatus checkValues();

    public void registerDefinedAsUsed() {
        this.m_used = this.m_defined;
    }

    public abstract boolean registerValues();

    public ArrayList<Integer> getValueKeys() {
        return this.m_valueKeys;
    }

    public String getName() {
        return this.m_variableName;
    }

    public boolean isDefined() {
        return this.m_defined;
    }

    public void setDefined(boolean defined) {
        this.m_defined = defined;
    }

    public boolean isUsed() {
        return this.m_used;
    }

    public void setUsed(boolean used) {
        this.m_used = used;
    }

    public String toString() {
        return this.m_variableName;
    }

    public String toStringFull() {
        return "[" + this.getClass().getName() + "] " + this.m_variableName + " (isDefined: " + this.m_defined + ") (isUsed: " + this.m_used + ")";
    }

    public void registerComponent(Integer key, Component c) {
        if (this.m_components == null) {
            this.m_components = new HashMap();
        }
        this.m_components.put(key, c);
    }

    public Component getComponent(Integer key) {
        if (this.m_components == null) {
            return null;
        }
        return this.m_components.get(key);
    }

    public void clearComponents() {
        if (this.m_components == null) {
            return;
        }
        this.m_components.clear();
    }

    public abstract void createComponents(JPanel var1, GridBagConstraints var2);

    public abstract void reset();
}

