/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.colorpicker;

import fr.proline.studio.graphics.colorpicker.ColorDataInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class ColorPalettePanel
extends JPanel
implements MouseListener {
    private final BasicStroke STROKE_1 = new BasicStroke(1.0f);
    private final BasicStroke STROKE_3 = new BasicStroke(3.0f);
    private int m_squareSize;
    private int m_delta;
    private int m_paletteWidth;
    private ColorSquare[] m_squares = null;
    private Color[] m_palette = null;
    private ColorDataInterface m_colorDataInterface = null;

    public ColorPalettePanel(ColorDataInterface colorDataInterface, Color[] palette, int squareSize, int delta, int paletteWidth) {
        this.m_colorDataInterface = colorDataInterface;
        if (palette == null) {
            this.setPreferredSize(new Dimension(0, 0));
            return;
        }
        int paletteSize = palette.length;
        this.m_palette = palette;
        this.m_squareSize = squareSize;
        this.m_delta = delta;
        this.m_paletteWidth = paletteWidth;
        int paletteHeight = (paletteSize - 1) / 9 + 1;
        int heightPixel = paletteHeight * (this.m_squareSize + this.m_delta) + this.m_delta;
        int widthPixel = paletteWidth * (this.m_squareSize + this.m_delta) + this.m_delta;
        this.setPreferredSize(new Dimension(widthPixel, heightPixel));
        this.m_squares = new ColorSquare[paletteSize];
        for (int i = 0; i < paletteSize; ++i) {
            this.m_squares[i] = new ColorSquare(i);
        }
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.m_palette == null) {
            return;
        }
        int paletteSize = this.m_palette.length;
        int paletteWidth = 9;
        int paletteHeight = (paletteSize - 1) / 9 + 1;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.m_delta + paletteWidth * (this.m_delta + this.m_squareSize) - 1, this.m_delta + paletteHeight * (this.m_delta + this.m_squareSize) - 1);
        for (int i = 0; i < paletteSize; ++i) {
            this.m_squares[i].paint(g);
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, this.m_delta + paletteWidth * (this.m_delta + this.m_squareSize) - 1, this.m_delta + paletteHeight * (this.m_delta + this.m_squareSize) - 1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int paletteSize = this.m_palette.length;
        for (int i = 0; i < paletteSize; ++i) {
            if (!this.m_squares[i].inside(e.getX(), e.getY())) continue;
            Color c = this.m_palette[i];
            this.m_colorDataInterface.propagateColorChanged(c.getRed(), c.getGreen(), c.getBlue());
            break;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public class ColorSquare {
        private int m_index;

        public ColorSquare(int index) {
            this.m_index = index;
        }

        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(ColorPalettePanel.this.m_palette[this.m_index]);
            g2d.fillRect(this.getX(), this.getY(), ColorPalettePanel.this.m_squareSize, ColorPalettePanel.this.m_squareSize);
            g2d.setColor(Color.black);
            if (this.isSelected()) {
                g2d.setStroke(ColorPalettePanel.this.STROKE_3);
            } else {
                g2d.setStroke(ColorPalettePanel.this.STROKE_1);
            }
            g2d.drawRect(this.getX(), this.getY(), ColorPalettePanel.this.m_squareSize, ColorPalettePanel.this.m_squareSize);
            g2d.setStroke(ColorPalettePanel.this.STROKE_1);
        }

        private int getX() {
            int x = this.m_index % ColorPalettePanel.this.m_paletteWidth;
            return ColorPalettePanel.this.m_delta + x * (ColorPalettePanel.this.m_delta + ColorPalettePanel.this.m_squareSize);
        }

        private int getY() {
            int y = this.m_index / ColorPalettePanel.this.m_paletteWidth;
            return ColorPalettePanel.this.m_delta + y * (ColorPalettePanel.this.m_delta + ColorPalettePanel.this.m_squareSize);
        }

        private boolean isSelected() {
            Color c = ColorPalettePanel.this.m_palette[this.m_index];
            return ColorPalettePanel.this.m_colorDataInterface.getRed() == c.getRed() && ColorPalettePanel.this.m_colorDataInterface.getBlue() == c.getBlue() && ColorPalettePanel.this.m_colorDataInterface.getGreen() == c.getGreen();
        }

        public boolean inside(int x, int y) {
            int xSquare = this.getX();
            int ySquare = this.getY();
            return x >= xSquare && y >= ySquare && x <= xSquare + ColorPalettePanel.this.m_squareSize && y <= ySquare + ColorPalettePanel.this.m_squareSize;
        }
    }
}

