/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.marker;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.marker.AbstractMarker;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.ArrayList;

public class WaveformAreaMarker
extends AbstractMarker {
    private final Color m_fillColor;
    private ArrayList<PolygonData> m_polygonDataArray = new ArrayList();
    private PlotLinear m_plotLinear = null;

    public WaveformAreaMarker(BasePlotPanel plotPanel, PlotLinear plotLinear, Color fillColor, double x1, double x2) {
        super(plotPanel);
        this.m_plotLinear = plotLinear;
        this.m_fillColor = fillColor;
        this.prepareData(plotLinear, x1, x2);
    }

    public void setPlotLinear(PlotLinear plotLinear) {
        this.m_plotLinear = plotLinear;
    }

    public void set(double x1, double x2) {
        this.prepareData(this.m_plotLinear, x1, x2);
    }

    private void prepareData(PlotLinear plotLinear, double xStart, double xEnd) {
        int indexCur;
        if (plotLinear == null) {
            return;
        }
        this.m_polygonDataArray.clear();
        double[] dataX = plotLinear.getDataX();
        double[] dataY = plotLinear.getDataY();
        int nb = dataX.length;
        if (nb == 0) {
            return;
        }
        double[] tmpShapeX = new double[nb + 2];
        double[] tmpShapeY = new double[nb + 2];
        boolean SHAPE_OVER = false;
        boolean SHAPE_UNDER = true;
        int SHAPE_UNDEFINED = 2;
        int shapeType = 2;
        int indexShape = 0;
        double x0 = dataX[0];
        double y0 = dataY[0];
        for (int i = indexCur = 1; i < nb; ++i) {
            double x1 = dataX[i];
            double y1 = dataY[i];
            if (x0 <= xStart && x1 >= xStart) {
                double yStart = (xStart - x0) / (x1 - x0) * (y1 - y0) + y0;
                tmpShapeX[indexShape] = xStart;
                tmpShapeY[indexShape] = 0.0;
                ++indexShape;
                if (yStart != 0.0) {
                    tmpShapeX[indexShape] = xStart;
                    tmpShapeY[indexShape] = yStart;
                    ++indexShape;
                    shapeType = yStart > 0.0 ? 0 : 1;
                } else {
                    shapeType = 2;
                }
                indexCur = i;
                break;
            }
            x0 = x1;
            y0 = y1;
        }
        boolean finished = false;
        x0 = dataX[indexCur - 1];
        y0 = dataY[indexCur - 1];
        for (int i = indexCur; i < nb; ++i) {
            double x1 = dataX[i];
            double y1 = dataY[i];
            if (x1 >= xEnd) {
                y1 = (xEnd - x0) / (x1 - x0) * (y1 - y0) + y0;
                x1 = xEnd;
                finished = true;
            }
            if (y1 > 0.0) {
                if (shapeType == 0 || shapeType == 2) {
                    tmpShapeX[indexShape] = x1;
                    tmpShapeY[indexShape] = y1;
                    ++indexShape;
                } else {
                    tmpShapeX[indexShape] = xOnXAxis = -y0 / (y1 - y0) * (x1 - x0) + x0;
                    tmpShapeY[indexShape] = 0.0;
                    tmpShapeX[++indexShape] = tmpShapeX[0];
                    tmpShapeY[indexShape] = tmpShapeY[0];
                    this.m_polygonDataArray.add(new PolygonData(tmpShapeX, tmpShapeY, indexShape + 1));
                    tmpShapeX[0] = xOnXAxis;
                    tmpShapeY[0] = 0.0;
                    tmpShapeX[1] = x1;
                    tmpShapeY[1] = y1;
                    indexShape = 2;
                }
                shapeType = 0;
                if (finished) {
                    tmpShapeX[indexShape] = x1;
                    tmpShapeY[indexShape] = 0.0;
                    tmpShapeX[++indexShape] = tmpShapeX[0];
                    tmpShapeY[indexShape] = tmpShapeY[0];
                    this.m_polygonDataArray.add(new PolygonData(tmpShapeX, tmpShapeY, indexShape + 1));
                    break;
                }
            } else if (y1 < 0.0) {
                if (shapeType == 1 || shapeType == 2) {
                    tmpShapeX[indexShape] = x1;
                    tmpShapeY[indexShape] = y1;
                    ++indexShape;
                } else {
                    tmpShapeX[indexShape] = xOnXAxis = -y0 / (y1 - y0) * (x1 - x0) + x0;
                    tmpShapeY[indexShape] = 0.0;
                    tmpShapeX[++indexShape] = tmpShapeX[0];
                    tmpShapeY[indexShape] = tmpShapeY[0];
                    this.m_polygonDataArray.add(new PolygonData(tmpShapeX, tmpShapeY, indexShape + 1));
                    tmpShapeX[0] = xOnXAxis;
                    tmpShapeY[0] = 0.0;
                    tmpShapeX[1] = x1;
                    tmpShapeY[1] = y1;
                    indexShape = 2;
                }
                shapeType = 1;
            } else if (y1 == 0.0) {
                if (shapeType != 2) {
                    tmpShapeX[indexShape] = x1;
                    tmpShapeY[indexShape] = y1;
                    tmpShapeX[++indexShape] = tmpShapeX[0];
                    tmpShapeY[indexShape] = tmpShapeY[0];
                    this.m_polygonDataArray.add(new PolygonData(tmpShapeX, tmpShapeY, indexShape + 1));
                    shapeType = 2;
                }
                tmpShapeX[0] = x1;
                tmpShapeY[0] = 0.0;
                indexShape = 1;
            }
            x0 = x1;
            y0 = y1;
        }
    }

    @Override
    public void paint(Graphics2D g) {
        XAxis xAxis = this.m_plotPanel.getXAxis();
        YAxis yAxis = this.m_plotPanel.getYAxis();
        Shape previousClipping = g.getClip();
        int clipX = xAxis.valueToPixel(xAxis.getMinValue());
        int clipWidth = xAxis.valueToPixel(xAxis.getMaxValue()) - clipX;
        int clipY = yAxis.valueToPixel(yAxis.getMaxValue());
        int clipHeight = yAxis.valueToPixel(yAxis.getMinValue()) - clipY;
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        g.setColor(this.m_fillColor);
        for (PolygonData polygonData : this.m_polygonDataArray) {
            polygonData.prepareForPaint(xAxis, yAxis);
            g.fillPolygon(polygonData.getPolygon());
        }
        g.setClip(previousClipping);
    }

    public class PolygonData {
        private double[] m_x;
        private double[] m_y;
        private Polygon m_polygon;

        public PolygonData(double[] xSource, double[] ySource, int size) {
            this.m_x = new double[size];
            this.m_y = new double[size];
            System.arraycopy(xSource, 0, this.m_x, 0, size);
            System.arraycopy(ySource, 0, this.m_y, 0, size);
            this.m_polygon = new Polygon();
            this.m_polygon.npoints = size;
            this.m_polygon.xpoints = new int[size];
            this.m_polygon.ypoints = new int[size];
        }

        public void prepareForPaint(XAxis xAxis, YAxis yAxis) {
            int size = this.m_x.length;
            for (int i = 0; i < size; ++i) {
                this.m_polygon.xpoints[i] = xAxis.valueToPixel(this.m_x[i]);
                this.m_polygon.ypoints[i] = yAxis.valueToPixel(this.m_y[i]);
            }
        }

        public Polygon getPolygon() {
            return this.m_polygon;
        }
    }
}

