/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.utils.IconManager;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

public class AbstractParameterListTree
extends JPanel {
    private String rootName;
    private TreeSelectionListener m_selectionListener;
    private TreeWillExpandListener m_expandListener;
    private JTree tree;
    private DefaultMutableTreeNode m_root;
    private Hashtable<String, ParameterList> m_parameters;
    private Hashtable<String, DefaultMutableTreeNode> m_nodes;

    public AbstractParameterListTree(String rootName, TreeSelectionListener listener, TreeWillExpandListener expandListener) {
        this.rootName = rootName;
        this.m_selectionListener = listener;
        this.m_expandListener = expandListener;
        this.m_parameters = new Hashtable();
        this.m_nodes = new Hashtable();
        this.createTree();
    }

    private void createTree() {
        this.m_root = new DefaultMutableTreeNode(this.rootName);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(IconManager.getIcon(IconManager.IconType.FILE));
        renderer.setIcon(IconManager.getIcon(IconManager.IconType.FILE));
        renderer.setClosedIcon(IconManager.getIcon(IconManager.IconType.TOOLBOX_PLUS));
        renderer.setOpenIcon(IconManager.getIcon(IconManager.IconType.TOOLBOX_MINUS));
        this.tree = new JTree(this.m_root);
        this.tree.setCellRenderer(renderer);
        this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree.addTreeSelectionListener(this.m_selectionListener);
        this.tree.addTreeWillExpandListener(this.m_expandListener);
    }

    public void addNodes(ParameterList parameterList) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(parameterList.toString());
        this.m_parameters.put(parameterList.toString(), parameterList);
        this.m_nodes.put(parameterList.toString(), node);
        this.m_root.add(node);
    }

    public JTree getTree() {
        return this.tree;
    }

    public String getRootName() {
        return this.rootName;
    }

    public Hashtable<String, ParameterList> getList() {
        return this.m_parameters;
    }

    public void expandAllRows() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    public void selectNode(String key) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreeNode node = e.nextElement();
            if (!node.toString().equalsIgnoreCase(key)) continue;
            if (node.getParent() != null) {
                this.tree.setSelectionRow(node.getParent().getIndex(node) + 1);
            }
            return;
        }
    }
}

