/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.gui.DefaultDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public abstract class ConnectionDialog
extends DefaultDialog {
    protected JTextField m_serverURLTextField;
    protected JTextField m_userTextField;
    protected JPasswordField m_passwordField;
    protected JCheckBox m_rememberPasswordCheckBox;

    protected ConnectionDialog(Window parent, String title, String serverParameterLabel, String serverHostLabel) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(title);
        String tooltip = "if connecting to JMS Server, specify the server name or IP address. Otherwise enter the server host URL";
        JPanel internalPanel = this.createInternalPanel(serverParameterLabel, serverHostLabel, tooltip);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createInternalPanel(String serverParameterLabel, String serverHostLabel, String serverHostToolTip) {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JPanel URLPanel = this.createHostPanel(serverParameterLabel, serverHostLabel, serverHostToolTip);
        JPanel loginPanel = this.createLoginPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        internalPanel.add((Component)URLPanel, c);
        ++c.gridy;
        internalPanel.add((Component)loginPanel, c);
        return internalPanel;
    }

    private JPanel createHostPanel(String serverParameterLabel, String serverHostLabel, String serverHostToolTip) {
        JPanel URLPanel = new JPanel(new GridBagLayout());
        URLPanel.setBorder(BorderFactory.createTitledBorder(serverParameterLabel));
        JLabel serverLabel = new JLabel(serverHostLabel);
        if (serverHostToolTip != null) {
            serverLabel.setToolTipText(serverHostToolTip);
        }
        this.m_serverURLTextField = new JTextField(30);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        URLPanel.add((Component)serverLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        URLPanel.add((Component)this.m_serverURLTextField, c);
        return URLPanel;
    }

    private JPanel createLoginPanel() {
        JPanel loginPanel = new JPanel(new GridBagLayout());
        loginPanel.setBorder(BorderFactory.createTitledBorder(" User Parameters "));
        JLabel userLabel = new JLabel("User :");
        this.m_userTextField = new JTextField(30);
        JLabel passwordLabel = new JLabel("Password :");
        this.m_passwordField = new JPasswordField();
        this.m_rememberPasswordCheckBox = new JCheckBox("Remember Password");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        loginPanel.add((Component)userLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        loginPanel.add((Component)this.m_userTextField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        loginPanel.add((Component)passwordLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        loginPanel.add((Component)this.m_passwordField, c);
        ++c.gridy;
        loginPanel.add((Component)this.m_rememberPasswordCheckBox, c);
        return loginPanel;
    }

    @Override
    protected abstract boolean okCalled();

    @Override
    protected boolean cancelCalled() {
        return true;
    }

    @Override
    protected abstract boolean defaultCalled();

    protected boolean checkParameters() {
        String serverURL = this.m_serverURLTextField.getText();
        if (serverURL.isEmpty()) {
            this.setStatus(true, "You must fill the Server URL");
            this.highlight(this.m_serverURLTextField);
            return false;
        }
        String user = this.m_userTextField.getText();
        if (user.isEmpty()) {
            this.setStatus(true, "You must fill the User");
            this.highlight(this.m_userTextField);
            return false;
        }
        return true;
    }
}

