/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterValueRenderer;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ParametersComboPanel
extends JPanel {
    private AbstractParameter[] m_parameters;
    private JPanel m_selectedParametersPanel = null;
    private JComboBox m_comboBox = null;

    public ParametersComboPanel(String title, AbstractParameter[] parameters) {
        this.m_parameters = parameters;
        this.initComponent(title);
        this.updatePanel();
    }

    private void initComponent(String title) {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_selectedParametersPanel = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.m_selectedParametersPanel, c);
        this.m_comboBox = new JComboBox<AbstractParameter>(this.m_parameters);
        this.m_comboBox.setRenderer(new ParameterValueRenderer(null));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)this.m_comboBox, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)Box.createHorizontalBox(), c);
        this.m_comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                AbstractParameter p = (AbstractParameter)ParametersComboPanel.this.m_comboBox.getSelectedItem();
                if (p == null) {
                    return;
                }
                p.setUsed(true);
                ParametersComboPanel.this.updatePanel();
            }
        });
    }

    public void clearPanel() {
        this.updatePanel(true);
    }

    public void updatePanel() {
        this.updatePanel(false);
    }

    private void updatePanel(boolean clearItem) {
        this.m_selectedParametersPanel.removeAll();
        this.m_comboBox.removeAllItems();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 0;
        int nbUsed = 0;
        boolean putAndInFront = false;
        int nbParameters = this.m_parameters.length;
        for (int i = 0; i < nbParameters; ++i) {
            final AbstractParameter p = this.m_parameters[i];
            if (p != null && clearItem) {
                p.setUsed(false);
            }
            if (p != null && p.isUsed()) {
                c.gridx = 0;
                if (putAndInFront) {
                    this.m_selectedParametersPanel.add((Component)new JLabel("AND"), c);
                } else {
                    putAndInFront = true;
                    this.m_selectedParametersPanel.add((Component)new JLabel("   "), c);
                }
                ++c.gridx;
                JLabel prefilterNameLabel = new JLabel(p.getName());
                prefilterNameLabel.setHorizontalAlignment(4);
                this.m_selectedParametersPanel.add((Component)prefilterNameLabel, c);
                if (p.hasComponent().booleanValue()) {
                    ++c.gridx;
                    JLabel cmpLabel = new JLabel((String)p.getAssociatedData());
                    cmpLabel.setHorizontalAlignment(0);
                    this.m_selectedParametersPanel.add((Component)cmpLabel, c);
                    c.weightx = 1.0;
                    ++c.gridx;
                    this.m_selectedParametersPanel.add((Component)p.getComponent(), c);
                } else {
                    ++c.gridx;
                    ++c.gridx;
                }
                c.weightx = 0.0;
                ++c.gridx;
                JButton removeButton = new JButton(IconManager.getIcon(IconManager.IconType.CROSS_SMALL7));
                removeButton.setMargin(new Insets(2, 2, 2, 2));
                removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        p.setUsed(false);
                        ParametersComboPanel.this.updatePanel();
                    }
                });
                this.m_selectedParametersPanel.add((Component)removeButton, c);
                ++nbUsed;
                ++c.gridy;
                continue;
            }
            this.m_comboBox.addItem(p);
        }
        boolean hasUnusedParameters = nbUsed != nbParameters;
        this.m_comboBox.setVisible(hasUnusedParameters);
        this.revalidate();
    }
}

