/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.progress;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.progress.ProgressInterface;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressBarDialog
extends DefaultDialog {
    private static ProgressBarDialog m_dialog;
    private ProgressInterface m_progressInterface;
    private JProgressBar m_progressBar;
    private JLabel m_messageLabel;
    private Timer m_progressBarTimer = null;
    private boolean m_waitingFinished = false;

    public static ProgressBarDialog getDialog(Window parent, ProgressInterface progressInterface, String title, String message) {
        if (m_dialog == null) {
            m_dialog = new ProgressBarDialog(parent);
        }
        m_dialog.initDialog(progressInterface, title, message);
        return m_dialog;
    }

    public ProgressBarDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setButtonVisible(5, false);
        this.setButtonVisible(0, false);
        this.setStatusVisible(false);
        this.initInternalPanel();
    }

    private void initDialog(ProgressInterface progressInterface, String title, String message) {
        this.m_progressInterface = progressInterface;
        this.setTitle(title);
        this.m_messageLabel.setText(message);
        this.m_waitingFinished = false;
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.m_messageLabel = new JLabel();
        internalPanel.add((Component)this.m_messageLabel, c);
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setStringPainted(true);
        ++c.gridy;
        internalPanel.add((Component)this.m_progressBar, c);
        this.setInternalComponent(internalPanel);
    }

    public boolean isWaitingFinished() {
        return this.m_waitingFinished;
    }

    @Override
    public void setVisible(boolean v) {
        this.m_progressBar.setValue(0);
        this.m_progressBar.setIndeterminate(true);
        this.m_progressBar.setStringPainted(false);
        if (v) {
            this.m_progressBarTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProgressBarDialog.this.m_progressInterface.isLoaded()) {
                        ProgressBarDialog.this.m_waitingFinished = true;
                        ProgressBarDialog.this.m_progressBarTimer.stop();
                        ProgressBarDialog.this.setVisible(false);
                        return;
                    }
                    int percentage = ProgressBarDialog.this.m_progressInterface.getLoadingPercentage();
                    if (percentage > 0 && ProgressBarDialog.this.m_progressBar.isIndeterminate()) {
                        ProgressBarDialog.this.m_progressBar.setIndeterminate(false);
                        ProgressBarDialog.this.m_progressBar.setStringPainted(true);
                    }
                    ProgressBarDialog.this.m_progressBar.setValue(percentage);
                }
            });
            this.m_progressBarTimer.start();
        } else {
            this.m_progressBarTimer.stop();
        }
        super.setVisible(v);
    }
}

